/*
 * Decompiled with CFR 0.152.
 */
package tokyocabinet;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Random;
import tokyocabinet.ADB;
import tokyocabinet.Util;

class ADBTest {
    private static final PrintStream STDOUT = System.out;
    private static final PrintStream STDERR = System.err;
    private static final Random RND = new Random();

    public static void main(String[] stringArray) {
        int n = 0;
        if (stringArray.length < 1) {
            ADBTest.usage();
        }
        if (stringArray[0].equals("write")) {
            n = ADBTest.runwrite(stringArray);
        } else if (stringArray[0].equals("read")) {
            n = ADBTest.runread(stringArray);
        } else if (stringArray[0].equals("remove")) {
            n = ADBTest.runremove(stringArray);
        } else if (stringArray[0].equals("misc")) {
            n = ADBTest.runmisc(stringArray);
        } else {
            ADBTest.usage();
        }
        System.gc();
        System.exit(n);
    }

    private static void usage() {
        STDERR.println("test cases of the abstract database API");
        STDERR.println("");
        STDERR.println("synopsis:");
        STDERR.println("  java " + ADBTest.class.getName() + " arguments...");
        STDERR.println("");
        STDERR.println("arguments:");
        STDERR.println("  tcatest.rb write name rnum");
        STDERR.println("  tcatest.rb read name");
        STDERR.println("  tcatest.rb remove name");
        STDERR.println("  tcatest.rb misc name rnum");
        STDERR.println("");
        System.exit(1);
    }

    private static void eprint(ADB aDB, String string) {
        String string2 = aDB.path();
        STDERR.println(ADBTest.class.getName() + ": " + string2 + ": " + string + ": error");
    }

    private static int runwrite(String[] stringArray) {
        int n;
        String string = null;
        String string2 = null;
        for (n = 1; n < stringArray.length; ++n) {
            String string3 = stringArray[n];
            if (string == null && string3.startsWith("-")) {
                ADBTest.usage();
                continue;
            }
            if (string == null) {
                string = string3;
                continue;
            }
            if (string2 == null) {
                string2 = string3;
                continue;
            }
            ADBTest.usage();
        }
        if (string == null || string2 == null) {
            ADBTest.usage();
        }
        if ((n = Util.atoi(string2)) < 1) {
            ADBTest.usage();
        }
        int n2 = ADBTest.procwrite(string, n);
        return n2;
    }

    private static int runread(String[] stringArray) {
        int n;
        String string = null;
        for (n = 1; n < stringArray.length; ++n) {
            String string2 = stringArray[n];
            if (string == null && string2.startsWith("-")) {
                ADBTest.usage();
                continue;
            }
            if (string == null) {
                string = string2;
                continue;
            }
            ADBTest.usage();
        }
        if (string == null) {
            ADBTest.usage();
        }
        n = ADBTest.procread(string);
        return n;
    }

    private static int runremove(String[] stringArray) {
        int n;
        String string = null;
        for (n = 1; n < stringArray.length; ++n) {
            String string2 = stringArray[n];
            if (string == null && string2.startsWith("-")) {
                ADBTest.usage();
                continue;
            }
            if (string == null) {
                string = string2;
                continue;
            }
            ADBTest.usage();
        }
        if (string == null) {
            ADBTest.usage();
        }
        n = ADBTest.procremove(string);
        return n;
    }

    private static int runmisc(String[] stringArray) {
        int n;
        String string = null;
        String string2 = null;
        for (n = 1; n < stringArray.length; ++n) {
            String string3 = stringArray[n];
            if (string == null && string3.startsWith("-")) {
                ADBTest.usage();
                continue;
            }
            if (string == null) {
                string = string3;
                continue;
            }
            if (string2 == null) {
                string2 = string3;
                continue;
            }
            ADBTest.usage();
        }
        if (string == null || string2 == null) {
            ADBTest.usage();
        }
        if ((n = Util.atoi(string2)) < 1) {
            ADBTest.usage();
        }
        int n2 = ADBTest.procmisc(string, n);
        return n2;
    }

    private static int procwrite(String string, int n) {
        STDOUT.println("<Writing Test>");
        STDOUT.println("  name=" + string + "  rnum=" + n);
        STDOUT.println("");
        boolean bl = false;
        double d = Util.time();
        ADB aDB = new ADB();
        if (!aDB.open(string)) {
            ADBTest.eprint(aDB, "open");
            bl = true;
        }
        for (int i = 1; i <= n; ++i) {
            String string2 = Util.itoa(i, 8, '0');
            if (!aDB.put(string2, string2)) {
                ADBTest.eprint(aDB, "put");
                bl = true;
                break;
            }
            if (n <= 250 || i % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n && i % (n / 10) != 0) continue;
            STDOUT.println(" (" + string2 + ")");
        }
        STDOUT.println("record number: " + aDB.rnum());
        STDOUT.println("size: " + aDB.size());
        if (!aDB.close()) {
            ADBTest.eprint(aDB, "close");
            bl = true;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(bl ? "error" : "ok");
        STDOUT.println("");
        return bl ? 1 : 0;
    }

    private static int procread(String string) {
        STDOUT.println("<Reading Test>");
        STDOUT.println("  name=" + string);
        STDOUT.println("");
        boolean bl = false;
        double d = Util.time();
        ADB aDB = new ADB();
        if (!aDB.open(string)) {
            ADBTest.eprint(aDB, "open");
            bl = true;
        }
        int n = (int)aDB.rnum();
        for (int i = 1; i <= n; ++i) {
            String string2 = Util.itoa(i, 8, '0');
            if (aDB.get(string2) == null) {
                ADBTest.eprint(aDB, "get");
                bl = true;
                break;
            }
            if (n <= 250 || i % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n && i % (n / 10) != 0) continue;
            STDOUT.println(" (" + string2 + ")");
        }
        STDOUT.println("record number: " + aDB.rnum());
        STDOUT.println("size: " + aDB.size());
        if (!aDB.close()) {
            ADBTest.eprint(aDB, "close");
            bl = true;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(bl ? "error" : "ok");
        STDOUT.println("");
        return bl ? 1 : 0;
    }

    private static int procremove(String string) {
        STDOUT.println("<Removing Test>");
        STDOUT.println("  name=" + string);
        STDOUT.println("");
        boolean bl = false;
        double d = Util.time();
        ADB aDB = new ADB();
        if (!aDB.open(string)) {
            ADBTest.eprint(aDB, "open");
            bl = true;
        }
        int n = (int)aDB.rnum();
        for (int i = 1; i <= n; ++i) {
            String string2 = Util.itoa(i, 8, '0');
            if (!aDB.out(string2)) {
                ADBTest.eprint(aDB, "out");
                bl = true;
                break;
            }
            if (n <= 250 || i % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n && i % (n / 10) != 0) continue;
            STDOUT.println(" (" + string2 + ")");
        }
        STDOUT.println("record number: " + aDB.rnum());
        STDOUT.println("size: " + aDB.size());
        if (!aDB.close()) {
            ADBTest.eprint(aDB, "close");
            bl = true;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(bl ? "error" : "ok");
        STDOUT.println("");
        return bl ? 1 : 0;
    }

    private static int procmisc(String string, int n) {
        String string2;
        String string3;
        int n2;
        Object object;
        String string4;
        int n3;
        STDOUT.println("<Miscellaneous Test>");
        STDOUT.println("  name=" + string + "  rnum=" + n);
        STDOUT.println("");
        boolean bl = false;
        double d = Util.time();
        ADB aDB = new ADB();
        if (!aDB.open(string)) {
            ADBTest.eprint(aDB, "open");
            bl = true;
        }
        STDOUT.println("writing:");
        for (n3 = 1; n3 <= n; ++n3) {
            string4 = Util.itoa(n3, 8, '0');
            if (!aDB.put(string4, string4)) {
                ADBTest.eprint(aDB, "put");
                bl = true;
                break;
            }
            if (n <= 250 || n3 % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (n3 != n && n3 % (n / 10) != 0) continue;
            STDOUT.println(" (" + string4 + ")");
        }
        STDOUT.println("reading:");
        for (n3 = 1; n3 <= n; ++n3) {
            string4 = Util.itoa(n3, 8, '0');
            if (aDB.get(string4) == null) {
                ADBTest.eprint(aDB, "get");
                bl = true;
                break;
            }
            if (n <= 250 || n3 % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (n3 != n && n3 % (n / 10) != 0) continue;
            STDOUT.println(" (" + string4 + ")");
        }
        STDOUT.println("removing:");
        for (n3 = 1; n3 <= n; ++n3) {
            string4 = Util.itoa(n3, 8, '0');
            if (RND.nextInt(2) == 0 && !aDB.out(string4)) {
                ADBTest.eprint(aDB, "out");
                bl = true;
                break;
            }
            if (n <= 250 || n3 % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (n3 != n && n3 % (n / 10) != 0) continue;
            STDOUT.println(" (" + string4 + ")");
        }
        STDOUT.println("checking iterator:");
        if (!aDB.iterinit()) {
            ADBTest.eprint(aDB, "iterinit");
            bl = true;
        }
        n3 = 0;
        while ((string4 = aDB.iternext2()) != null) {
            object = aDB.get(string4);
            if (object == null) {
                ADBTest.eprint(aDB, "get");
                bl = true;
            }
            if (n3 > 0 && n > 250 && n3 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n3 == n || n3 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n3, 8, '0') + ")");
                }
            }
            ++n3;
        }
        if (n > 250) {
            STDOUT.println(" (" + Util.itoa(n3, 8, '0') + ")");
        }
        if ((long)n3 != aDB.rnum()) {
            ADBTest.eprint(aDB, "(validation)");
            bl = true;
        }
        object = aDB.fwmkeys("0", 10);
        if (aDB.rnum() >= 10L && object.size() != 10) {
            ADBTest.eprint(aDB, "fwmkeys");
            bl = true;
        }
        STDOUT.println("checking counting:");
        for (n2 = 1; n2 <= n; ++n2) {
            String string5 = "[" + RND.nextInt(n) + "]";
            if (RND.nextInt(2) == 0) {
                aDB.addint(string5, 1);
            } else {
                aDB.adddouble(string5, 1.0);
            }
            if (n <= 250 || n2 % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (n2 != n && n2 % (n / 10) != 0) continue;
            STDOUT.println(" (" + Util.itoa(n2, 8, '0') + ")");
        }
        STDOUT.println("checking versatile functions:");
        for (n2 = 1; n2 <= n; ++n2) {
            int n4 = RND.nextInt(3);
            string3 = n4 == 0 ? "putlist" : (n4 == 1 ? "outlist" : "getlist");
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(RND.nextInt(n));
            arrayList.add(RND.nextInt(n));
            if (aDB.misc(string3, arrayList) == null) {
                ADBTest.eprint(aDB, "(validation)");
                bl = true;
                break;
            }
            if (n <= 250 || n2 % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (n2 != n && n2 % (n / 10) != 0) continue;
            STDOUT.println(" (" + Util.itoa(n2, 8, '0') + ")");
        }
        if (!aDB.sync()) {
            ADBTest.eprint(aDB, "sync");
            bl = true;
        }
        if (!aDB.optimize()) {
            ADBTest.eprint(aDB, "optimize");
            bl = true;
        }
        if (!aDB.copy(string2 = aDB.path() + "-tmp")) {
            ADBTest.eprint(aDB, "copy");
            bl = true;
        }
        new File(string2).delete();
        if (!aDB.vanish()) {
            ADBTest.eprint(aDB, "vanish");
            bl = true;
        }
        STDOUT.println("checking transaction commit:");
        if (!aDB.tranbegin()) {
            ADBTest.eprint(aDB, "tranbegin");
            bl = true;
        }
        for (int i = 1; i <= n; ++i) {
            string3 = i + "";
            if (RND.nextInt(2) == 0) {
                if (!aDB.putcat(string3, string3)) {
                    ADBTest.eprint(aDB, "putcat");
                    bl = true;
                    break;
                }
            } else {
                aDB.out(string3);
            }
            if (n <= 250 || i % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n && i % (n / 10) != 0) continue;
            STDOUT.println(" (" + Util.itoa(i, 8, '0') + ")");
        }
        if (!aDB.trancommit()) {
            ADBTest.eprint(aDB, "trancommit");
            bl = true;
        }
        STDOUT.println("checking transaction abort:");
        long l = aDB.rnum();
        long l2 = aDB.fsiz();
        if (!aDB.tranbegin()) {
            ADBTest.eprint(aDB, "tranbegin");
            bl = true;
        }
        for (int i = 1; i <= n; ++i) {
            String string6 = i + "";
            if (RND.nextInt(2) == 0) {
                if (!aDB.putcat(string6, string6)) {
                    ADBTest.eprint(aDB, "putcat");
                    bl = true;
                    break;
                }
            } else {
                aDB.out(string6);
            }
            if (n <= 250 || i % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n && i % (n / 10) != 0) continue;
            STDOUT.println(" (" + Util.itoa(i, 8, '0') + ")");
        }
        if (!aDB.tranabort()) {
            ADBTest.eprint(aDB, "trancommit");
            bl = true;
        }
        if (aDB.rnum() != l || aDB.fsiz() != l2) {
            ADBTest.eprint(aDB, "(validation)");
            bl = true;
        }
        STDOUT.println("checking common interface:");
        ADB aDB2 = aDB;
        for (int i = 1; i <= n; ++i) {
            String string7 = "[" + Util.itoa(RND.nextInt(n), 8, '0') + "]";
            int n5 = RND.nextInt(3);
            if (n5 == 0) {
                aDB2.put(string7, string7);
            } else if (n5 == 1) {
                aDB2.get(string7);
            } else {
                aDB2.out(string7);
            }
            if (n <= 250 || i % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n && i % (n / 10) != 0) continue;
            STDOUT.println(" (" + Util.itoa(i, 8, '0') + ")");
        }
        STDOUT.println("checking iterator:");
        n3 = 0;
        if (!aDB2.iterinit()) {
            ADBTest.eprint(aDB, "iterinit");
            bl = true;
        }
        while ((string4 = aDB2.iternext2()) != null) {
            String string8 = aDB2.get(string4);
            if (string8 == null) {
                ADBTest.eprint(aDB, "get");
                bl = true;
            }
            if (n3 > 0 && n > 250 && n3 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n3 == n || n3 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n3, 8, '0') + ")");
                }
            }
            ++n3;
        }
        if (n > 250) {
            STDOUT.println(" (" + Util.itoa(n3, 8, '0') + ")");
        }
        STDOUT.println("record number: " + aDB.rnum());
        STDOUT.println("size: " + aDB.size());
        if (!aDB.close()) {
            ADBTest.eprint(aDB, "close");
            bl = true;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(bl ? "error" : "ok");
        STDOUT.println("");
        return bl ? 1 : 0;
    }

    private ADBTest() throws NoSuchMethodException {
        throw new NoSuchMethodException();
    }
}

