/*
 * Decompiled with CFR 0.152.
 */
package tokyocabinet;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import tokyocabinet.BDB;
import tokyocabinet.BDBCUR;
import tokyocabinet.Util;

class BDBTest {
    private static final PrintStream STDOUT = System.out;
    private static final PrintStream STDERR = System.err;
    private static final Random RND = new Random();

    public static void main(String[] stringArray) {
        int n = 0;
        if (stringArray.length < 1) {
            BDBTest.usage();
        }
        if (stringArray[0].equals("write")) {
            n = BDBTest.runwrite(stringArray);
        } else if (stringArray[0].equals("read")) {
            n = BDBTest.runread(stringArray);
        } else if (stringArray[0].equals("remove")) {
            n = BDBTest.runremove(stringArray);
        } else if (stringArray[0].equals("misc")) {
            n = BDBTest.runmisc(stringArray);
        } else {
            BDBTest.usage();
        }
        System.gc();
        System.exit(n);
    }

    private static void usage() {
        STDERR.println("test cases of the B+ tree database API");
        STDERR.println("");
        STDERR.println("synopsis:");
        STDERR.println("  java " + BDBTest.class.getName() + " arguments...");
        STDERR.println("");
        STDERR.println("arguments:");
        STDERR.println("  tcbtest.rb write [-tl] [-td|-tb|-tt] [-nl|-nb] path rnum [lmemb [nmemb [bnum [apow [fpow]]]]]");
        STDERR.println("  tcbtest.rb read [-nl|-nb] path");
        STDERR.println("  tcbtest.rb remove [-nl|-nb] path");
        STDERR.println("  tcbtest.rb misc [-tl] [-td|-tb|-tt] [-nl|-nb] path rnum");
        STDERR.println("");
        System.exit(1);
    }

    private static void eprint(BDB bDB, String string) {
        String string2 = bDB.path();
        STDERR.println(BDBTest.class.getName() + ": " + string2 + ": " + string + ": " + bDB.errmsg());
    }

    private static int runwrite(String[] stringArray) {
        int n;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        int n2 = 0;
        int n3 = 0;
        for (n = 1; n < stringArray.length; ++n) {
            String string8 = stringArray[n];
            if (string == null && string8.startsWith("-")) {
                if (string8.equals("-tl")) {
                    n2 |= 1;
                    continue;
                }
                if (string8.equals("-td")) {
                    n2 |= 2;
                    continue;
                }
                if (string8.equals("-tb")) {
                    n2 |= 4;
                    continue;
                }
                if (string8.equals("-tt")) {
                    n2 |= 8;
                    continue;
                }
                if (string8.equals("-nl")) {
                    n3 |= 0x10;
                    continue;
                }
                if (string8.equals("-nb")) {
                    n3 |= 0x20;
                    continue;
                }
                BDBTest.usage();
                continue;
            }
            if (string == null) {
                string = string8;
                continue;
            }
            if (string2 == null) {
                string2 = string8;
                continue;
            }
            if (string3 == null) {
                string3 = string8;
                continue;
            }
            if (string4 == null) {
                string4 = string8;
                continue;
            }
            if (string5 == null) {
                string5 = string8;
                continue;
            }
            if (string6 == null) {
                string6 = string8;
                continue;
            }
            if (string7 == null) {
                string7 = string8;
                continue;
            }
            BDBTest.usage();
        }
        if (string == null || string2 == null) {
            BDBTest.usage();
        }
        if ((n = Util.atoi(string2)) < 1) {
            BDBTest.usage();
        }
        int n4 = string3 != null ? Util.atoi(string3) : -1;
        int n5 = string4 != null ? Util.atoi(string4) : -1;
        int n6 = string5 != null ? Util.atoi(string5) : -1;
        int n7 = string6 != null ? Util.atoi(string6) : -1;
        int n8 = string7 != null ? Util.atoi(string7) : -1;
        int n9 = BDBTest.procwrite(string, n, n4, n5, n6, n7, n8, n2, n3);
        return n9;
    }

    private static int runread(String[] stringArray) {
        int n;
        String string = null;
        int n2 = 0;
        for (n = 1; n < stringArray.length; ++n) {
            String string2 = stringArray[n];
            if (string == null && string2.startsWith("-")) {
                if (string2.equals("-nl")) {
                    n2 |= 0x10;
                    continue;
                }
                if (string2.equals("-nb")) {
                    n2 |= 0x20;
                    continue;
                }
                BDBTest.usage();
                continue;
            }
            if (string == null) {
                string = string2;
                continue;
            }
            BDBTest.usage();
        }
        if (string == null) {
            BDBTest.usage();
        }
        n = BDBTest.procread(string, n2);
        return n;
    }

    private static int runremove(String[] stringArray) {
        int n;
        String string = null;
        int n2 = 0;
        for (n = 1; n < stringArray.length; ++n) {
            String string2 = stringArray[n];
            if (string == null && string2.startsWith("-")) {
                if (string2.equals("-nl")) {
                    n2 |= 0x10;
                    continue;
                }
                if (string2.equals("-nb")) {
                    n2 |= 0x20;
                    continue;
                }
                BDBTest.usage();
                continue;
            }
            if (string == null) {
                string = string2;
                continue;
            }
            BDBTest.usage();
        }
        if (string == null) {
            BDBTest.usage();
        }
        n = BDBTest.procremove(string, n2);
        return n;
    }

    private static int runmisc(String[] stringArray) {
        int n;
        String string = null;
        String string2 = null;
        int n2 = 0;
        int n3 = 0;
        for (n = 1; n < stringArray.length; ++n) {
            String string3 = stringArray[n];
            if (string == null && string3.startsWith("-")) {
                if (string3.equals("-tl")) {
                    n2 |= 1;
                    continue;
                }
                if (string3.equals("-td")) {
                    n2 |= 2;
                    continue;
                }
                if (string3.equals("-tb")) {
                    n2 |= 4;
                    continue;
                }
                if (string3.equals("-tt")) {
                    n2 |= 8;
                    continue;
                }
                if (string3.equals("-nl")) {
                    n3 |= 0x10;
                    continue;
                }
                if (string3.equals("-nb")) {
                    n3 |= 0x20;
                    continue;
                }
                BDBTest.usage();
                continue;
            }
            if (string == null) {
                string = string3;
                continue;
            }
            if (string2 == null) {
                string2 = string3;
                continue;
            }
            BDBTest.usage();
        }
        if (string == null || string2 == null) {
            BDBTest.usage();
        }
        if ((n = Util.atoi(string2)) < 1) {
            BDBTest.usage();
        }
        int n4 = BDBTest.procmisc(string, n, n2, n3);
        return n4;
    }

    private static int procwrite(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        STDOUT.println("<Writing Test>");
        STDOUT.println("  path=" + string + "  rnum=" + n + "  lmemb=" + n2 + "  nmemb=" + n3 + "  bnum=" + n4 + "  apow=" + n5 + "  fpow=" + n6 + "  opts=" + n7 + "  omode=" + n8);
        STDOUT.println("");
        boolean bl = false;
        double d = Util.time();
        BDB bDB = new BDB();
        if (!bDB.tune(n2, n3, n4, n5, n6, n7)) {
            BDBTest.eprint(bDB, "tune");
            bl = true;
        }
        if (!bDB.open(string, 0xE | n8)) {
            BDBTest.eprint(bDB, "open");
            bl = true;
        }
        for (int i = 1; i <= n; ++i) {
            String string2 = Util.itoa(i, 8, '0');
            if (!bDB.put(string2, string2)) {
                BDBTest.eprint(bDB, "put");
                bl = true;
                break;
            }
            if (n <= 250 || i % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n && i % (n / 10) != 0) continue;
            STDOUT.println(" (" + string2 + ")");
        }
        STDOUT.println("record number: " + bDB.rnum());
        STDOUT.println("size: " + bDB.fsiz());
        if (!bDB.close()) {
            BDBTest.eprint(bDB, "close");
            bl = true;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(bl ? "error" : "ok");
        STDOUT.println("");
        return bl ? 1 : 0;
    }

    private static int procread(String string, int n) {
        STDOUT.println("<Reading Test>");
        STDOUT.println("  path=" + string + "  omode=" + n);
        STDOUT.println("");
        boolean bl = false;
        double d = Util.time();
        BDB bDB = new BDB();
        if (!bDB.open(string, 1 | n)) {
            BDBTest.eprint(bDB, "open");
            bl = true;
        }
        int n2 = (int)bDB.rnum();
        for (int i = 1; i <= n2; ++i) {
            String string2 = Util.itoa(i, 8, '0');
            if (bDB.get(string2) == null) {
                BDBTest.eprint(bDB, "get");
                bl = true;
                break;
            }
            if (n2 <= 250 || i % (n2 / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n2 && i % (n2 / 10) != 0) continue;
            STDOUT.println(" (" + string2 + ")");
        }
        STDOUT.println("record number: " + bDB.rnum());
        STDOUT.println("size: " + bDB.fsiz());
        if (!bDB.close()) {
            BDBTest.eprint(bDB, "close");
            bl = true;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(bl ? "error" : "ok");
        STDOUT.println("");
        return bl ? 1 : 0;
    }

    private static int procremove(String string, int n) {
        STDOUT.println("<Removing Test>");
        STDOUT.println("  path=" + string + "  omode=" + n);
        STDOUT.println("");
        boolean bl = false;
        double d = Util.time();
        BDB bDB = new BDB();
        if (!bDB.open(string, 2 | n)) {
            BDBTest.eprint(bDB, "open");
            bl = true;
        }
        int n2 = (int)bDB.rnum();
        for (int i = 1; i <= n2; ++i) {
            String string2 = Util.itoa(i, 8, '0');
            if (!bDB.out(string2)) {
                BDBTest.eprint(bDB, "out");
                bl = true;
                break;
            }
            if (n2 <= 250 || i % (n2 / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n2 && i % (n2 / 10) != 0) continue;
            STDOUT.println(" (" + string2 + ")");
        }
        STDOUT.println("record number: " + bDB.rnum());
        STDOUT.println("size: " + bDB.fsiz());
        if (!bDB.close()) {
            BDBTest.eprint(bDB, "close");
            bl = true;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(bl ? "error" : "ok");
        STDOUT.println("");
        return bl ? 1 : 0;
    }

    private static int procmisc(String string, int n, int n2, int n3) {
        int n4;
        Object object;
        int n5;
        String string2;
        Object object2;
        String string3;
        String string4;
        int n6;
        STDOUT.println("<Miscellaneous Test>");
        STDOUT.println("  path=" + string + "  rnum=" + n + "  opts=" + n2 + "  omode=" + n3);
        STDOUT.println("");
        boolean bl = false;
        double d = Util.time();
        BDB bDB = new BDB();
        if (!bDB.tune(10, 10, n / 50, 2, -1, n2)) {
            BDBTest.eprint(bDB, "tune");
            bl = true;
        }
        if (!bDB.setcache(128, 256)) {
            BDBTest.eprint(bDB, "setcache");
            bl = true;
        }
        if (!bDB.setxmsiz(n * 4)) {
            BDBTest.eprint(bDB, "setxmsiz");
            bl = true;
        }
        if (!bDB.setdfunit(8)) {
            BDBTest.eprint(bDB, "setdfunit");
            bl = true;
        }
        if (!bDB.open(string, 0xE | n3)) {
            BDBTest.eprint(bDB, "open");
            bl = true;
        }
        STDOUT.println("writing:");
        for (n6 = 1; n6 <= n; ++n6) {
            string4 = Util.itoa(n6, 8, '0');
            if (!bDB.put(string4, string4)) {
                BDBTest.eprint(bDB, "put");
                bl = true;
                break;
            }
            if (n <= 250 || n6 % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (n6 != n && n6 % (n / 10) != 0) continue;
            STDOUT.println(" (" + string4 + ")");
        }
        STDOUT.println("reading:");
        for (n6 = 1; n6 <= n; ++n6) {
            string4 = Util.itoa(n6, 8, '0');
            if (bDB.get(string4) == null) {
                BDBTest.eprint(bDB, "get");
                bl = true;
                break;
            }
            if (n <= 250 || n6 % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (n6 != n && n6 % (n / 10) != 0) continue;
            STDOUT.println(" (" + string4 + ")");
        }
        STDOUT.println("removing:");
        for (n6 = 1; n6 <= n; ++n6) {
            string4 = Util.itoa(n6, 8, '0');
            if (RND.nextInt(2) == 0 && !bDB.out(string4)) {
                BDBTest.eprint(bDB, "get");
                bl = true;
                break;
            }
            if (n <= 250 || n6 % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (n6 != n && n6 % (n / 10) != 0) continue;
            STDOUT.println(" (" + string4 + ")");
        }
        STDOUT.println("checking cursor:");
        BDBCUR bDBCUR = new BDBCUR(bDB);
        if (!bDBCUR.first() && bDB.ecode() != 22) {
            BDBTest.eprint(bDB, "cur::first");
            bl = true;
        }
        int n7 = 0;
        while ((string3 = bDBCUR.key2()) != null) {
            object2 = bDBCUR.val2();
            if (object2 == null) {
                BDBTest.eprint(bDB, "cur::val");
                bl = true;
            }
            bDBCUR.next();
            if (n7 > 0 && n > 250 && n7 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n7 == n || n7 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n7, 8, '0') + ")");
                }
            }
            ++n7;
        }
        if (n > 250) {
            STDOUT.println(" (" + Util.itoa(n7, 8, '0') + ")");
        }
        if (bDB.ecode() != 22 || (long)n7 != bDB.rnum()) {
            BDBTest.eprint(bDB, "(validation)");
            bl = true;
        }
        object2 = bDB.fwmkeys("0", 10);
        if (bDB.rnum() >= 10L && object2.size() != 10) {
            BDBTest.eprint(bDB, "fwmkeys");
            bl = true;
        }
        STDOUT.println("checking counting:");
        for (int i = 1; i <= n; ++i) {
            String string5 = "[" + RND.nextInt(n) + "]";
            if (RND.nextInt(2) == 0) {
                if (bDB.addint(string5, 1) == Integer.MIN_VALUE && bDB.ecode() != 21) {
                    BDBTest.eprint(bDB, "addint");
                    bl = true;
                    break;
                }
            } else if (bDB.adddouble(string5, 1.0) == -2.147483648E9 && bDB.ecode() != 21) {
                BDBTest.eprint(bDB, "adddouble");
                bl = true;
                break;
            }
            if (n <= 250 || i % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n && i % (n / 10) != 0) continue;
            STDOUT.println(" (" + Util.itoa(i, 8, '0') + ")");
        }
        if (!bDB.sync()) {
            BDBTest.eprint(bDB, "sync");
            bl = true;
        }
        if (!bDB.optimize()) {
            BDBTest.eprint(bDB, "optimize");
            bl = true;
        }
        if (!bDB.copy(string2 = string + "-tmp")) {
            BDBTest.eprint(bDB, "copy");
            bl = true;
        }
        new File(string2).delete();
        if (!bDB.vanish()) {
            BDBTest.eprint(bDB, "vanish");
            bl = true;
        }
        STDOUT.println("random writing:");
        for (n5 = 1; n5 <= n; ++n5) {
            object = Util.itoa(RND.nextInt(n5), 8, '0');
            if (!bDB.putdup((String)object, (String)object)) {
                BDBTest.eprint(bDB, "putdup");
                bl = true;
                break;
            }
            if (n <= 250 || n5 % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (n5 != n && n5 % (n / 10) != 0) continue;
            STDOUT.println(" (" + Util.itoa(n5, 8, '0') + ")");
        }
        STDOUT.println("cursor updating:");
        for (n5 = 1; n5 <= n; ++n5) {
            if (RND.nextInt(10) == 0) {
                object = Util.itoa(RND.nextInt(n), 8, '0');
                bDBCUR.jump((String)object);
                for (int i = 1; i <= 10 && (string3 = bDBCUR.key2()) != null; ++i) {
                    if (RND.nextInt(3) == 0) {
                        bDBCUR.out();
                    } else {
                        n4 = 0 + RND.nextInt(3);
                        bDBCUR.put((String)object, n4);
                    }
                    bDBCUR.next();
                }
            }
            if (n <= 250 || n5 % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (n5 != n && n5 % (n / 10) != 0) continue;
            STDOUT.println(" (" + Util.itoa(n5, 8, '0') + ")");
        }
        if (!bDB.tranbegin()) {
            BDBTest.eprint(bDB, "tranbegin");
            bl = true;
        }
        bDB.putdup("::1", "1");
        bDB.putdup("::2", "2a");
        bDB.putdup("::2", "2b");
        bDB.putdup("::3", "3");
        bDBCUR.jump("::2");
        bDBCUR.put("2A", 0);
        bDBCUR.put("2-", 1);
        bDBCUR.put("2+", 0);
        bDBCUR.next();
        bDBCUR.next();
        bDBCUR.put("mid", 1);
        bDBCUR.put("2C", 2);
        bDBCUR.prev();
        bDBCUR.out();
        List<String> list = bDB.getlist("::2");
        if (list == null || list.size() != 4) {
            BDBTest.eprint(bDB, "getlist");
            bl = true;
        }
        object = new ArrayList();
        object.add("hop");
        object.add("step");
        object.add("jump");
        if (!bDB.putlist("::1", (List<String>)object)) {
            BDBTest.eprint(bDB, "putlist");
            bl = true;
        }
        if (!bDB.outlist("::1")) {
            BDBTest.eprint(bDB, "outlist");
            bl = true;
        }
        if (!bDB.trancommit()) {
            BDBTest.eprint(bDB, "trancommit");
            bl = true;
        }
        if (!bDB.tranbegin() || !bDB.tranabort()) {
            BDBTest.eprint(bDB, "tranbegin");
            bl = true;
        }
        STDOUT.println("checking common interface:");
        BDB bDB2 = bDB;
        for (n4 = 1; n4 <= n; ++n4) {
            String string6 = "[" + Util.itoa(RND.nextInt(n), 8, '0') + "]";
            int n8 = RND.nextInt(3);
            if (n8 == 0) {
                bDB2.put(string6, string6);
            } else if (n8 == 1) {
                bDB2.get(string6);
            } else {
                bDB2.out(string6);
            }
            if (n <= 250 || n4 % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (n4 != n && n4 % (n / 10) != 0) continue;
            STDOUT.println(" (" + Util.itoa(n4, 8, '0') + ")");
        }
        STDOUT.println("checking iterator:");
        n7 = 0;
        if (!bDB2.iterinit()) {
            BDBTest.eprint(bDB, "iterinit");
            bl = true;
        }
        while ((string3 = bDB2.iternext2()) != null) {
            String string7 = bDB2.get(string3);
            if (string7 == null) {
                BDBTest.eprint(bDB, "get");
                bl = true;
            }
            if (n7 > 0 && n > 250 && n7 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n7 == n || n7 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n7, 8, '0') + ")");
                }
            }
            ++n7;
        }
        if (n > 250) {
            STDOUT.println(" (" + Util.itoa(n7, 8, '0') + ")");
        }
        STDOUT.println("record number: " + bDB.rnum());
        STDOUT.println("size: " + bDB.fsiz());
        if (!bDB.close()) {
            BDBTest.eprint(bDB, "close");
            bl = true;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(bl ? "error" : "ok");
        STDOUT.println("");
        return bl ? 1 : 0;
    }

    private BDBTest() throws NoSuchMethodException {
        throw new NoSuchMethodException();
    }
}

