/*
 * Decompiled with CFR 0.152.
 */
package tokyocabinet;

import java.io.File;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import tokyocabinet.TDB;
import tokyocabinet.TDBQRY;
import tokyocabinet.TDBQRYPROC;
import tokyocabinet.Util;

class TDBTest {
    private static final PrintStream STDOUT = System.out;
    private static final PrintStream STDERR = System.err;
    private static final Random RND = new Random();

    public static void main(String[] stringArray) {
        int n = 0;
        if (stringArray.length < 1) {
            TDBTest.usage();
        }
        if (stringArray[0].equals("write")) {
            n = TDBTest.runwrite(stringArray);
        } else if (stringArray[0].equals("read")) {
            n = TDBTest.runread(stringArray);
        } else if (stringArray[0].equals("remove")) {
            n = TDBTest.runremove(stringArray);
        } else if (stringArray[0].equals("misc")) {
            n = TDBTest.runmisc(stringArray);
        } else {
            TDBTest.usage();
        }
        System.gc();
        System.exit(n);
    }

    private static void usage() {
        STDERR.println("test cases of the hash database API");
        STDERR.println("");
        STDERR.println("synopsis:");
        STDERR.println("  java " + TDBTest.class.getName() + " arguments...");
        STDERR.println("");
        STDERR.println("arguments:");
        STDERR.println("  tchtest.rb write [-tl] [-td|-tb] [-ip|-is|-in|-it|-if|-ix] [-nl|-nb]  path rnum [bnum [apow [fpow]]]");
        STDERR.println("  tchtest.rb read [-nl|-nb] path");
        STDERR.println("  tchtest.rb remove [-nl|-nb] path");
        STDERR.println("  tchtest.rb misc [-tl] [-td|-tb] [-nl|-nb] path rnum");
        STDERR.println("");
        System.exit(1);
    }

    private static void eprint(TDB tDB, String string) {
        String string2 = tDB.path();
        STDERR.println(TDBTest.class.getName() + ": " + string2 + ": " + string + ": " + tDB.errmsg());
    }

    private static int runwrite(String[] stringArray) {
        int n;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (n = 1; n < stringArray.length; ++n) {
            String string6 = stringArray[n];
            if (string == null && string6.startsWith("-")) {
                if (string6.equals("-tl")) {
                    n2 |= 1;
                    continue;
                }
                if (string6.equals("-td")) {
                    n2 |= 2;
                    continue;
                }
                if (string6.equals("-tb")) {
                    n2 |= 4;
                    continue;
                }
                if (string6.equals("-tt")) {
                    n2 |= 8;
                    continue;
                }
                if (string6.equals("-ip")) {
                    n3 |= 1;
                    continue;
                }
                if (string6.equals("-is")) {
                    n3 |= 2;
                    continue;
                }
                if (string6.equals("-in")) {
                    n3 |= 4;
                    continue;
                }
                if (string6.equals("-it")) {
                    n3 |= 8;
                    continue;
                }
                if (string6.equals("-if")) {
                    n3 |= 0x10;
                    continue;
                }
                if (string6.equals("-ix")) {
                    n3 |= 0x20;
                    continue;
                }
                if (string6.equals("-nl")) {
                    n4 |= 0x10;
                    continue;
                }
                if (string6.equals("-nb")) {
                    n4 |= 0x20;
                    continue;
                }
                TDBTest.usage();
                continue;
            }
            if (string == null) {
                string = string6;
                continue;
            }
            if (string2 == null) {
                string2 = string6;
                continue;
            }
            if (string3 == null) {
                string3 = string6;
                continue;
            }
            if (string4 == null) {
                string4 = string6;
                continue;
            }
            if (string5 == null) {
                string5 = string6;
                continue;
            }
            TDBTest.usage();
        }
        if (string == null || string2 == null) {
            TDBTest.usage();
        }
        if ((n = Util.atoi(string2)) < 1) {
            TDBTest.usage();
        }
        int n5 = string3 != null ? Util.atoi(string3) : -1;
        int n6 = string4 != null ? Util.atoi(string4) : -1;
        int n7 = string5 != null ? Util.atoi(string5) : -1;
        int n8 = TDBTest.procwrite(string, n, n5, n6, n7, n2, n3, n4);
        return n8;
    }

    private static int runread(String[] stringArray) {
        int n;
        String string = null;
        int n2 = 0;
        for (n = 1; n < stringArray.length; ++n) {
            String string2 = stringArray[n];
            if (string == null && string2.startsWith("-")) {
                if (string2.equals("-nl")) {
                    n2 |= 0x10;
                    continue;
                }
                if (string2.equals("-nb")) {
                    n2 |= 0x20;
                    continue;
                }
                TDBTest.usage();
                continue;
            }
            if (string == null) {
                string = string2;
                continue;
            }
            TDBTest.usage();
        }
        if (string == null) {
            TDBTest.usage();
        }
        n = TDBTest.procread(string, n2);
        return n;
    }

    private static int runremove(String[] stringArray) {
        int n;
        String string = null;
        int n2 = 0;
        for (n = 1; n < stringArray.length; ++n) {
            String string2 = stringArray[n];
            if (string == null && string2.startsWith("-")) {
                if (string2.equals("-nl")) {
                    n2 |= 0x10;
                    continue;
                }
                if (string2.equals("-nb")) {
                    n2 |= 0x20;
                    continue;
                }
                TDBTest.usage();
                continue;
            }
            if (string == null) {
                string = string2;
                continue;
            }
            TDBTest.usage();
        }
        if (string == null) {
            TDBTest.usage();
        }
        n = TDBTest.procremove(string, n2);
        return n;
    }

    private static int runmisc(String[] stringArray) {
        int n;
        String string = null;
        String string2 = null;
        int n2 = 0;
        int n3 = 0;
        for (n = 1; n < stringArray.length; ++n) {
            String string3 = stringArray[n];
            if (string == null && string3.startsWith("-")) {
                if (string3.equals("-tl")) {
                    n2 |= 1;
                    continue;
                }
                if (string3.equals("-td")) {
                    n2 |= 2;
                    continue;
                }
                if (string3.equals("-tb")) {
                    n2 |= 4;
                    continue;
                }
                if (string3.equals("-tt")) {
                    n2 |= 8;
                    continue;
                }
                if (string3.equals("-nl")) {
                    n3 |= 0x10;
                    continue;
                }
                if (string3.equals("-nb")) {
                    n3 |= 0x20;
                    continue;
                }
                TDBTest.usage();
                continue;
            }
            if (string == null) {
                string = string3;
                continue;
            }
            if (string2 == null) {
                string2 = string3;
                continue;
            }
            TDBTest.usage();
        }
        if (string == null || string2 == null) {
            TDBTest.usage();
        }
        if ((n = Util.atoi(string2)) < 1) {
            TDBTest.usage();
        }
        int n4 = TDBTest.procmisc(string, n, n2, n3);
        return n4;
    }

    private static int procwrite(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        STDOUT.println("<Writing Test>");
        STDOUT.println("  path=" + string + "  rnum=" + n + "  bnum=" + n2 + "  apow=" + n3 + "  fpow=" + n4 + "  opts=" + n5 + "  iflags=" + n6 + "  omode=" + n7);
        STDOUT.println("");
        boolean bl = false;
        double d = Util.time();
        TDB tDB = new TDB();
        if (!tDB.tune(n2, n3, n4, n5)) {
            TDBTest.eprint(tDB, "tune");
            bl = true;
        }
        if (!tDB.open(string, 0xE | n7)) {
            TDBTest.eprint(tDB, "open");
            bl = true;
        }
        if ((n6 & 1) != 0 && !tDB.setindex("", 1)) {
            TDBTest.eprint(tDB, "setindex");
            bl = true;
        }
        if ((n6 & 2) != 0 && !tDB.setindex("str", 0)) {
            TDBTest.eprint(tDB, "setindex");
            bl = true;
        }
        if ((n6 & 4) != 0 && !tDB.setindex("num", 1)) {
            TDBTest.eprint(tDB, "setindex");
            bl = true;
        }
        if ((n6 & 8) != 0 && !tDB.setindex("type", 1)) {
            TDBTest.eprint(tDB, "setindex");
            bl = true;
        }
        if ((n6 & 0x10) != 0 && !tDB.setindex("flag", 2)) {
            TDBTest.eprint(tDB, "setindex");
            bl = true;
        }
        if ((n6 & 0x20) != 0 && !tDB.setindex("text", 3)) {
            TDBTest.eprint(tDB, "setindex");
            bl = true;
        }
        for (int i = 1; i <= n; ++i) {
            long l = tDB.genuid();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("str", new Long(l));
            hashMap.put("num", new Integer(RND.nextInt((int)l) + 1));
            hashMap.put("type", new Integer(RND.nextInt(32) + 1));
            StringBuffer stringBuffer = new StringBuffer();
            int n8 = RND.nextInt(5);
            int n9 = 0;
            for (int j = 0; j < n8; ++j) {
                n9 += RND.nextInt(5) + 1;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(n9);
            }
            if (stringBuffer.length() > 0) {
                hashMap.put("flag", stringBuffer.toString());
                hashMap.put("text", stringBuffer.toString());
            }
            if (!tDB.put(new Long(l).toString().getBytes(), hashMap)) {
                TDBTest.eprint(tDB, "put");
                bl = true;
                break;
            }
            if (n <= 250 || i % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n && i % (n / 10) != 0) continue;
            STDOUT.println(" (" + Util.itoa(l, 8, '0') + ")");
        }
        STDOUT.println("record number: " + tDB.rnum());
        STDOUT.println("size: " + tDB.fsiz());
        if (!tDB.close()) {
            TDBTest.eprint(tDB, "close");
            bl = true;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(bl ? "error" : "ok");
        STDOUT.println("");
        return bl ? 1 : 0;
    }

    private static int procread(String string, int n) {
        STDOUT.println("<Reading Test>");
        STDOUT.println("  path=" + string + "  omode=" + n);
        STDOUT.println("");
        boolean bl = false;
        double d = Util.time();
        TDB tDB = new TDB();
        if (!tDB.open(string, 1 | n)) {
            TDBTest.eprint(tDB, "open");
            bl = true;
        }
        int n2 = (int)tDB.rnum();
        for (int i = 1; i <= n2; ++i) {
            if (tDB.get(new Integer(i).toString()) == null) {
                TDBTest.eprint(tDB, "get");
                bl = true;
                break;
            }
            if (n2 <= 250 || i % (n2 / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n2 && i % (n2 / 10) != 0) continue;
            STDOUT.println(" (" + Util.itoa(i, 8, '0') + ")");
        }
        STDOUT.println("record number: " + tDB.rnum());
        STDOUT.println("size: " + tDB.fsiz());
        if (!tDB.close()) {
            TDBTest.eprint(tDB, "close");
            bl = true;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(bl ? "error" : "ok");
        STDOUT.println("");
        return bl ? 1 : 0;
    }

    private static int procremove(String string, int n) {
        STDOUT.println("<Removing Test>");
        STDOUT.println("  path=" + string + "  omode=" + n);
        STDOUT.println("");
        boolean bl = false;
        double d = Util.time();
        TDB tDB = new TDB();
        if (!tDB.open(string, 2 | n)) {
            TDBTest.eprint(tDB, "open");
            bl = true;
        }
        int n2 = (int)tDB.rnum();
        for (int i = 1; i <= n2; ++i) {
            if (!tDB.out(new Integer(i).toString())) {
                TDBTest.eprint(tDB, "out");
                bl = true;
                break;
            }
            if (n2 <= 250 || i % (n2 / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n2 && i % (n2 / 10) != 0) continue;
            STDOUT.println(" (" + Util.itoa(i, 8, '0') + ")");
        }
        STDOUT.println("record number: " + tDB.rnum());
        STDOUT.println("size: " + tDB.fsiz());
        if (!tDB.close()) {
            TDBTest.eprint(tDB, "close");
            bl = true;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(bl ? "error" : "ok");
        STDOUT.println("");
        return bl ? 1 : 0;
    }

    private static int procmisc(String string, int n, int n2, int n3) {
        List<byte[]> list;
        List<byte[]> list2;
        Object object;
        int n4;
        String[] stringArray;
        String string2;
        byte[] byArray;
        int n5;
        Object object2;
        int n6;
        STDOUT.println("<Miscellaneous Test>");
        STDOUT.println("  path=" + string + "  rnum=" + n + "  opts=" + n2 + "  omode=" + n3);
        STDOUT.println("");
        boolean bl = false;
        double d = Util.time();
        TDB tDB = new TDB();
        if (!tDB.tune(n / 50, 2, -1, n2)) {
            TDBTest.eprint(tDB, "tune");
            bl = true;
        }
        if (!tDB.setcache(n / 10, 128, 256)) {
            TDBTest.eprint(tDB, "setcache");
            bl = true;
        }
        if (!tDB.setxmsiz(n * 4)) {
            TDBTest.eprint(tDB, "setxmsiz");
            bl = true;
        }
        if (!tDB.setdfunit(8)) {
            TDBTest.eprint(tDB, "setdfunit");
            bl = true;
        }
        if (!tDB.open(string, 0xE | n3)) {
            TDBTest.eprint(tDB, "open");
            bl = true;
        }
        if (!tDB.setindex("", 1)) {
            TDBTest.eprint(tDB, "setindex");
            bl = true;
        }
        if (!tDB.setindex("str", 0)) {
            TDBTest.eprint(tDB, "setindex");
            bl = true;
        }
        if (!tDB.setindex("num", 1)) {
            TDBTest.eprint(tDB, "setindex");
            bl = true;
        }
        if (!tDB.setindex("type", 1)) {
            TDBTest.eprint(tDB, "setindex");
            bl = true;
        }
        if (!tDB.setindex("flag", 2)) {
            TDBTest.eprint(tDB, "setindex");
            bl = true;
        }
        if (!tDB.setindex("text", 3)) {
            TDBTest.eprint(tDB, "setindex");
            bl = true;
        }
        STDOUT.println("writing:");
        for (n6 = 1; n6 <= n; ++n6) {
            long l = tDB.genuid();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("str", new Long(l));
            hashMap.put("num", new Integer(RND.nextInt((int)l) + 1));
            hashMap.put("type", new Integer(RND.nextInt(32) + 1));
            object2 = new StringBuffer();
            int n7 = RND.nextInt(5);
            int n8 = 0;
            for (n5 = 0; n5 < n7; ++n5) {
                n8 += RND.nextInt(5) + 1;
                if (((StringBuffer)object2).length() > 0) {
                    ((StringBuffer)object2).append(",");
                }
                ((StringBuffer)object2).append(n8);
            }
            if (((StringBuffer)object2).length() > 0) {
                hashMap.put("flag", ((StringBuffer)object2).toString());
                hashMap.put("text", ((StringBuffer)object2).toString());
            }
            if (!tDB.put(new Long(l).toString().getBytes(), hashMap)) {
                TDBTest.eprint(tDB, "put");
                bl = true;
                break;
            }
            if (n <= 250 || n6 % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (n6 != n && n6 % (n / 10) != 0) continue;
            STDOUT.println(" (" + Util.itoa(l, 8, '0') + ")");
        }
        STDOUT.println("reading:");
        for (n6 = 1; n6 <= n; ++n6) {
            if (tDB.get(new Integer(n6).toString()) == null) {
                TDBTest.eprint(tDB, "get");
                bl = true;
                break;
            }
            if (n <= 250 || n6 % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (n6 != n && n6 % (n / 10) != 0) continue;
            STDOUT.println(" (" + Util.itoa(n6, 8, '0') + ")");
        }
        STDOUT.println("removing:");
        for (n6 = 1; n6 <= n; ++n6) {
            if (RND.nextInt(2) == 0 && !tDB.out(new Integer(n6).toString())) {
                TDBTest.eprint(tDB, "get");
                bl = true;
                break;
            }
            if (n <= 250 || n6 % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (n6 != n && n6 % (n / 10) != 0) continue;
            STDOUT.println(" (" + Util.itoa(n6, 8, '0') + ")");
        }
        STDOUT.println("checking iterator:");
        if (!tDB.iterinit()) {
            TDBTest.eprint(tDB, "iterinit");
            bl = true;
        }
        n6 = 0;
        while ((byArray = tDB.iternext()) != null) {
            ++n6;
            if (tDB.get(byArray) == null) {
                TDBTest.eprint(tDB, "get");
                bl = true;
                break;
            }
            if (n <= 250 || n6 % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (n6 != n && n6 % (n / 10) != 0) continue;
            STDOUT.println(" (" + Util.itoa(n6, 8, '0') + ")");
        }
        if (n > 250) {
            STDOUT.println(" (" + Util.itoa(n6, 8, '0') + ")");
        }
        if (tDB.ecode() != 22 || (long)n6 != tDB.rnum()) {
            TDBTest.eprint(tDB, "(validation)");
            bl = true;
        }
        List<String> list3 = tDB.fwmkeys("1", 10);
        STDOUT.println("checking counting:");
        for (int i = 1; i <= n; ++i) {
            object2 = "i:" + RND.nextInt(n);
            if (RND.nextInt(2) == 0) {
                if (tDB.addint((String)object2, 1) == Integer.MIN_VALUE) {
                    TDBTest.eprint(tDB, "addint");
                    bl = true;
                    break;
                }
            } else if (tDB.adddouble((String)object2, 1.0) == Double.NaN) {
                TDBTest.eprint(tDB, "adddouble");
                bl = true;
                break;
            }
            if (n <= 250 || i % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n && i % (n / 10) != 0) continue;
            STDOUT.println(" (" + Util.itoa(i, 8, '0') + ")");
        }
        if (!tDB.sync()) {
            TDBTest.eprint(tDB, "sync");
            bl = true;
        }
        if (!tDB.optimize()) {
            TDBTest.eprint(tDB, "optimize");
            bl = true;
        }
        if (!tDB.copy(string2 = string + "-tmp")) {
            TDBTest.eprint(tDB, "copy");
            bl = true;
        }
        object2 = new File(string2).getAbsoluteFile();
        File file = new File(((File)object2).getParent());
        String[] stringArray2 = file.list();
        for (n5 = 0; n5 < stringArray2.length; ++n5) {
            stringArray = stringArray2[n5];
            if (stringArray.indexOf(string2) < 0 || stringArray.indexOf(".idx.") < 0) continue;
            new File((String)stringArray).delete();
        }
        ((File)object2).delete();
        STDOUT.println("searching:");
        TDBQRY tDBQRY = new TDBQRY(tDB);
        stringArray = new String[]{"", "str", "num", "type", "flag", "text", "c1"};
        int[] nArray = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14};
        int[] nArray2 = new int[]{15, 16, 17, 18};
        int[] nArray3 = new int[]{0, 1, 2, 3};
        for (int i = 1; i <= n; ++i) {
            if (RND.nextInt(10) > 0) {
                tDBQRY = new TDBQRY(tDB);
            }
            n4 = RND.nextInt(4);
            for (int j = 0; j < n4; ++j) {
                String string3 = stringArray[RND.nextInt(stringArray.length)];
                int n9 = nArray[RND.nextInt(nArray.length)];
                if (RND.nextInt(10) == 0) {
                    n9 = nArray2[RND.nextInt(nArray2.length)];
                }
                if (RND.nextInt(20) == 0) {
                    n9 |= 0x1000000;
                }
                if (RND.nextInt(20) == 0) {
                    n9 |= 0x2000000;
                }
                object = new Integer(RND.nextInt(i)).toString();
                if (RND.nextInt(10) == 0) {
                    object = (String)object + RND.nextInt(i);
                }
                if (RND.nextInt(10) == 0) {
                    object = (String)object + RND.nextInt(i);
                }
                tDBQRY.addcond(string3, n9, (String)object);
            }
            if (RND.nextInt(3) != 0) {
                String string4 = stringArray[RND.nextInt(stringArray.length)];
                int n10 = nArray3[RND.nextInt(nArray3.length)];
                tDBQRY.setorder(string4, n10);
            }
            tDBQRY.setlimit(RND.nextInt(i), RND.nextInt(10));
            List<byte[]> list4 = tDBQRY.search();
            if (n <= 250 || i % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n && i % (n / 10) != 0) continue;
            STDOUT.println(" (" + Util.itoa(i, 8, '0') + ")");
        }
        tDBQRY = new TDBQRY(tDB);
        tDBQRY.addcond("", 2, "i:");
        tDBQRY.setorder("_num", 3);
        List<byte[]> list5 = tDBQRY.search();
        n4 = list5.size();
        int n11 = (int)tDB.rnum();
        class MyProc
        implements TDBQRYPROC {
            int icnt = 0;

            MyProc() {
            }

            @Override
            public int proc(byte[] byArray, Map<String, byte[]> map) {
                ++this.icnt;
                map.put("icnt", new Integer(this.icnt).toString().getBytes());
                return 1;
            }
        }
        MyProc myProc = new MyProc();
        if (!tDBQRY.proc(myProc)) {
            TDBTest.eprint(tDB, "qry::proc");
            bl = true;
        }
        tDBQRY.addcond("icnt", 9, "0");
        TDBQRY[] tDBQRYArray = new TDBQRY[]{tDBQRY, tDBQRY};
        object = tDBQRY.metasearch(tDBQRYArray, 0);
        if (object.size() != n4) {
            TDBTest.eprint(tDB, "qry::metasearch");
            bl = true;
        }
        if ((list2 = tDBQRY.metasearch(tDBQRYArray, 1)).size() != n4) {
            TDBTest.eprint(tDB, "qry::metasearch");
            bl = true;
        }
        if ((list = tDBQRY.metasearch(tDBQRYArray, 2)).size() != 0) {
            TDBTest.eprint(tDB, "qry::metasearch");
            bl = true;
        }
        if (!tDBQRY.searchout()) {
            TDBTest.eprint(tDB, "qry::searchout");
            bl = true;
        }
        if (tDB.rnum() != (long)(n11 - n4)) {
            TDBTest.eprint(tDB, "(validation)");
            bl = true;
        }
        tDBQRY = new TDBQRY(tDB);
        tDBQRY.addcond("text", 2, "1");
        tDBQRY.setlimit(100, 1);
        Iterator<byte[]> iterator = tDBQRY.search().iterator();
        block9: while (iterator.hasNext()) {
            Map<String, byte[]> map = tDB.get(iterator.next());
            if (map != null) {
                String[] stringArray3 = tDBQRY.kwic(map, "text", -1, 4);
                if (stringArray3.length < 1) {
                    TDBTest.eprint(tDB, "(validation)");
                    bl = true;
                    break;
                }
                for (int i = 0; i < stringArray3.length; ++i) {
                    if (stringArray3[i].indexOf("1") >= 0) continue;
                    TDBTest.eprint(tDB, "(validation)");
                    bl = true;
                    continue block9;
                }
                continue;
            }
            TDBTest.eprint(tDB, "get");
            bl = true;
            break;
        }
        if (!tDB.vanish()) {
            TDBTest.eprint(tDB, "vanish");
            bl = true;
        }
        STDOUT.println("checking transaction commit:");
        if (!tDB.tranbegin()) {
            TDBTest.eprint(tDB, "tranbegin");
            bl = true;
        }
        for (int i = 1; i <= n; ++i) {
            byArray = new Integer(RND.nextInt(n) + 1).toString().getBytes();
            if (RND.nextInt(2) == 0) {
                if (tDB.addint(byArray, 1) == Integer.MIN_VALUE) {
                    TDBTest.eprint(tDB, "addint");
                    bl = true;
                    break;
                }
            } else if (!tDB.out(byArray) && tDB.ecode() != 22) {
                TDBTest.eprint(tDB, "out");
                bl = true;
                break;
            }
            if (n <= 250 || i % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n && i % (n / 10) != 0) continue;
            STDOUT.println(" (" + Util.itoa(i, 8, '0') + ")");
        }
        if (!tDB.trancommit()) {
            TDBTest.eprint(tDB, "trancommit");
            bl = true;
        }
        STDOUT.println("checking transaction abort:");
        long l = tDB.rnum();
        long l2 = tDB.fsiz();
        if (!tDB.tranbegin()) {
            TDBTest.eprint(tDB, "tranbegin");
            bl = true;
        }
        for (int i = 1; i <= n; ++i) {
            String string5 = new Integer(RND.nextInt(n) + 1).toString();
            if (RND.nextInt(2) == 0) {
                if (tDB.addint(string5, 1) == Integer.MIN_VALUE) {
                    TDBTest.eprint(tDB, "addint");
                    bl = true;
                    break;
                }
            } else if (!tDB.out(string5) && tDB.ecode() != 22) {
                TDBTest.eprint(tDB, "out");
                bl = true;
                break;
            }
            if (n <= 250 || i % (n / 250) != 0) continue;
            STDOUT.print('.');
            if (i != n && i % (n / 10) != 0) continue;
            STDOUT.println(" (" + Util.itoa(i, 8, '0') + ")");
        }
        if (!tDB.tranabort()) {
            TDBTest.eprint(tDB, "tranabort");
            bl = true;
        }
        if (tDB.rnum() != l || tDB.fsiz() != l2) {
            TDBTest.eprint(tDB, "(validation)");
            bl = true;
        }
        STDOUT.println("record number: " + tDB.rnum());
        STDOUT.println("size: " + tDB.fsiz());
        if (!tDB.close()) {
            TDBTest.eprint(tDB, "close");
            bl = true;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(bl ? "error" : "ok");
        STDOUT.println("");
        return bl ? 1 : 0;
    }

    private TDBTest() throws NoSuchMethodException {
        throw new NoSuchMethodException();
    }
}

