/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.MDC;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.graylog2.GelfMessage;
import org.graylog2.GelfMessageProvider;
import org.graylog2.log.Log4jVersionChecker;

public class GelfMessageFactory {
    private static final int MAX_SHORT_MESSAGE_LENGTH = 250;
    private static final String ORIGIN_HOST_KEY = "originHost";
    private static final String LOGGER_NAME = "logger";
    private static final String LOGGER_NDC = "loggerNdc";
    private static final String THREAD_NAME = "thread";
    private static final String JAVA_TIMESTAMP = "timestampMs";

    public static final GelfMessage makeMessage(LoggingEvent event, GelfMessageProvider provider) {
        ThrowableInformation throwableInformation;
        long timeStamp = Log4jVersionChecker.getTimeStamp(event);
        Level level = event.getLevel();
        LocationInfo locationInformation = event.getLocationInformation();
        String file = locationInformation.getFileName();
        String lineNumber = locationInformation.getLineNumber();
        String renderedMessage = event.getRenderedMessage();
        if (renderedMessage == null) {
            renderedMessage = "";
        }
        String shortMessage = renderedMessage.length() > 250 ? renderedMessage.substring(0, 249) : renderedMessage;
        if (provider.isExtractStacktrace() && (throwableInformation = event.getThrowableInformation()) != null) {
            renderedMessage = renderedMessage + "\n\r" + GelfMessageFactory.extractStacktrace(throwableInformation);
        }
        GelfMessage gelfMessage = new GelfMessage(shortMessage, renderedMessage, timeStamp, String.valueOf(level.getSyslogEquivalent()), lineNumber, file);
        if (provider.getOriginHost() != null) {
            gelfMessage.setHost(provider.getOriginHost());
        }
        if (provider.getFacility() != null) {
            gelfMessage.setFacility(provider.getFacility());
        }
        Map<String, String> fields = provider.getFields();
        for (Map.Entry<String, String> entry : fields.entrySet()) {
            if (entry.getKey().equals(ORIGIN_HOST_KEY) && gelfMessage.getHost() == null) {
                gelfMessage.setHost(fields.get(ORIGIN_HOST_KEY));
                continue;
            }
            gelfMessage.addField(entry.getKey(), entry.getValue());
        }
        if (provider.isAddExtendedInformation()) {
            String ndc;
            gelfMessage.addField(THREAD_NAME, event.getThreadName());
            gelfMessage.addField(LOGGER_NAME, event.getLoggerName());
            gelfMessage.addField(JAVA_TIMESTAMP, Long.toString(gelfMessage.getJavaTimestamp()));
            Hashtable mdc = MDC.getContext();
            if (mdc != null) {
                for (Map.Entry entry : mdc.entrySet()) {
                    gelfMessage.addField((String)entry.getKey(), entry.getValue().toString());
                }
            }
            if ((ndc = event.getNDC()) != null) {
                gelfMessage.addField(LOGGER_NDC, ndc);
            }
        }
        return gelfMessage;
    }

    private static String extractStacktrace(ThrowableInformation throwableInformation) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwableInformation.getThrowable().printStackTrace(pw);
        return sw.toString();
    }
}

