/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.List;
import org.graylog2.GelfMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GelfSender {
    private static final int DEFAULT_PORT = 12201;
    private static final int PORT_MIN = 8000;
    private static final int PORT_MAX = 8888;
    private InetAddress host;
    private int port;
    private DatagramSocket socket;

    public GelfSender(String host) throws UnknownHostException, SocketException {
        this(host, 12201);
    }

    public GelfSender(String host, int port) throws UnknownHostException, SocketException {
        this.host = InetAddress.getByName(host);
        this.port = port;
        this.socket = this.initiateSocket();
    }

    private DatagramSocket initiateSocket() throws SocketException {
        int port = 8000;
        DatagramSocket resultingSocket = null;
        boolean binded = false;
        while (!binded) {
            try {
                resultingSocket = new DatagramSocket(port);
                binded = true;
            }
            catch (SocketException e) {
                if (++port <= 8888) continue;
                throw e;
            }
        }
        return resultingSocket;
    }

    public boolean sendMessage(GelfMessage message) {
        return message.isValid() && this.sendDatagrams(message.toDatagrams());
    }

    public boolean sendDatagrams(List<byte[]> bytesList) {
        for (byte[] bytes : bytesList) {
            DatagramPacket datagramPacket = new DatagramPacket(bytes, bytes.length, this.host, this.port);
            try {
                this.socket.send(datagramPacket);
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public void close() {
        this.socket.close();
    }
}

