/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.util.CharsetUtil;

public final class Bytes {
    private static final byte[] HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final Class<?> ReplayingDecoderBuffer;
    private static final Field RDB_buffer;
    public static final MemCmp MEMCMP;

    private Bytes() {
    }

    public static short getShort(byte[] byArray) {
        return Bytes.getShort(byArray, 0);
    }

    public static short getShort(byte[] byArray, int n) {
        return (short)(byArray[n] << 8 | byArray[n + 1] & 0xFF);
    }

    public static int getUnsignedShort(byte[] byArray) {
        return Bytes.getUnsignedShort(byArray, 0);
    }

    public static int getUnsignedShort(byte[] byArray, int n) {
        return Bytes.getShort(byArray, n) & 0xFFFF;
    }

    public static void setShort(byte[] byArray, short s) {
        Bytes.setShort(byArray, s, 0);
    }

    public static void setShort(byte[] byArray, short s, int n) {
        byArray[n + 0] = (byte)(s >>> 8);
        byArray[n + 1] = (byte)(s >>> 0);
    }

    public static byte[] fromShort(short s) {
        byte[] byArray = new byte[2];
        Bytes.setShort(byArray, s);
        return byArray;
    }

    public static int getInt(byte[] byArray) {
        return Bytes.getInt(byArray, 0);
    }

    public static int getInt(byte[] byArray, int n) {
        return (byArray[n + 0] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | (byArray[n + 3] & 0xFF) << 0;
    }

    public static long getUnsignedInt(byte[] byArray) {
        return Bytes.getUnsignedInt(byArray, 0);
    }

    public static long getUnsignedInt(byte[] byArray, int n) {
        return (long)Bytes.getInt(byArray, n) & 0xFFFFFFFFL;
    }

    public static void setInt(byte[] byArray, int n) {
        Bytes.setInt(byArray, n, 0);
    }

    public static void setInt(byte[] byArray, int n, int n2) {
        byArray[n2 + 0] = (byte)(n >>> 24);
        byArray[n2 + 1] = (byte)(n >>> 16);
        byArray[n2 + 2] = (byte)(n >>> 8);
        byArray[n2 + 3] = (byte)(n >>> 0);
    }

    public static byte[] fromInt(int n) {
        byte[] byArray = new byte[4];
        Bytes.setInt(byArray, n);
        return byArray;
    }

    public static long getLong(byte[] byArray) {
        return Bytes.getLong(byArray, 0);
    }

    public static long getLong(byte[] byArray, int n) {
        return ((long)byArray[n + 0] & 0xFFL) << 56 | ((long)byArray[n + 1] & 0xFFL) << 48 | ((long)byArray[n + 2] & 0xFFL) << 40 | ((long)byArray[n + 3] & 0xFFL) << 32 | ((long)byArray[n + 4] & 0xFFL) << 24 | ((long)byArray[n + 5] & 0xFFL) << 16 | ((long)byArray[n + 6] & 0xFFL) << 8 | ((long)byArray[n + 7] & 0xFFL) << 0;
    }

    public static void setLong(byte[] byArray, long l) {
        Bytes.setLong(byArray, l, 0);
    }

    public static void setLong(byte[] byArray, long l, int n) {
        byArray[n + 0] = (byte)(l >>> 56);
        byArray[n + 1] = (byte)(l >>> 48);
        byArray[n + 2] = (byte)(l >>> 40);
        byArray[n + 3] = (byte)(l >>> 32);
        byArray[n + 4] = (byte)(l >>> 24);
        byArray[n + 5] = (byte)(l >>> 16);
        byArray[n + 6] = (byte)(l >>> 8);
        byArray[n + 7] = (byte)(l >>> 0);
    }

    public static byte[] fromLong(long l) {
        byte[] byArray = new byte[8];
        Bytes.setLong(byArray, l);
        return byArray;
    }

    public static byte[] UTF8(String string) {
        return string.getBytes(CharsetUtil.UTF_8);
    }

    public static byte[] ISO88591(String string) {
        return string.getBytes(CharsetUtil.ISO_8859_1);
    }

    public static void pretty(StringBuilder stringBuilder, byte[] byArray) {
        if (byArray == null) {
            stringBuilder.append("null");
            return;
        }
        int n = 0;
        int n2 = stringBuilder.length();
        stringBuilder.ensureCapacity(n2 + 1 + byArray.length + 1);
        stringBuilder.append('\"');
        for (byte by : byArray) {
            if (32 <= by && by <= 126) {
                ++n;
                stringBuilder.append((char)by);
                continue;
            }
            if (by == 10) {
                stringBuilder.append('\\').append('n');
                continue;
            }
            if (by == 9) {
                stringBuilder.append('\\').append('t');
                continue;
            }
            stringBuilder.append("\\x").append((char)HEX[by >>> 4 & 0xF]).append((char)HEX[by & 0xF]);
        }
        if (n < byArray.length / 2) {
            stringBuilder.setLength(n2);
            stringBuilder.append(Arrays.toString(byArray));
        } else {
            stringBuilder.append('\"');
        }
    }

    public static String pretty(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder(1 + byArray.length + 1);
        Bytes.pretty(stringBuilder, byArray);
        return stringBuilder.toString();
    }

    public static String hex(long l) {
        byte[] byArray = new byte[18];
        byArray[0] = 48;
        byArray[1] = 120;
        int n = 18;
        do {
            byArray[--n] = HEX[(int)l & 0xF];
        } while ((l >>>= 4) != 0L);
        while (n > 1) {
            byArray[n] = 48;
            --n;
        }
        return new String(byArray);
    }

    public static String pretty(ChannelBuffer channelBuffer) {
        byte[] byArray;
        if (channelBuffer == null) {
            return "null";
        }
        if (channelBuffer.getClass() != ReplayingDecoderBuffer) {
            byArray = channelBuffer.array();
        } else {
            try {
                ChannelBuffer channelBuffer2 = (ChannelBuffer)RDB_buffer.get(channelBuffer);
                byArray = channelBuffer2.array();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)("Should not happen: " + illegalAccessException));
            }
        }
        return Bytes.pretty(byArray);
    }

    public static int memcmp(byte[] byArray, byte[] byArray2) {
        int n = Math.min(byArray.length, byArray2.length);
        if (byArray == byArray2) {
            return 0;
        }
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return (byArray[i] & 0xFF) - (byArray2[i] & 0xFF);
        }
        return byArray.length - byArray2.length;
    }

    public static int memcmp(byte[] byArray, byte[] byArray2, int n, int n2) {
        if (byArray == byArray2 && byArray != null) {
            return 0;
        }
        n2 += n;
        for (int i = n; i < n2; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return (byArray[i] & 0xFF) - (byArray2[i] & 0xFF);
        }
        return 0;
    }

    public static byte[] deDup(byte[] byArray, byte[] byArray2) {
        return Bytes.memcmp(byArray, byArray2) == 0 ? byArray : byArray2;
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        return Bytes.memcmp(byArray, byArray2) == 0;
    }

    public static int memcmpMaybeNull(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            if (byArray2 == null) {
                return 0;
            }
            return -1;
        }
        if (byArray2 == null) {
            return 1;
        }
        return Bytes.memcmp(byArray, byArray2);
    }

    static {
        try {
            ReplayingDecoderBuffer = Class.forName("org.jboss.netty.handler.codec.replay.ReplayingDecoderBuffer");
            RDB_buffer = ReplayingDecoderBuffer.getDeclaredField("buffer");
            RDB_buffer.setAccessible(true);
        }
        catch (Exception exception) {
            throw new RuntimeException("static initializer failed", exception);
        }
        MEMCMP = new MemCmp();
    }

    public static final class ByteMap<V>
    extends TreeMap<byte[], V>
    implements Iterable<Map.Entry<byte[], V>> {
        private static final long serialVersionUID = 1280744742L;

        public ByteMap() {
            super(MEMCMP);
        }

        @Override
        public Iterator<Map.Entry<byte[], V>> iterator() {
            return super.entrySet().iterator();
        }

        @Override
        public String toString() {
            int n = this.size();
            if (n == 0) {
                return "{}";
            }
            StringBuilder stringBuilder = new StringBuilder(n << 4);
            stringBuilder.append('{');
            for (Map.Entry<byte[], V> entry : this) {
                Bytes.pretty(stringBuilder, entry.getKey());
                stringBuilder.append('=');
                V v = entry.getValue();
                if (v instanceof byte[]) {
                    Bytes.pretty(stringBuilder, (byte[])v);
                } else {
                    stringBuilder.append((Object)(v == this ? "(this map)" : v));
                }
                stringBuilder.append(", ");
            }
            stringBuilder.setLength(stringBuilder.length() - 2);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    private static final class MemCmp
    implements Comparator<byte[]> {
        private MemCmp() {
        }

        @Override
        public int compare(byte[] byArray, byte[] byArray2) {
            return Bytes.memcmp(byArray, byArray2);
        }
    }
}

