/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import org.hbase.async.Bytes;
import org.hbase.async.HBaseClient;
import org.hbase.async.HBaseRpc;
import org.hbase.async.KeyValue;
import org.hbase.async.RowLock;
import org.jboss.netty.buffer.ChannelBuffer;

public final class DeleteRequest
extends HBaseRpc
implements HBaseRpc.HasTable,
HBaseRpc.HasKey,
HBaseRpc.HasFamily,
HBaseRpc.HasQualifiers {
    private static final byte[] DELETE = new byte[]{100, 101, 108, 101, 116, 101};
    private static final byte[][] DELETE_FAMILY_MARKER = new byte[][]{HBaseClient.EMPTY_ARRAY};
    private final byte[] family;
    private final byte[][] qualifiers;
    private final long lockid;

    public DeleteRequest(byte[] byArray, byte[] byArray2) {
        this(byArray, byArray2, null, (byte[][])null, -1L);
    }

    public DeleteRequest(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this(byArray, byArray2, byArray3, (byte[][])null, -1L);
    }

    public DeleteRequest(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        Object object;
        if (byArray4 == null) {
            object = null;
        } else {
            byte[][] byArrayArray = new byte[1][];
            object = byArrayArray;
            byArrayArray[0] = byArray4;
        }
        this(byArray, byArray2, byArray3, (byte[][])object, -1L);
    }

    public DeleteRequest(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[][] byArray4) {
        this(byArray, byArray2, byArray3, byArray4, -1L);
    }

    public DeleteRequest(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, RowLock rowLock) {
        Object object;
        if (byArray4 == null) {
            object = null;
        } else {
            byte[][] byArrayArray = new byte[1][];
            object = byArrayArray;
            byArrayArray[0] = byArray4;
        }
        this(byArray, byArray2, byArray3, (byte[][])object, rowLock.id());
    }

    public DeleteRequest(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[][] byArray4, RowLock rowLock) {
        this(byArray, byArray2, byArray3, byArray4, rowLock.id());
    }

    public DeleteRequest(String string, String string2) {
        this(string.getBytes(), string2.getBytes(), null, (byte[][])null, -1L);
    }

    public DeleteRequest(String string, String string2, String string3) {
        this(string.getBytes(), string2.getBytes(), string3.getBytes(), (byte[][])null, -1L);
    }

    public DeleteRequest(String string, String string2, String string3, String string4) {
        Object object;
        byte[] byArray = string.getBytes();
        byte[] byArray2 = string2.getBytes();
        byte[] byArray3 = string3.getBytes();
        if (string4 == null) {
            object = null;
        } else {
            byte[][] byArrayArray = new byte[1][];
            object = byArrayArray;
            byArrayArray[0] = string4.getBytes();
        }
        this(byArray, byArray2, byArray3, (byte[][])object, -1L);
    }

    public DeleteRequest(String string, String string2, String string3, String string4, RowLock rowLock) {
        Object object;
        byte[] byArray = string.getBytes();
        byte[] byArray2 = string2.getBytes();
        byte[] byArray3 = string3.getBytes();
        if (string4 == null) {
            object = null;
        } else {
            byte[][] byArrayArray = new byte[1][];
            object = byArrayArray;
            byArrayArray[0] = string4.getBytes();
        }
        this(byArray, byArray2, byArray3, (byte[][])object, rowLock.id());
    }

    private DeleteRequest(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[][] byArray4, long l) {
        super(DELETE, byArray, byArray2);
        if (byArray3 != null) {
            KeyValue.checkFamily(byArray3);
        }
        this.family = byArray3;
        if (byArray4 != null) {
            if (byArray3 == null) {
                throw new IllegalArgumentException("You can't delete specific qualifiers without specifying which family they belong to.  table=" + Bytes.pretty(byArray) + ", key=" + Bytes.pretty(byArray2));
            }
            for (byte[] byArray5 : byArray4) {
                KeyValue.checkQualifier(byArray5);
            }
            this.qualifiers = byArray4;
        } else {
            this.qualifiers = DELETE_FAMILY_MARKER;
        }
        this.lockid = l;
    }

    @Override
    public byte[] table() {
        return this.table;
    }

    @Override
    public byte[] key() {
        return this.key;
    }

    @Override
    public byte[] family() {
        return this.family;
    }

    @Override
    public byte[][] qualifiers() {
        return this.qualifiers;
    }

    @Override
    public String toString() {
        return super.toStringWithQualifiers("DeleteRequest", this.family, this.qualifiers);
    }

    private int predictSerializedSize() {
        int n = 0;
        n += 4;
        ++n;
        n += 3;
        n += this.region.name().length;
        ++n;
        ++n;
        ++n;
        n += 3;
        n += this.key.length;
        n += 8;
        n += 8;
        n += 4;
        ++n;
        if (this.family == null) {
            return n;
        }
        n += this.family.length;
        return (n += 4) + this.sizeOfKeyValues();
    }

    private int sizeOfKeyValues() {
        int n = 0;
        n += 4;
        n += 4;
        n += 4;
        n += 2;
        n += this.key.length;
        ++n;
        n += this.family.length;
        n += 8;
        ++n;
        n *= this.qualifiers.length;
        for (byte[] byArray : this.qualifiers) {
            n += byArray.length;
        }
        return n;
    }

    @Override
    ChannelBuffer serialize(byte by) {
        ChannelBuffer channelBuffer = this.newBuffer(this.predictSerializedSize());
        channelBuffer.writeInt(2);
        DeleteRequest.writeHBaseByteArray(channelBuffer, this.region.name());
        channelBuffer.writeByte(31);
        channelBuffer.writeByte(31);
        channelBuffer.writeByte(1);
        DeleteRequest.writeByteArray(channelBuffer, this.key);
        channelBuffer.writeLong(Long.MAX_VALUE);
        channelBuffer.writeLong(this.lockid);
        if (this.family == null) {
            channelBuffer.writeInt(0);
            return channelBuffer;
        }
        channelBuffer.writeInt(1);
        DeleteRequest.writeByteArray(channelBuffer, this.family);
        channelBuffer.writeInt(this.qualifiers.length);
        byte by2 = this.qualifiers == DELETE_FAMILY_MARKER ? (byte)14 : 12;
        for (byte[] byArray : this.qualifiers) {
            KeyValue.serialize(channelBuffer, by2, Long.MAX_VALUE, this.key, this.family, byArray, null);
        }
        return channelBuffer;
    }
}

