/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import org.hbase.async.HBaseRpc;
import org.hbase.async.KeyValue;
import org.hbase.async.RowLock;
import org.jboss.netty.buffer.ChannelBuffer;

public final class GetRequest
extends HBaseRpc
implements HBaseRpc.HasTable,
HBaseRpc.HasKey,
HBaseRpc.HasFamily,
HBaseRpc.HasQualifiers {
    private static final byte[] GET = new byte[]{103, 101, 116};
    private static final byte[] EXISTS = new byte[]{101, 120, 105, 115, 116, 115};
    private byte[] family;
    private byte[][] qualifiers;
    private long lockid = -1L;

    public GetRequest(byte[] byArray, byte[] byArray2) {
        super(GET, byArray, byArray2);
    }

    public GetRequest(String string, byte[] byArray) {
        this(string.getBytes(), byArray);
    }

    public GetRequest(String string, String string2) {
        this(string.getBytes(), string2.getBytes());
    }

    private GetRequest(float f, byte[] byArray, byte[] byArray2) {
        super(EXISTS, byArray, byArray2);
    }

    static HBaseRpc exists(byte[] byArray, byte[] byArray2) {
        return new GetRequest(0.0f, byArray, byArray2);
    }

    public GetRequest family(byte[] byArray) {
        KeyValue.checkFamily(byArray);
        this.family = byArray;
        return this;
    }

    public GetRequest family(String string) {
        return this.family(string.getBytes());
    }

    public GetRequest qualifier(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("qualifier");
        }
        KeyValue.checkQualifier(byArray);
        this.qualifiers = new byte[][]{byArray};
        return this;
    }

    public GetRequest qualifiers(byte[][] byArray) {
        if (byArray == null) {
            throw new NullPointerException("qualifiers");
        }
        for (byte[] byArray2 : byArray) {
            KeyValue.checkQualifier(byArray2);
        }
        this.qualifiers = byArray;
        return this;
    }

    public GetRequest qualifier(String string) {
        return this.qualifier(string.getBytes());
    }

    public GetRequest withRowLock(RowLock rowLock) {
        this.lockid = rowLock.id();
        return this;
    }

    @Override
    public byte[] table() {
        return this.table;
    }

    @Override
    public byte[] key() {
        return this.key;
    }

    @Override
    public byte[] family() {
        return this.family;
    }

    @Override
    public byte[][] qualifiers() {
        return this.qualifiers;
    }

    @Override
    public String toString() {
        String string = this.method() == GET ? "GetRequest" : "Exists";
        return super.toStringWithQualifiers(string, this.family, this.qualifiers);
    }

    @Override
    boolean versionSensitive() {
        return true;
    }

    private int predictSerializedSize(byte by) {
        int n = 0;
        n += 4;
        ++n;
        n += 3;
        n += this.region.name().length;
        ++n;
        ++n;
        ++n;
        n += 3;
        n += this.key.length;
        n += 8;
        n += 4;
        ++n;
        if (by >= 26) {
            ++n;
        }
        n += 8;
        n += 8;
        ++n;
        n += 4;
        if (this.family != null) {
            ++n;
            n += this.family.length;
            ++n;
            if (this.qualifiers != null) {
                n += 4;
                for (byte[] byArray : this.qualifiers) {
                    n += 3;
                    n += byArray.length;
                }
            }
        }
        return n;
    }

    @Override
    ChannelBuffer serialize(byte by) {
        ChannelBuffer channelBuffer = this.newBuffer(this.predictSerializedSize(by));
        channelBuffer.writeInt(2);
        GetRequest.writeHBaseByteArray(channelBuffer, this.region.name());
        channelBuffer.writeByte(32);
        channelBuffer.writeByte(32);
        channelBuffer.writeByte(1);
        GetRequest.writeByteArray(channelBuffer, this.key);
        channelBuffer.writeLong(this.lockid);
        channelBuffer.writeInt(1);
        channelBuffer.writeByte(0);
        if (by >= 26) {
            channelBuffer.writeByte(1);
        }
        channelBuffer.writeLong(0L);
        channelBuffer.writeLong(Long.MAX_VALUE);
        channelBuffer.writeByte(1);
        channelBuffer.writeInt(this.family != null ? 1 : 0);
        if (this.family != null) {
            GetRequest.writeByteArray(channelBuffer, this.family);
            if (this.qualifiers != null) {
                channelBuffer.writeByte(1);
                channelBuffer.writeInt(this.qualifiers.length);
                for (byte[] byArray : this.qualifiers) {
                    GetRequest.writeByteArray(channelBuffer, byArray);
                }
            } else {
                channelBuffer.writeByte(0);
            }
        }
        return channelBuffer;
    }
}

