/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.hbase.async.AtomicIncrementRequest;
import org.hbase.async.BrokenMetaException;
import org.hbase.async.Bytes;
import org.hbase.async.DeleteRequest;
import org.hbase.async.GetRequest;
import org.hbase.async.HBaseClient;
import org.hbase.async.HBaseException;
import org.hbase.async.HBaseRpc;
import org.hbase.async.InvalidResponseException;
import org.hbase.async.KeyValue;
import org.hbase.async.NonRecoverableException;
import org.hbase.async.NotServingRegionException;
import org.hbase.async.PleaseThrottleException;
import org.hbase.async.PutRequest;
import org.hbase.async.RecoverableException;
import org.hbase.async.RegionClient;
import org.hbase.async.RegionInfo;
import org.hbase.async.RowLock;
import org.hbase.async.RowLockRequest;
import org.hbase.async.Scanner;
import org.hbase.async.TableNotFoundException;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.DefaultChannelPipeline;
import org.jboss.netty.channel.socket.SocketChannel;
import org.jboss.netty.channel.socket.SocketChannelConfig;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HBaseClient {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseClient.class);
    public static final byte[] EMPTY_ARRAY = new byte[0];
    private static final byte[] ROOT = new byte[]{45, 82, 79, 79, 84, 45};
    private static final byte[] ROOT_REGION = new byte[]{45, 82, 79, 79, 84, 45, 44, 44, 48};
    private static final byte[] META = new byte[]{46, 77, 69, 84, 65, 46};
    private static final byte[] INFO = new byte[]{105, 110, 102, 111};
    private static final byte[] REGIONINFO = new byte[]{114, 101, 103, 105, 111, 110, 105, 110, 102, 111};
    private static final byte[] SERVER = new byte[]{115, 101, 114, 118, 101, 114};
    private final Executor executor = Executors.newCachedThreadPool();
    final Timer timer = new HashedWheelTimer(20L, TimeUnit.MILLISECONDS);
    private volatile short flush_interval = (short)1000;
    private final NioClientSocketChannelFactory channel_factory = new NioClientSocketChannelFactory(this.executor, this.executor);
    private final ZKClient zkclient;
    private final AtomicLong root_lookups = new AtomicLong();
    private volatile RegionClient rootregion;
    private final ConcurrentSkipListMap<byte[], RegionInfo> regions_cache = new ConcurrentSkipListMap(RegionInfo.REGION_NAME_CMP);
    private final ConcurrentHashMap<RegionInfo, RegionClient> region2client = new ConcurrentHashMap();
    private final AtomicLong meta_lookups_with_permit = new AtomicLong();
    private final AtomicLong meta_lookups_wo_permit = new AtomicLong();
    private final ConcurrentHashMap<RegionClient, ArrayList<RegionInfo>> client2regions = new ConcurrentHashMap();
    private final HashMap<String, RegionClient> ip2client = new HashMap();
    private final ConcurrentSkipListMap<byte[], ArrayList<HBaseRpc>> got_nsre = new ConcurrentSkipListMap(RegionInfo.REGION_NAME_CMP);
    private static final Callback<ArrayList<KeyValue>, Object> got = new Callback<ArrayList<KeyValue>, Object>(){

        public ArrayList<KeyValue> call(Object object) {
            if (object instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)object;
                return arrayList;
            }
            throw new InvalidResponseException(ArrayList.class, object);
        }

        public String toString() {
            return "type get response";
        }
    };
    private static final Callback<Long, Object> scanner_opened = new Callback<Long, Object>(){

        public Long call(Object object) {
            if (object instanceof Long) {
                return (Long)object;
            }
            throw new InvalidResponseException(Long.class, object);
        }

        public String toString() {
            return "type openScanner response";
        }
    };
    private static final Callback<Long, Object> icv_done = new Callback<Long, Object>(){

        public Long call(Object object) {
            if (object instanceof Long) {
                return (Long)object;
            }
            throw new InvalidResponseException(Long.class, object);
        }

        public String toString() {
            return "type incrementColumnValue response";
        }
    };
    private final MetaCB meta_lookup_done = new MetaCB();
    private final RootCB root_lookup_done = new RootCB();
    private static final short NSRE_LOW_WATERMARK = 1000;
    private static final short NSRE_HIGH_WATERMARK = 10000;
    private static final short NSRE_LOG_EVERY = 500;

    public HBaseClient(String string) {
        this(string, "/hbase");
    }

    public HBaseClient(String string, String string2) {
        this.zkclient = new ZKClient(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deferred<Object> flush() {
        ArrayList<Deferred<Object>> arrayList = new ArrayList<Deferred<Object>>(this.client2regions.size() + this.got_nsre.size() * 8);
        for (Object object : this.client2regions.keySet()) {
            arrayList.add(((RegionClient)((Object)object)).flush());
        }
        Iterator<Object> iterator = this.got_nsre.values().iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2 = object = (ArrayList)iterator.next();
            synchronized (object2) {
                Iterator iterator2 = ((ArrayList)object).iterator();
                while (iterator2.hasNext()) {
                    HBaseRpc hBaseRpc = (HBaseRpc)iterator2.next();
                    if (!(hBaseRpc instanceof PutRequest) && !(hBaseRpc instanceof AtomicIncrementRequest) && !(hBaseRpc instanceof DeleteRequest)) continue;
                    arrayList.add(hBaseRpc.getDeferred());
                }
            }
        }
        iterator = Deferred.group(arrayList);
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short setFlushInterval(short s) {
        if (s < 0) {
            throw new IllegalArgumentException("Negative: " + s);
        }
        try {
            short s2 = this.flush_interval;
            return s2;
        }
        finally {
            this.flush_interval = s;
        }
    }

    public short getFlushInterval() {
        return this.flush_interval;
    }

    public Deferred<Object> shutdown() {
        Deferred<Object> deferred = this.zkclient.getDeferredRootIfBeingLookedUp();
        if (deferred != null) {
            final class RetryShutdown
            implements Callback<Object, Object> {
                RetryShutdown() {
                }

                public Object call(Object object) {
                    return HBaseClient.this.shutdown();
                }

                public String toString() {
                    return "retry shutdown";
                }
            }
            return deferred.addBoth((Callback)new RetryShutdown());
        }
        final class DisconnectCB
        implements Callback<Object, Object> {
            DisconnectCB() {
            }

            public Object call(Object object) {
                final class ReleaseResourcesCB
                implements Callback<Object, Object> {
                    final /* synthetic */ HBaseClient this$0;

                    ReleaseResourcesCB(HBaseClient hBaseClient) {
                        this.this$0 = hBaseClient;
                    }

                    public Object call(Object object) {
                        HBaseClient.access$200().debug("Releasing all remaining resources");
                        this.this$0.timer.stop();
                        final class ShutdownThread
                        extends Thread {
                            final /* synthetic */ HBaseClient this$0;

                            ShutdownThread(HBaseClient hBaseClient) {
                                this.this$0 = hBaseClient;
                                super("HBaseClient@" + HBaseClient.access$001(hBaseClient) + " shutdown");
                            }

                            public void run() {
                                HBaseClient.access$100(this.this$0).releaseExternalResources();
                            }
                        }
                        new ShutdownThread(this.this$0).start();
                        return object;
                    }

                    public String toString() {
                        return "release resources callback";
                    }
                }
                return HBaseClient.this.disconnectEverything().addCallback((Callback)new ReleaseResourcesCB(HBaseClient.this));
            }

            public String toString() {
                return "disconnect callback";
            }
        }
        return this.flush().addCallback((Callback)new DisconnectCB());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Deferred<Object> disconnectEverything() {
        HashMap<String, RegionClient> hashMap;
        Cloneable cloneable = this.ip2client;
        synchronized (cloneable) {
            hashMap = new HashMap<String, RegionClient>(this.ip2client);
        }
        cloneable = new ArrayList(hashMap.values().size() + 1);
        for (RegionClient regionClient : hashMap.values()) {
            ((ArrayList)cloneable).add(regionClient.shutdown());
        }
        if (this.rootregion != null && this.rootregion.isAlive()) {
            ((ArrayList)cloneable).add(this.rootregion.shutdown());
        }
        hashMap = null;
        final int n = ((ArrayList)cloneable).size();
        return Deferred.group((Collection)((Object)cloneable)).addCallback((Callback)new Callback<Object, ArrayList<Object>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call(ArrayList<Object> arrayList) {
                HashMap hashMap = null;
                HashMap hashMap2 = HBaseClient.this.ip2client;
                synchronized (hashMap2) {
                    if (!HBaseClient.this.ip2client.isEmpty()) {
                        hashMap = new HashMap(HBaseClient.this.ip2client);
                    }
                }
                if (hashMap != null) {
                    LOG.error("Some clients are left in the client cache and haven't been cleaned up: " + hashMap);
                    hashMap = null;
                    return HBaseClient.this.disconnectEverything();
                }
                HBaseClient.this.zkclient.disconnectZK();
                return arrayList;
            }

            public String toString() {
                return "wait " + n + " RegionClient.shutdown()";
            }
        });
    }

    public Deferred<Object> ensureTableFamilyExists(String string, String string2) {
        return this.ensureTableFamilyExists(string.getBytes(), string2.getBytes());
    }

    public Deferred<Object> ensureTableFamilyExists(byte[] byArray, byte[] byArray2) {
        GetRequest getRequest = new GetRequest(byArray, EMPTY_ARRAY);
        if (byArray2 != EMPTY_ARRAY) {
            getRequest.family(byArray2);
        }
        Deferred<ArrayList<KeyValue>> deferred = this.get(getRequest);
        return deferred;
    }

    public Deferred<Object> ensureTableExists(String string) {
        return this.ensureTableFamilyExists(string.getBytes(), EMPTY_ARRAY);
    }

    public Deferred<Object> ensureTableExists(byte[] byArray) {
        return this.ensureTableFamilyExists(byArray, EMPTY_ARRAY);
    }

    public Deferred<ArrayList<KeyValue>> get(GetRequest getRequest) {
        return this.sendRpcToRegion(getRequest).addCallbacks(got, Callback.PASSTHROUGH);
    }

    public Scanner newScanner(byte[] byArray) {
        return new Scanner(this, byArray);
    }

    public Scanner newScanner(String string) {
        return new Scanner(this, string.getBytes());
    }

    Deferred<Long> openScanner(final Scanner scanner) {
        return this.sendRpcToRegion(scanner.getOpenRequest()).addCallbacks(scanner_opened, (Callback)new Callback<Object, Object>(){

            public Object call(Object object) {
                scanner.invalidate();
                return object;
            }

            public String toString() {
                return "openScanner errback";
            }
        });
    }

    Deferred<Object> scanNextRows(Scanner scanner) {
        RegionClient regionClient;
        RegionInfo regionInfo = scanner.currentRegion();
        RegionClient regionClient2 = regionClient = regionInfo == null ? null : this.region2client.get(regionInfo);
        if (regionClient == null) {
            scanner.invalidate();
            Deferred<ArrayList<ArrayList<KeyValue>>> deferred = scanner.nextRows();
            return deferred;
        }
        HBaseRpc hBaseRpc = scanner.getNextRowsRequest();
        Deferred<Object> deferred = hBaseRpc.getDeferred();
        regionClient.sendRpc(hBaseRpc);
        return deferred;
    }

    Deferred<Object> closeScanner(Scanner scanner) {
        RegionClient regionClient;
        RegionInfo regionInfo = scanner.currentRegion();
        RegionClient regionClient2 = regionClient = regionInfo == null ? null : this.region2client.get(regionInfo);
        if (regionClient == null) {
            LOG.warn("Cannot close " + scanner + " properly, no connection open for " + Bytes.pretty(regionInfo == null ? null : regionInfo.name()));
            return Deferred.fromResult(null);
        }
        HBaseRpc hBaseRpc = scanner.getCloseRequest();
        Deferred<Object> deferred = hBaseRpc.getDeferred();
        regionClient.sendRpc(hBaseRpc);
        return deferred;
    }

    public Deferred<Long> atomicIncrement(AtomicIncrementRequest atomicIncrementRequest) {
        return this.sendRpcToRegion(atomicIncrementRequest).addCallbacks(icv_done, Callback.PASSTHROUGH);
    }

    public Deferred<Long> atomicIncrement(AtomicIncrementRequest atomicIncrementRequest, boolean bl) {
        atomicIncrementRequest.setDurable(bl);
        return this.atomicIncrement(atomicIncrementRequest);
    }

    public Deferred<Object> put(PutRequest putRequest) {
        return this.sendRpcToRegion(putRequest);
    }

    public Deferred<RowLock> lockRow(final RowLockRequest rowLockRequest) {
        return this.sendRpcToRegion(rowLockRequest).addCallbacks((Callback)new Callback<RowLock, Object>(){

            public RowLock call(Object object) {
                if (object instanceof Long) {
                    return new RowLock(rowLockRequest.getRegion().name(), (Long)object);
                }
                throw new InvalidResponseException(Long.class, object);
            }

            public String toString() {
                return "type lockRow response";
            }
        }, Callback.PASSTHROUGH);
    }

    public Deferred<Object> unlockRow(RowLock rowLock) {
        RegionClient regionClient;
        byte[] byArray = rowLock.region();
        RegionInfo regionInfo = this.regions_cache.get(byArray);
        if (HBaseClient.knownToBeNSREd(regionInfo)) {
            return Deferred.fromResult(null);
        }
        RegionClient regionClient2 = regionClient = regionInfo == null ? null : this.region2client.get(regionInfo);
        if (regionClient == null) {
            LOG.warn("Cannot release " + rowLock + ", no connection open for " + Bytes.pretty(byArray));
            return Deferred.fromResult(null);
        }
        RowLockRequest.ReleaseRequest releaseRequest = new RowLockRequest.ReleaseRequest(rowLock, regionInfo);
        releaseRequest.setRegion(regionInfo);
        Deferred<Object> deferred = releaseRequest.getDeferred();
        regionClient.sendRpc(releaseRequest);
        return deferred;
    }

    public Deferred<Object> delete(DeleteRequest deleteRequest) {
        return this.sendRpcToRegion(deleteRequest);
    }

    Deferred<Object> sendRpcToRegion(final HBaseRpc hBaseRpc) {
        final class RetryRpc
        implements Callback<Deferred<Object>, Object> {
            RetryRpc() {
            }

            public Deferred<Object> call(Object object) {
                if (object instanceof NonRecoverableException) {
                    return Deferred.fromError((Exception)((NonRecoverableException)object));
                }
                return HBaseClient.this.sendRpcToRegion(hBaseRpc);
            }

            public String toString() {
                return "retry RPC";
            }
        }
        if (HBaseClient.cannotRetryRequest(hBaseRpc)) {
            return HBaseClient.tooManyAttempts(hBaseRpc, null);
        }
        hBaseRpc.attempt = (byte)(hBaseRpc.attempt + 1);
        byte[] byArray = hBaseRpc.table;
        byte[] byArray2 = hBaseRpc.key;
        RegionInfo regionInfo = this.getRegion(byArray, byArray2);
        if (regionInfo != null) {
            RegionClient regionClient;
            if (HBaseClient.knownToBeNSREd(regionInfo)) {
                NotServingRegionException notServingRegionException = new NotServingRegionException("Region known to be unavailable", hBaseRpc);
                Deferred deferred = hBaseRpc.getDeferred().addBothDeferring((Callback)new RetryRpc());
                this.handleNSRE(hBaseRpc, regionInfo.name(), notServingRegionException);
                return deferred;
            }
            RegionClient regionClient2 = regionClient = Bytes.equals(regionInfo.table(), ROOT) ? this.rootregion : this.region2client.get(regionInfo);
            if (regionClient != null && regionClient.isAlive()) {
                hBaseRpc.setRegion(regionInfo);
                Deferred<Object> deferred = hBaseRpc.getDeferred();
                regionClient.sendRpc(hBaseRpc);
                return deferred;
            }
        }
        return this.locateRegion(byArray, byArray2).addBothDeferring((Callback)new RetryRpc());
    }

    public long rootLookupCount() {
        return this.root_lookups.get();
    }

    public long uncontendedMetaLookupCount() {
        return this.meta_lookups_with_permit.get();
    }

    public long contendedMetaLookupCount() {
        return this.meta_lookups_wo_permit.get();
    }

    static boolean cannotRetryRequest(HBaseRpc hBaseRpc) {
        return hBaseRpc.attempt > 10;
    }

    static Deferred<Object> tooManyAttempts(HBaseRpc hBaseRpc, HBaseException hBaseException) {
        NonRecoverableException nonRecoverableException = new NonRecoverableException("Too many attempts: " + hBaseRpc, hBaseException);
        hBaseRpc.callback(nonRecoverableException);
        return Deferred.fromError((Exception)nonRecoverableException);
    }

    private Deferred<Object> locateRegion(byte[] byArray, byte[] byArray2) {
        RegionClient regionClient;
        RegionInfo regionInfo;
        boolean bl = Bytes.equals(byArray, META);
        boolean bl2 = !bl && Bytes.equals(byArray, ROOT);
        byte[] byArray3 = bl2 ? null : HBaseClient.createRegionSearchKey(byArray, byArray2);
        RegionInfo regionInfo2 = regionInfo = bl || bl2 ? null : this.getRegion(META, byArray3);
        if (regionInfo != null && (regionClient = this.region2client.get(regionInfo)) != null && regionClient.isAlive()) {
            boolean bl3 = regionClient.acquireMetaLookupPermit();
            if (!bl3 && this.getRegion(byArray, byArray2) != null) {
                return Deferred.fromResult(null);
            }
            Deferred deferred = regionClient.getClosestRowBefore(regionInfo, META, byArray3, INFO).addCallback((Callback)this.meta_lookup_done);
            if (bl3) {
                final class ReleaseMetaLookupPermit
                implements Callback<Object, Object> {
                    ReleaseMetaLookupPermit() {
                    }

                    public Object call(Object object) {
                        regionClient.releaseMetaLookupPermit();
                        return object;
                    }

                    public String toString() {
                        return "release .META. lookup permit";
                    }
                }
                deferred.addBoth((Callback)new ReleaseMetaLookupPermit());
                this.meta_lookups_with_permit.incrementAndGet();
            } else {
                this.meta_lookups_wo_permit.incrementAndGet();
            }
            return deferred.addErrback(this.newLocateRegionErrback(byArray, byArray2));
        }
        regionClient = this.rootregion;
        if (regionClient == null || !regionClient.isAlive()) {
            return this.zkclient.getDeferredRoot();
        }
        if (bl2) {
            return Deferred.fromResult(null);
        }
        byte[] byArray4 = HBaseClient.createRegionSearchKey(META, byArray3);
        RegionInfo regionInfo3 = new RegionInfo(ROOT, ROOT_REGION, EMPTY_ARRAY);
        this.root_lookups.incrementAndGet();
        return regionClient.getClosestRowBefore(regionInfo3, ROOT, byArray4, INFO).addCallback((Callback)this.root_lookup_done).addErrback(this.newLocateRegionErrback(byArray, byArray2));
    }

    private Callback<Object, Exception> newLocateRegionErrback(final byte[] byArray, final byte[] byArray2) {
        return new Callback<Object, Exception>(){

            public Object call(Exception exception) {
                if (exception instanceof TableNotFoundException) {
                    return new TableNotFoundException(byArray);
                }
                if (exception instanceof RecoverableException) {
                    return HBaseClient.this.locateRegion(byArray, byArray2);
                }
                return exception;
            }

            public String toString() {
                return "locateRegion errback";
            }
        };
    }

    private static byte[] createRegionSearchKey(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length + 3];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        byArray3[byArray.length] = 44;
        System.arraycopy(byArray2, 0, byArray3, byArray.length + 1, byArray2.length);
        byArray3[byArray3.length - 2] = 44;
        byArray3[byArray3.length - 1] = 58;
        return byArray3;
    }

    private RegionInfo getRegion(byte[] byArray, byte[] byArray2) {
        if (Bytes.equals(byArray, ROOT)) {
            return new RegionInfo(ROOT, ROOT_REGION, EMPTY_ARRAY);
        }
        byte[] byArray3 = HBaseClient.createRegionSearchKey(byArray, byArray2);
        Map.Entry<byte[], RegionInfo> entry = this.regions_cache.floorEntry(byArray3);
        if (entry == null) {
            return null;
        }
        if (!HBaseClient.isCacheKeyForTable(byArray, entry.getKey())) {
            return null;
        }
        byArray3 = null;
        RegionInfo regionInfo = entry.getValue();
        entry = null;
        byte[] byArray4 = regionInfo.stopKey();
        if (byArray4 != EMPTY_ARRAY && Bytes.memcmp(byArray2, byArray4) >= 0) {
            return null;
        }
        return regionInfo;
    }

    private static boolean isCacheKeyForTable(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return byArray2[byArray.length] == 44;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionClient discoverRegion(ArrayList<KeyValue> arrayList) {
        int n;
        Object object;
        Object object2;
        Object object32;
        if (arrayList.isEmpty()) {
            throw new TableNotFoundException();
        }
        String string = null;
        int n2 = -42;
        RegionInfo regionInfo = null;
        byte[] byArray = null;
        for (Object object32 : arrayList) {
            object2 = object32.qualifier();
            if (Arrays.equals(REGIONINFO, object2)) {
                object = new byte[1][];
                regionInfo = RegionInfo.fromKeyValue(object32, object);
                if (HBaseClient.knownToBeNSREd(regionInfo)) {
                    this.invalidateRegionCache(regionInfo.name(), true, "has marked it as split.");
                    return null;
                }
                byArray = object[0];
                continue;
            }
            if (!Arrays.equals(SERVER, object2) || object32.value() == EMPTY_ARRAY) continue;
            object = object32.value();
            for (n = ((byte[][])object).length - 1; n > 0 && object[n] != 58; --n) {
            }
            if (n == 0) {
                throw BrokenMetaException.badKV(regionInfo, "an `info:server' cell doesn't contain `:' to separate the `host:port'" + Bytes.pretty((byte[])object), object32);
            }
            string = HBaseClient.getIP(new String((byte[])object, 0, n));
            try {
                n2 = HBaseClient.parsePortNumber(new String((byte[])object, n + 1, ((byte[][])object).length - n - 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw BrokenMetaException.badKV(regionInfo, "an `info:server' cell contains an invalid port: " + numberFormatException.getMessage() + " in " + Bytes.pretty((byte[])object), object32);
            }
        }
        if (byArray == null) {
            throw new BrokenMetaException(null, "It didn't contain any `info:regioninfo' cell:  " + arrayList);
        }
        Object object4 = regionInfo.name();
        if (string == null) {
            this.invalidateRegionCache((byte[])object4, true, "no longer has it assigned.");
            return null;
        }
        object32 = this.newClient(string, n2);
        if (object32 == (object2 = (Object)((Object)this.region2client.put(regionInfo, (RegionClient)((Object)object32))))) {
            return object32;
        }
        KeyValue keyValue = object32;
        synchronized (keyValue) {
            ArrayList<RegionInfo> arrayList2;
            object = this.regions_cache.put((byte[])object4, regionInfo);
            ArrayList<RegionInfo> arrayList3 = this.client2regions.get(object32);
            if (arrayList3 == null && (arrayList3 = this.client2regions.putIfAbsent((RegionClient)((Object)object32), arrayList2 = new ArrayList())) == null) {
                arrayList3 = arrayList2;
            }
            arrayList2 = arrayList3;
            synchronized (arrayList2) {
                arrayList3.add(regionInfo);
                n = arrayList3.size();
            }
        }
        LOG.info((object2 == null ? "Added" : "Replaced") + " client for" + " region " + regionInfo + ", which was " + (object == null ? "added to" : "updated in") + " the" + " regions cache.  Now we know that " + object32 + " is hosting " + n + " region" + (n > 1 ? Character.valueOf('s') : "") + '.');
        return object32;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateRegionCache(byte[] byArray, boolean bl, String string) {
        if (byArray == ROOT_REGION) {
            if (string != null) {
                LOG.info("Invalidated cache for -ROOT- as " + (Object)((Object)this.rootregion) + ' ' + string);
            }
            this.rootregion = null;
            return;
        }
        RegionInfo regionInfo = bl ? this.regions_cache.put(byArray, new RegionInfo(EMPTY_ARRAY, byArray, EMPTY_ARRAY)) : this.regions_cache.remove(byArray);
        RegionInfo regionInfo2 = regionInfo != null ? regionInfo : new RegionInfo(EMPTY_ARRAY, byArray, EMPTY_ARRAY);
        RegionClient regionClient = this.region2client.remove(regionInfo2);
        if (regionInfo != null && !Bytes.equals(regionInfo.name(), byArray)) {
            LOG.warn("Oops, invalidated the wrong regions cache entry.  Meant to remove " + Bytes.pretty(byArray) + " but instead removed " + regionInfo);
        }
        if (regionClient == null) {
            return;
        }
        ArrayList<RegionInfo> arrayList = this.client2regions.get((Object)regionClient);
        if (arrayList != null) {
            ArrayList<RegionInfo> arrayList2 = arrayList;
            synchronized (arrayList2) {
                arrayList.remove(regionInfo2);
            }
        }
        if (string != null) {
            LOG.info("Invalidated cache for " + regionInfo2 + " as " + (Object)((Object)regionClient) + ' ' + string);
        }
    }

    private static boolean knownToBeNSREd(RegionInfo regionInfo) {
        return regionInfo.table() == EMPTY_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleNSRE(HBaseRpc hBaseRpc, final byte[] byArray, NotServingRegionException notServingRegionException) {
        ArrayList<HBaseRpc> arrayList;
        boolean bl = !HBaseClient.cannotRetryRequest(hBaseRpc);
        boolean bl2 = true;
        ArrayList<HBaseRpc> arrayList2 = this.got_nsre.get(byArray);
        HBaseRpc hBaseRpc2 = null;
        if (arrayList2 == null) {
            arrayList = new ArrayList<HBaseRpc>(64);
            hBaseRpc2 = GetRequest.exists(hBaseRpc.table, hBaseRpc.key);
            arrayList.add(hBaseRpc2);
            if (bl) {
                arrayList.add(hBaseRpc);
            }
            if ((arrayList2 = this.got_nsre.putIfAbsent(byArray, arrayList)) == null) {
                arrayList2 = arrayList;
                bl2 = false;
            }
        }
        if (bl2) {
            int n;
            boolean bl3 = true;
            Object object = arrayList2;
            synchronized (object) {
                n = arrayList2.size();
                if (n == 0) {
                    ArrayList<HBaseRpc> arrayList3 = this.got_nsre.putIfAbsent(byArray, arrayList2);
                    if (arrayList3 == null) {
                        hBaseRpc2 = GetRequest.exists(hBaseRpc.table, hBaseRpc.key);
                        arrayList2.add(hBaseRpc2);
                        if (bl) {
                            arrayList2.add(hBaseRpc);
                        }
                        bl2 = false;
                    } else {
                        if (bl) {
                            ArrayList<HBaseRpc> arrayList4 = arrayList3;
                            synchronized (arrayList4) {
                                if (arrayList3.isEmpty()) {
                                    LOG.error("WTF?  Shouldn't happen!  Lost 2 races and found an empty list of NSRE'd RPCs (" + arrayList3 + ") for " + Bytes.pretty(byArray));
                                    hBaseRpc2 = GetRequest.exists(hBaseRpc.table, hBaseRpc.key);
                                    arrayList3.add(hBaseRpc2);
                                } else {
                                    hBaseRpc2 = arrayList3.get(0);
                                }
                                if (bl) {
                                    arrayList3.add(hBaseRpc);
                                }
                            }
                        }
                        arrayList2 = arrayList3;
                    }
                } else {
                    hBaseRpc2 = arrayList2.get(0);
                    if (hBaseRpc2 != hBaseRpc) {
                        if (n < 10000) {
                            if (n == 1000) {
                                arrayList2.add(null);
                            } else if (bl) {
                                bl3 = false;
                                if (arrayList2.contains(hBaseRpc)) {
                                    LOG.error("WTF?  Trying to add " + hBaseRpc + " twice to NSREd RPC" + " on " + Bytes.pretty(byArray));
                                } else {
                                    arrayList2.add(hBaseRpc);
                                }
                            }
                        }
                    } else {
                        bl3 = false;
                    }
                }
            }
            if (bl2 && hBaseRpc2 != hBaseRpc) {
                if (n != 10000 && n % 500 == 0) {
                    object = "There are now " + n + " RPCs pending due to NSRE on " + Bytes.pretty(byArray);
                    if (n + 500 < 10000) {
                        LOG.info((String)object);
                    } else {
                        LOG.warn((String)object);
                    }
                }
                if (bl3) {
                    hBaseRpc.callback(new PleaseThrottleException(n + " RPCs waiting on " + Bytes.pretty(byArray) + " to come back online", notServingRegionException, hBaseRpc));
                }
                return;
            }
        }
        this.invalidateRegionCache(byArray, true, (bl2 ? "still " : "") + "seems to be splitting or closing it.");
        arrayList = arrayList2;
        final HBaseRpc hBaseRpc3 = hBaseRpc2;
        arrayList2 = null;
        hBaseRpc2 = null;
        if (bl2 && hBaseRpc3.attempt > 1) {
            hBaseRpc3.attempt = (byte)(hBaseRpc3.attempt - 1);
        } else if (!bl) {
            hBaseRpc.callback(HBaseClient.tooManyAttempts(hBaseRpc, notServingRegionException));
        }
        hBaseRpc = null;
        int n = hBaseRpc3.attempt < 4 ? 200 * (hBaseRpc3.attempt + 2) : 1000 + (1 << hBaseRpc3.attempt);
        final class NSRETimer
        implements TimerTask {
            NSRETimer() {
            }

            public void run(Timeout timeout) {
                if (hBaseRpc3.attempt == 0) {
                    final class RetryNSREd
                    implements Callback<Object, Object> {
                        final /* synthetic */ HBaseRpc val$probe;
                        final /* synthetic */ byte[] val$region_name;
                        final /* synthetic */ ArrayList val$rpcs;
                        final /* synthetic */ HBaseClient this$0;

                        RetryNSREd() {
                            this.this$0 = hBaseClient;
                            this.val$probe = hBaseRpc;
                            this.val$region_name = byArray;
                            this.val$rpcs = arrayList;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Object call(Object object) {
                            HBaseRpc hBaseRpc;
                            Iterator<E> iterator;
                            ArrayList arrayList;
                            ArrayList arrayList2;
                            if (object instanceof Exception) {
                                HBaseClient.access$200().warn("Probe " + this.val$probe + " failed", (Throwable)((Exception)object));
                            }
                            if ((arrayList2 = (ArrayList)HBaseClient.access$1000(this.this$0).remove(this.val$region_name)) != this.val$rpcs && arrayList2 != null) {
                                arrayList = arrayList2;
                                synchronized (arrayList) {
                                    iterator = this.val$rpcs;
                                    synchronized (iterator) {
                                        HBaseClient.access$200().error("WTF?  Impossible!  Removed the wrong list of RPCs from got_nsre.  Was expecting list@" + System.identityHashCode(this.val$rpcs) + " (size=" + this.val$rpcs.size() + "), got list@" + System.identityHashCode(arrayList2) + " (size=" + arrayList2.size() + ')');
                                    }
                                    iterator = arrayList2.iterator();
                                    while (iterator.hasNext()) {
                                        hBaseRpc = (HBaseRpc)iterator.next();
                                        if (hBaseRpc == null || hBaseRpc == this.val$probe) continue;
                                        this.this$0.sendRpcToRegion(hBaseRpc);
                                    }
                                    arrayList2.clear();
                                }
                            }
                            arrayList2 = null;
                            arrayList = this.val$rpcs;
                            synchronized (arrayList) {
                                if (HBaseClient.access$200().isDebugEnabled()) {
                                    HBaseClient.access$200().debug("Retrying " + this.val$rpcs.size() + " RPCs now that the NSRE on " + Bytes.pretty(this.val$region_name) + " seems to have cleared");
                                }
                                if ((iterator = this.val$rpcs.iterator()).hasNext()) {
                                    hBaseRpc = (HBaseRpc)iterator.next();
                                    if (hBaseRpc != this.val$probe) {
                                        HBaseClient.access$200().error("WTF?  Impossible!  Expected first == probe but first=" + hBaseRpc + " and probe=" + this.val$probe);
                                        this.this$0.sendRpcToRegion(hBaseRpc);
                                    }
                                    while (iterator.hasNext()) {
                                        hBaseRpc = (HBaseRpc)iterator.next();
                                        if (hBaseRpc == null) continue;
                                        this.this$0.sendRpcToRegion(hBaseRpc);
                                    }
                                } else {
                                    HBaseClient.access$200().error("WTF?  Impossible!  Empty rpcs array=" + this.val$rpcs + " found by " + this);
                                }
                                this.val$rpcs.clear();
                            }
                            return object;
                        }

                        public String toString() {
                            return "retry other RPCs NSRE'd on " + Bytes.pretty(this.val$region_name);
                        }
                    }
                    hBaseRpc3.getDeferred().addBoth((Callback)new RetryNSREd(HBaseClient.this, hBaseRpc3, byArray, arrayList));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Done waiting after NSRE on " + Bytes.pretty(byArray) + ", retrying " + hBaseRpc3);
                }
                HBaseClient.this.invalidateRegionCache(byArray, false, null);
                HBaseClient.this.sendRpcToRegion(hBaseRpc3);
            }

            public String toString() {
                return "probe NSRE " + hBaseRpc3;
            }
        }
        this.timer.newTimeout((TimerTask)new NSRETimer(), (long)n, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionClient newClient(String string, int n) {
        RegionClient regionClient;
        String string2 = string + ':' + n;
        SocketChannel socketChannel = null;
        SocketChannelConfig socketChannelConfig = this.ip2client;
        synchronized (socketChannelConfig) {
            regionClient = this.ip2client.get(string2);
            if (regionClient != null && regionClient.isAlive()) {
                return regionClient;
            }
            socketChannel = this.channel_factory.newChannel((ChannelPipeline)new RegionClientPipeline());
            regionClient = (RegionClient)socketChannel.getPipeline().get(RegionClient.class);
            this.ip2client.put(string2, regionClient);
        }
        socketChannelConfig = socketChannel.getConfig();
        socketChannelConfig.setConnectTimeoutMillis(5000);
        socketChannelConfig.setTcpNoDelay(true);
        socketChannelConfig.setKeepAlive(true);
        socketChannel.connect((SocketAddress)new InetSocketAddress(string, n));
        return regionClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InetSocketAddress slowSearchClientIP(RegionClient regionClient) {
        int n;
        Object object;
        String string = null;
        HashMap<String, RegionClient> hashMap = this.ip2client;
        synchronized (hashMap) {
            for (Map.Entry<String, RegionClient> entry : this.ip2client.entrySet()) {
                if (entry.getValue() != regionClient) continue;
                string = entry.getKey();
                break;
            }
        }
        if (string == null) {
            object = this.ip2client;
            synchronized (object) {
                hashMap = new HashMap<String, RegionClient>(this.ip2client);
            }
            LOG.error("WTF?  Should never happen!  Couldn't find " + (Object)((Object)regionClient) + " in " + hashMap);
            return null;
        }
        LOG.warn("Couldn't connect to the RegionServer @ " + string);
        int n2 = string.indexOf(58, 1);
        if (n2 < 1) {
            LOG.error("WTF?  Should never happen!  No `:' found in " + string);
            return null;
        }
        object = HBaseClient.getIP(string.substring(0, n2));
        try {
            n = HBaseClient.parsePortNumber(string.substring(n2 + 1, string.length()));
        }
        catch (NumberFormatException numberFormatException) {
            LOG.error("WTF?  Should never happen!  Bad port in " + string, (Throwable)numberFormatException);
            return null;
        }
        return new InetSocketAddress((String)object, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClientFromCache(RegionClient regionClient, SocketAddress socketAddress) {
        RegionClient regionClient2;
        Serializable serializable;
        InetSocketAddress inetSocketAddress;
        Object object;
        ArrayList<RegionInfo> arrayList;
        if (regionClient == this.rootregion) {
            LOG.info("Lost connection with the -ROOT- region");
            this.rootregion = null;
        }
        if ((arrayList = this.client2regions.remove((Object)regionClient)) != null) {
            ArrayList<RegionInfo> object2 = arrayList;
            synchronized (object2) {
                object = arrayList.toArray(new RegionInfo[arrayList.size()]);
                arrayList = null;
            }
            for (RegionInfo regionInfo : object) {
                RegionClient regionClient3;
                byte[] byArray = regionInfo.table();
                byte[] byArray2 = regionInfo.stopKey();
                byte[] byArray3 = HBaseClient.createRegionSearchKey(byArray2.length == 0 ? Arrays.copyOf(byArray, byArray.length + 1) : byArray, byArray2);
                Map.Entry<byte[], RegionInfo> entry = this.regions_cache.lowerEntry(byArray3);
                if (entry != null && entry.getValue() == regionInfo) {
                    this.regions_cache.remove(entry.getKey());
                    LOG.debug("Removed from regions cache: {}", (Object)regionInfo);
                }
                if (regionClient == (regionClient3 = this.region2client.remove(regionInfo))) {
                    LOG.debug("Association removed: {} -> {}", (Object)regionInfo, (Object)regionClient);
                    continue;
                }
                if (regionClient3 == null) continue;
                LOG.warn("When handling disconnection of " + (Object)((Object)regionClient) + " and removing " + regionInfo + " from region2client" + ", it was found that " + (Object)((Object)regionClient3) + " was in fact" + " serving this region");
            }
        }
        if (socketAddress == null) {
            return;
        }
        object = null;
        if (socketAddress instanceof InetSocketAddress) {
            inetSocketAddress = (InetSocketAddress)socketAddress;
            serializable = inetSocketAddress.getAddress();
            if (serializable == null) {
                LOG.error("WTF?  Unresolved IP for " + socketAddress + ".  This shouldn't happen.");
                return;
            }
        } else {
            LOG.error("WTF?  Found a non-InetSocketAddress remote: " + socketAddress + ".  This shouldn't happen.");
            return;
        }
        object = serializable.getHostAddress() + ':' + inetSocketAddress.getPort();
        serializable = this.ip2client;
        synchronized (serializable) {
            regionClient2 = this.ip2client.remove(object);
        }
        LOG.debug("Removed from IP cache: {} -> {}", object, (Object)regionClient);
        if (regionClient2 == null) {
            LOG.warn("When expiring " + (Object)((Object)regionClient) + " from the client cache (host:port=" + (String)object + "), it was found that there was no entry" + " corresponding to " + socketAddress + ".  This shouldn't happen.");
        }
    }

    private static String getIP(String string) {
        long l = System.nanoTime();
        try {
            String string2 = InetAddress.getByName(string).getHostAddress();
            long l2 = System.nanoTime() - l;
            if (l2 > 500000L && LOG.isDebugEnabled()) {
                LOG.debug("Resolved IP of `" + string + "' to " + string2 + " in " + l2 + "ns");
            } else if (l2 >= 3000000L) {
                LOG.warn("Slow DNS lookup!  Resolved IP of `" + string + "' to " + string2 + " in " + l2 + "ns");
            }
            return string2;
        }
        catch (UnknownHostException unknownHostException) {
            LOG.error("Failed to resolve the IP of `" + string + "' in " + (System.nanoTime() - l) + "ns");
            return null;
        }
    }

    private static int parsePortNumber(String string) throws NumberFormatException {
        int n = Integer.parseInt(string);
        if (n <= 0 || n > 65535) {
            throw new NumberFormatException(n == 0 ? "port is zero" : (n < 0 ? "port is negative: " : "port is too large: ") + n);
        }
        return n;
    }

    static /* synthetic */ int access$001(HBaseClient hBaseClient) {
        return super.hashCode();
    }

    static /* synthetic */ NioClientSocketChannelFactory access$100(HBaseClient hBaseClient) {
        return hBaseClient.channel_factory;
    }

    static /* synthetic */ ConcurrentSkipListMap access$1000(HBaseClient hBaseClient) {
        return hBaseClient.got_nsre;
    }

    private final class ZKClient
    implements Watcher {
        private final String quorum_spec;
        private final String base_path;
        private ZooKeeper zk;
        private ArrayList<Deferred<Object>> deferred_rootregion;

        public ZKClient(String string, String string2) {
            this.quorum_spec = string;
            this.base_path = string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Deferred<Object> getDeferredRoot() {
            Deferred deferred = new Deferred();
            ZKClient zKClient = this;
            synchronized (zKClient) {
                try {
                    this.connectZK();
                    if (this.deferred_rootregion == null) {
                        LOG.info("Need to find the -ROOT- region");
                        this.deferred_rootregion = new ArrayList();
                    }
                    this.deferred_rootregion.add((Deferred<Object>)deferred);
                }
                catch (NonRecoverableException nonRecoverableException) {
                    LOG.error(nonRecoverableException.getMessage(), nonRecoverableException.getCause());
                    deferred.callback((Object)nonRecoverableException);
                }
            }
            return deferred;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Deferred<Object> getDeferredRootIfBeingLookedUp() {
            ZKClient zKClient = this;
            synchronized (zKClient) {
                if (this.deferred_rootregion == null) {
                    return null;
                }
                Deferred deferred = new Deferred();
                this.deferred_rootregion.add((Deferred<Object>)deferred);
                return deferred;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ArrayList<Deferred<Object>> atomicGetAndRemoveWaiters() {
            ZKClient zKClient = this;
            synchronized (zKClient) {
                ArrayList<Deferred<Object>> arrayList;
                try {
                    arrayList = this.deferred_rootregion;
                    this.deferred_rootregion = null;
                }
                catch (Throwable throwable) {
                    this.deferred_rootregion = null;
                    throw throwable;
                }
                return arrayList;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent watchedEvent) {
            LOG.debug("Got ZooKeeper event: {}", (Object)watchedEvent);
            try {
                switch (watchedEvent.getState()) {
                    case SyncConnected: {
                        this.getRootRegion();
                        break;
                    }
                    default: {
                        this.disconnectZK();
                        ZKClient zKClient = this;
                        synchronized (zKClient) {
                            if (this.deferred_rootregion != null) {
                                LOG.warn("No longer connected to ZooKeeper, event=" + watchedEvent);
                                this.connectZK();
                            }
                        }
                        return;
                    }
                }
            }
            catch (Exception exception) {
                LOG.error("Uncaught exception when handling event " + watchedEvent, (Throwable)exception);
                return;
            }
            LOG.debug("Done handling ZooKeeper event: {}", (Object)watchedEvent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void connectZK() {
            try {
                ZKClient zKClient = this;
                synchronized (zKClient) {
                    if (this.zk != null) {
                        return;
                    }
                    this.zk = new ZooKeeper(this.quorum_spec, 5000, (Watcher)this);
                }
            }
            catch (UnknownHostException unknownHostException) {
                throw new NonRecoverableException("Cannot connect to ZooKeeper, is the quorum specification valid? " + this.quorum_spec, unknownHostException);
            }
            catch (IOException iOException) {
                LOG.error("Failed to connect to ZooKeeper", (Throwable)iOException);
                this.connectZK();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnectZK() {
            ZKClient zKClient = this;
            synchronized (zKClient) {
                if (this.zk == null) {
                    return;
                }
                try {
                    LOG.debug("Ignore any DEBUG exception from ZooKeeper");
                    long l = System.nanoTime();
                    this.zk.close();
                    LOG.debug("ZooKeeper#close completed in {}ns", (Object)(System.nanoTime() - l));
                }
                catch (InterruptedException interruptedException) {
                    LOG.error("Should never happen", (Throwable)interruptedException);
                }
                this.zk = null;
            }
        }

        private void retryGetRootRegionLater(final AsyncCallback.DataCallback dataCallback) {
            HBaseClient.this.timer.newTimeout(new TimerTask(){

                public void run(Timeout timeout) {
                    if (ZKClient.this.zk != null) {
                        LOG.debug("Retrying to find the -ROOT- region in ZooKeeper");
                        ZKClient.this.zk.getData(ZKClient.this.base_path + "/root-region-server", (Watcher)ZKClient.this, dataCallback, null);
                    } else {
                        ZKClient.this.connectZK();
                    }
                }
            }, 1000L, TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getRootRegion() {
            AsyncCallback.DataCallback dataCallback = new AsyncCallback.DataCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void processResult(int n, String string, Object object, byte[] byArray, Stat stat) {
                    if (n == KeeperException.Code.NONODE.intValue()) {
                        LOG.error("The znode for the -ROOT- region doesn't exist!");
                        ZKClient.this.retryGetRootRegionLater(this);
                        return;
                    }
                    if (n != KeeperException.Code.OK.intValue()) {
                        LOG.error("Looks like our ZK session expired or is broken, rc=" + n + ": " + KeeperException.Code.get((int)n));
                        ZKClient.this.disconnectZK();
                        ZKClient.this.connectZK();
                        return;
                    }
                    String string2 = new String(byArray);
                    int n2 = string2.lastIndexOf(58);
                    if (n2 < 0) {
                        LOG.error("Couldn't find the port of the -ROOT- region in " + Bytes.pretty(byArray));
                        ZKClient.this.retryGetRootRegionLater(this);
                        return;
                    }
                    String string3 = HBaseClient.getIP(string2.substring(0, n2));
                    if (string3 == null) {
                        LOG.error("Couldn't resolve the IP of the -ROOT- region from " + string3 + " in \"" + Bytes.pretty(byArray) + '\"');
                        ZKClient.this.retryGetRootRegionLater(this);
                        return;
                    }
                    int n3 = HBaseClient.parsePortNumber(string2.substring(n2 + 1));
                    String string4 = string3 + ':' + n3;
                    LOG.info("Connecting to -ROOT- region @ " + string4);
                    RegionClient regionClient = HBaseClient.this.rootregion = HBaseClient.this.newClient(string3, n3);
                    ArrayList arrayList = ZKClient.this.atomicGetAndRemoveWaiters();
                    if (arrayList != null) {
                        for (Deferred deferred : arrayList) {
                            deferred.callback((Object)regionClient);
                        }
                    }
                    ZKClient.this.disconnectZK();
                    ZKClient zKClient = ZKClient.this;
                    synchronized (zKClient) {
                        if (ZKClient.this.deferred_rootregion != null) {
                            ZKClient.this.connectZK();
                        }
                    }
                }
            };
            ZKClient zKClient = this;
            synchronized (zKClient) {
                if (this.zk != null) {
                    LOG.debug("Finding the -ROOT- region in ZooKeeper");
                    this.zk.getData(this.base_path + "/root-region-server", (Watcher)this, dataCallback, null);
                }
            }
        }
    }

    private final class RegionClientPipeline
    extends DefaultChannelPipeline {
        private boolean disconnected = false;

        RegionClientPipeline() {
            super.addLast("hello", (ChannelHandler)RegionClient.SayHelloFirstRpc.INSTANCE);
            super.addLast("handler", (ChannelHandler)new RegionClient(HBaseClient.this));
        }

        public void sendDownstream(ChannelEvent channelEvent) {
            if (channelEvent instanceof ChannelStateEvent) {
                this.handleDisconnect((ChannelStateEvent)channelEvent);
            }
            super.sendDownstream(channelEvent);
        }

        public void sendUpstream(ChannelEvent channelEvent) {
            if (channelEvent instanceof ChannelStateEvent) {
                this.handleDisconnect((ChannelStateEvent)channelEvent);
            }
            super.sendUpstream(channelEvent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleDisconnect(ChannelStateEvent channelStateEvent) {
            if (this.disconnected) {
                return;
            }
            switch (channelStateEvent.getState()) {
                case OPEN: {
                    if (channelStateEvent.getValue() == Boolean.FALSE) break;
                    return;
                }
                case CONNECTED: {
                    if (channelStateEvent.getValue() == null) break;
                    return;
                }
                default: {
                    return;
                }
            }
            this.disconnected = true;
            try {
                RegionClient regionClient = (RegionClient)super.get(RegionClient.class);
                SocketAddress socketAddress = super.getChannel().getRemoteAddress();
                if (socketAddress == null) {
                    socketAddress = HBaseClient.this.slowSearchClientIP(regionClient);
                }
                RegionClient regionClient2 = regionClient;
                synchronized (regionClient2) {
                    HBaseClient.this.removeClientFromCache(regionClient, socketAddress);
                }
            }
            catch (Exception exception) {
                LoggerFactory.getLogger(RegionClientPipeline.class).error("Uncaught exception when handling a disconnection of " + this.getChannel(), (Throwable)exception);
            }
        }
    }

    private final class RootCB
    implements Callback<Object, ArrayList<KeyValue>> {
        private RootCB() {
        }

        public Object call(ArrayList<KeyValue> arrayList) {
            return HBaseClient.this.discoverRegion(arrayList);
        }

        public String toString() {
            return "locateRegion in ROOT";
        }
    }

    private final class MetaCB
    implements Callback<Object, ArrayList<KeyValue>> {
        private MetaCB() {
        }

        public Object call(ArrayList<KeyValue> arrayList) {
            return HBaseClient.this.discoverRegion(arrayList);
        }

        public String toString() {
            return "locateRegion in META";
        }
    }
}

