/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.stumbleupon.async.Deferred;
import org.hbase.async.Bytes;
import org.hbase.async.KeyValue;
import org.hbase.async.RegionInfo;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.util.CharsetUtil;

public abstract class HBaseRpc {
    private final byte[] method;
    private Deferred<Object> deferred;
    final byte[] table;
    final byte[] key;
    RegionInfo region;
    byte attempt;
    private static final long MAX_BYTE_ARRAY_MASK = -268435456L;

    abstract ChannelBuffer serialize(byte var1);

    HBaseRpc(byte[] byArray) {
        this.method = byArray;
        this.table = null;
        this.key = null;
    }

    HBaseRpc(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        KeyValue.checkTable(byArray2);
        KeyValue.checkKey(byArray3);
        this.method = byArray;
        this.table = byArray2;
        this.key = byArray3;
    }

    final byte[] method() {
        return this.method;
    }

    final void setRegion(RegionInfo regionInfo) {
        if (this.table == null) {
            throw new AssertionError((Object)"Can't use setRegion if no table was given.");
        }
        this.region = regionInfo;
    }

    final RegionInfo getRegion() {
        return this.region;
    }

    final Deferred<Object> getDeferred() {
        if (this.deferred == null) {
            this.deferred = new Deferred();
        }
        return this.deferred;
    }

    final void callback(Object object) {
        Deferred<Object> deferred = this.deferred;
        if (deferred == null) {
            return;
        }
        this.deferred = null;
        this.attempt = 0;
        deferred.callback(object);
    }

    final boolean hasDeferred() {
        return this.deferred != null;
    }

    boolean versionSensitive() {
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(16 + this.method.length + 2 + 8 + (this.table == null ? 4 : this.table.length + 2) + 6 + (this.key == null ? 4 : this.key.length * 2) + 9 + (this.region == null ? 4 : this.region.stringSizeHint()) + 10 + 1 + 1);
        int n = stringBuilder.capacity();
        stringBuilder.append("HBaseRpc(method=");
        Bytes.pretty(stringBuilder, this.method);
        stringBuilder.append(", table=");
        Bytes.pretty(stringBuilder, this.table);
        stringBuilder.append(", key=");
        Bytes.pretty(stringBuilder, this.key);
        stringBuilder.append(", region=");
        if (this.region == null) {
            stringBuilder.append("null");
        } else {
            this.region.toStringbuf(stringBuilder);
        }
        stringBuilder.append(", attempt=").append(this.attempt);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    final String toStringWithQualifiers(String string, byte[] byArray, byte[][] byArray2) {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append(string).append("(table=");
        Bytes.pretty(stringBuilder, this.table);
        stringBuilder.append(", key=");
        Bytes.pretty(stringBuilder, this.key);
        stringBuilder.append(", family=");
        Bytes.pretty(stringBuilder, byArray);
        stringBuilder.append(", qualifiers=");
        if (byArray2 == null) {
            stringBuilder.append("null");
        } else {
            stringBuilder.append('[');
            for (byte[] byArray3 : byArray2) {
                Bytes.pretty(stringBuilder, byArray3);
                stringBuilder.append(", ");
            }
            stringBuilder.setLength(stringBuilder.length() - 2);
            stringBuilder.append(']');
        }
        stringBuilder.append(", attempt=").append(this.attempt).append(", region=");
        if (this.region == null) {
            stringBuilder.append("null");
        } else {
            this.region.toStringbuf(stringBuilder);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    final String toStringWithQualifier(String string, byte[] byArray, byte[] byArray2, String string2) {
        StringBuilder stringBuilder = new StringBuilder(256 + string2.length());
        stringBuilder.append(string).append("(table=");
        Bytes.pretty(stringBuilder, this.table);
        stringBuilder.append(", key=");
        Bytes.pretty(stringBuilder, this.key);
        stringBuilder.append(", family=");
        Bytes.pretty(stringBuilder, byArray);
        stringBuilder.append(", qualifier=");
        Bytes.pretty(stringBuilder, byArray2);
        stringBuilder.append(string2);
        stringBuilder.append(", attempt=").append(this.attempt).append(", region=");
        if (this.region == null) {
            stringBuilder.append("null");
        } else {
            this.region.toStringbuf(stringBuilder);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    final ChannelBuffer newBuffer(int n) {
        int n2 = 10 + this.method.length;
        ChannelBuffer channelBuffer = ChannelBuffers.buffer((int)(n2 + n));
        channelBuffer.setIndex(0, n2);
        return channelBuffer;
    }

    final ChannelBuffer newDynamicBuffer(int n) {
        int n2 = 10 + this.method.length;
        ChannelBuffer channelBuffer = ChannelBuffers.dynamicBuffer((int)(n2 + n));
        channelBuffer.setIndex(0, n2);
        return channelBuffer;
    }

    static void writeHBaseBool(ChannelBuffer channelBuffer, boolean bl) {
        channelBuffer.writeByte(1);
        channelBuffer.writeByte(bl ? 1 : 0);
    }

    static void writeHBaseInt(ChannelBuffer channelBuffer, int n) {
        channelBuffer.writeByte(5);
        channelBuffer.writeInt(n);
    }

    static void writeHBaseLong(ChannelBuffer channelBuffer, long l) {
        channelBuffer.writeByte(6);
        channelBuffer.writeLong(l);
    }

    static void writeHBaseString(ChannelBuffer channelBuffer, String string) {
        channelBuffer.writeByte(10);
        byte[] byArray = string.getBytes(CharsetUtil.UTF_8);
        HBaseRpc.writeVLong(channelBuffer, byArray.length);
        channelBuffer.writeBytes(byArray);
    }

    static void writeHBaseByteArray(ChannelBuffer channelBuffer, byte[] byArray) {
        channelBuffer.writeByte(11);
        HBaseRpc.writeByteArray(channelBuffer, byArray);
    }

    static void writeByteArray(ChannelBuffer channelBuffer, byte[] byArray) {
        HBaseRpc.writeVLong(channelBuffer, byArray.length);
        channelBuffer.writeBytes(byArray);
    }

    static void checkArrayLength(ChannelBuffer channelBuffer, long l) {
        if ((l & 0xFFFFFFFFF0000000L) != 0L) {
            if (l < 0L) {
                throw new IllegalArgumentException("Read negative byte array length: " + l + " in buf=" + channelBuffer + '=' + Bytes.pretty(channelBuffer));
            }
            throw new IllegalArgumentException("Read byte array length that's too large: " + l + " > " + 0xFFFFFFFL + " in buf=" + channelBuffer + '=' + Bytes.pretty(channelBuffer));
        }
    }

    static void checkArrayLength(byte[] byArray) {
        if (((long)byArray.length & 0xFFFFFFFFF0000000L) != 0L) {
            if (byArray.length < 0) {
                throw new AssertionError((Object)("Negative byte array length: " + byArray.length + ' ' + Bytes.pretty(byArray)));
            }
            throw new IllegalArgumentException("Byte array length too big: " + byArray.length + " > " + 0xFFFFFFFL);
        }
    }

    static void checkNonEmptyArrayLength(ChannelBuffer channelBuffer, long l) {
        if (l == 0L) {
            throw new IllegalArgumentException("Read zero-length byte array  in buf=" + channelBuffer + '=' + Bytes.pretty(channelBuffer));
        }
        HBaseRpc.checkArrayLength(channelBuffer, l);
    }

    static byte[] readByteArray(ChannelBuffer channelBuffer) {
        long l = HBaseRpc.readVLong(channelBuffer);
        HBaseRpc.checkArrayLength(channelBuffer, l);
        byte[] byArray = new byte[(int)l];
        channelBuffer.readBytes(byArray);
        return byArray;
    }

    static String readHadoopString(ChannelBuffer channelBuffer) {
        int n = channelBuffer.readInt();
        HBaseRpc.checkArrayLength(channelBuffer, n);
        byte[] byArray = new byte[n];
        channelBuffer.readBytes(byArray);
        return new String(byArray, CharsetUtil.UTF_8);
    }

    static void writeVLong(ChannelBuffer channelBuffer, long l) {
        if (l >= -112L && l <= 127L) {
            channelBuffer.writeByte((int)((byte)l));
            return;
        }
        int n = -112;
        if (l < 0L) {
            l ^= 0xFFFFFFFFFFFFFFFFL;
            n = -120;
        }
        long l2 = l;
        do {
            n = (byte)(n - 1);
        } while ((l2 >>>= 8) != 0L);
        channelBuffer.writeByte(n);
        switch (n & 7) {
            case 0: {
                channelBuffer.writeLong(l);
                break;
            }
            case 1: {
                channelBuffer.writeInt((int)(l >>> 24));
                channelBuffer.writeMedium((int)l);
                break;
            }
            case 2: {
                channelBuffer.writeMedium((int)(l >>> 24));
                channelBuffer.writeMedium((int)l);
                break;
            }
            case 3: {
                channelBuffer.writeByte((int)((byte)(l >>> 32)));
            }
            case 4: {
                channelBuffer.writeInt((int)l);
                break;
            }
            case 5: {
                channelBuffer.writeMedium((int)l);
                break;
            }
            case 6: {
                channelBuffer.writeShort((int)((short)l));
                break;
            }
            case 7: {
                channelBuffer.writeByte((int)((byte)l));
            }
        }
    }

    static long readVLong(ChannelBuffer channelBuffer) {
        byte by = channelBuffer.readByte();
        if ((by & 0xF0) != 128) {
            return by;
        }
        boolean bl = (by & 8) == 0;
        long l = 0L;
        switch (by & 7) {
            case 0: {
                l = channelBuffer.readLong();
                break;
            }
            case 1: {
                l = channelBuffer.readUnsignedInt();
                l <<= 32;
                l |= (long)channelBuffer.readUnsignedMedium();
                break;
            }
            case 2: {
                l = channelBuffer.readUnsignedMedium();
                l <<= 24;
                l |= (long)channelBuffer.readUnsignedMedium();
                break;
            }
            case 3: {
                by = channelBuffer.readByte();
                l <<= 8;
                l |= (long)(by & 0xFF);
            }
            case 4: {
                l <<= 32;
                l |= channelBuffer.readUnsignedInt();
                break;
            }
            case 5: {
                l |= (long)channelBuffer.readUnsignedMedium();
                break;
            }
            case 6: {
                l |= (long)channelBuffer.readUnsignedShort();
                break;
            }
            case 7: {
                by = channelBuffer.readByte();
                l <<= 8;
                l |= (long)(by & 0xFF);
            }
        }
        return bl ? l ^ 0xFFFFFFFFFFFFFFFFL : l;
    }

    public static interface HasValue {
        public byte[] value();
    }

    public static interface HasQualifiers {
        public byte[][] qualifiers();
    }

    public static interface HasQualifier {
        public byte[] qualifier();
    }

    public static interface HasFamily {
        public byte[] family();
    }

    public static interface HasKey {
        public byte[] key();
    }

    public static interface HasTable {
        public byte[] table();
    }
}

