/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import java.util.Arrays;
import org.hbase.async.Bytes;
import org.hbase.async.HBaseClient;
import org.hbase.async.HBaseRpc;
import org.jboss.netty.buffer.ChannelBuffer;

public final class KeyValue
implements Comparable<KeyValue> {
    private final byte[] key;
    private final byte[] family;
    private final byte[] qualifier;
    private final byte[] value;
    static final byte PUT = 4;
    static final byte DELETE_COLUMN = 12;
    static final byte DELETE_FAMILY = 14;

    public KeyValue(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        KeyValue.checkKey(byArray);
        KeyValue.checkFamily(byArray2);
        KeyValue.checkQualifier(byArray3);
        KeyValue.checkValue(byArray4);
        this.key = byArray;
        this.family = byArray2;
        this.qualifier = byArray3;
        this.value = byArray4;
    }

    public byte[] key() {
        return this.key;
    }

    public byte[] family() {
        return this.family;
    }

    public byte[] qualifier() {
        return this.qualifier;
    }

    public byte[] value() {
        return this.value;
    }

    @Override
    public int compareTo(KeyValue keyValue) {
        int n = Bytes.memcmp(this.key, keyValue.key);
        if (n != 0) {
            return n;
        }
        n = Bytes.memcmp(this.family, keyValue.family);
        if (n != 0) {
            return n;
        }
        n = Bytes.memcmp(this.qualifier, keyValue.qualifier);
        if (n != 0) {
            return n;
        }
        n = Bytes.memcmp(this.value, keyValue.value);
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof KeyValue)) {
            return false;
        }
        return this.compareTo((KeyValue)object) == 0;
    }

    public int hashCode() {
        return Arrays.hashCode(this.key) ^ Arrays.hashCode(this.family) ^ Arrays.hashCode(this.qualifier) ^ Arrays.hashCode(this.value);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(84 + this.key.length * 2 + this.family.length + this.qualifier.length + this.value.length);
        stringBuilder.append("KeyValue(key=");
        Bytes.pretty(stringBuilder, this.key);
        stringBuilder.append(", family=");
        Bytes.pretty(stringBuilder, this.family);
        stringBuilder.append(", qualifier=");
        Bytes.pretty(stringBuilder, this.qualifier);
        stringBuilder.append(", value=");
        Bytes.pretty(stringBuilder, this.value);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public static KeyValue fromBuffer(ChannelBuffer channelBuffer, KeyValue keyValue) {
        int n = channelBuffer.readInt();
        HBaseRpc.checkNonEmptyArrayLength(channelBuffer, n);
        int n2 = channelBuffer.readInt();
        HBaseRpc.checkArrayLength(channelBuffer, n2);
        short s = channelBuffer.readShort();
        HBaseRpc.checkArrayLength(channelBuffer, n2);
        byte[] byArray = new byte[s];
        channelBuffer.readBytes(byArray);
        byte by = channelBuffer.readByte();
        if (s + by + 2 + 1 + 8 + 1 > n) {
            KeyValue.invalid("rowkey_length=" + s + " doesn't match key_length + family_length (" + s + " + " + by + " +12) in " + channelBuffer + '=' + Bytes.pretty(channelBuffer));
        }
        byte[] byArray2 = new byte[by];
        channelBuffer.readBytes(byArray2);
        int n3 = n - s - by - 2 - 1 - 8 - 1;
        HBaseRpc.checkArrayLength(channelBuffer, n3);
        byte[] byArray3 = n3 > 0 ? new byte[n3] : HBaseClient.EMPTY_ARRAY;
        channelBuffer.readBytes(byArray3);
        long l = channelBuffer.readLong();
        byte by2 = channelBuffer.readByte();
        byte[] byArray4 = n2 > 0 ? new byte[n2] : HBaseClient.EMPTY_ARRAY;
        channelBuffer.readBytes(byArray4);
        if (2 + s + 1 + by + n3 + 8 + 1 != n) {
            KeyValue.invalid("2 + rl:" + s + " + 1 + fl:" + by + " + ql:" + n3 + " + 8 + 1" + " != kl:" + n);
        }
        if (keyValue == null) {
            return new KeyValue(byArray, byArray2, byArray3, byArray4);
        }
        return new KeyValue(Bytes.deDup(keyValue.key, byArray), Bytes.deDup(keyValue.family, byArray2), Bytes.deDup(keyValue.qualifier, byArray3), byArray4);
    }

    private static void invalid(String string) {
        throw new IllegalArgumentException(string);
    }

    static void checkTable(byte[] byArray) {
        if (byArray.length > 127) {
            throw new IllegalArgumentException("Table name too long: " + byArray.length + " bytes long " + Bytes.pretty(byArray));
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("empty table name");
        }
    }

    static void checkKey(byte[] byArray) {
        if (byArray.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("row key too long: " + byArray.length + " bytes long " + Bytes.pretty(byArray));
        }
    }

    static void checkFamily(byte[] byArray) {
        if (byArray.length > 127) {
            throw new IllegalArgumentException("column family too long: " + byArray.length + " bytes long " + Bytes.pretty(byArray));
        }
    }

    static void checkQualifier(byte[] byArray) {
        HBaseRpc.checkArrayLength(byArray);
    }

    static void checkValue(byte[] byArray) {
        HBaseRpc.checkArrayLength(byArray);
    }

    void serialize(ChannelBuffer channelBuffer, byte by) {
        KeyValue.serialize(channelBuffer, by, Long.MAX_VALUE, this.key, this.family, this.qualifier, this.value);
    }

    int predictSerializedSize() {
        return KeyValue.predictSerializedSize(this.key, this.family, this.qualifier, this.value);
    }

    static int predictSerializedSize(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        return 14 + byArray.length + 1 + byArray2.length + byArray3.length + 8 + 1 + (byArray4 == null ? 0 : byArray4.length);
    }

    static void serialize(ChannelBuffer channelBuffer, byte by, long l, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        int n = byArray4 == null ? 0 : byArray4.length;
        int n2 = 2 + byArray.length + 1 + byArray2.length + byArray3.length + 8 + 1;
        channelBuffer.writeInt(8 + n2 + n);
        channelBuffer.writeInt(n2);
        channelBuffer.writeInt(n);
        channelBuffer.writeShort(byArray.length);
        channelBuffer.writeBytes(byArray);
        channelBuffer.writeByte((int)((byte)byArray2.length));
        channelBuffer.writeBytes(byArray2);
        channelBuffer.writeBytes(byArray3);
        channelBuffer.writeLong(l);
        channelBuffer.writeByte((int)by);
        if (byArray4 != null) {
            channelBuffer.writeBytes(byArray4);
        }
    }
}

