/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.hbase.async.Bytes;
import org.hbase.async.HBaseRpc;
import org.hbase.async.KeyValue;
import org.hbase.async.PutRequest;
import org.jboss.netty.buffer.ChannelBuffer;
import org.slf4j.LoggerFactory;

final class MultiPutRequest
extends HBaseRpc {
    private static final byte[] MULTI_PUT = new byte[]{109, 117, 108, 116, 105, 80, 117, 116};
    private final ArrayList<PutRequest> edits = new ArrayList();
    private static final MultiPutComparator MULTIPUT_CMP = new MultiPutComparator();

    public MultiPutRequest() {
        super(MULTI_PUT);
    }

    public int size() {
        return this.edits.size();
    }

    public void add(PutRequest putRequest) {
        if (putRequest.lockid() != -1L) {
            throw new AssertionError((Object)("Should never happen!  We don't do multi-put with RowLocks but we've been given an edit that has one!  edit=" + putRequest + ", this=" + this));
        }
        this.edits.add(putRequest);
    }

    ArrayList<PutRequest> edits() {
        return this.edits;
    }

    Iterable<PutRequest> handlePartialFailure(Bytes.ByteMap<Integer> byteMap) {
        ArrayList<PutRequest> arrayList = new ArrayList<PutRequest>(this.edits.size() >>> 2);
        PutRequest putRequest = PutRequest.EMPTY_PUT;
        int n = 0;
        int n2 = -1;
        for (PutRequest putRequest2 : this.edits) {
            boolean bl;
            byte[] byArray = putRequest2.getRegion().name();
            boolean bl2 = bl = !Bytes.equals(putRequest.getRegion().name(), byArray);
            if (bl) {
                n = 0;
                Integer n3 = (Integer)byteMap.get(byArray);
                if (n3 == null) {
                    LoggerFactory.getLogger(MultiPutRequest.class).error("WTF?  Partial failures for " + this + " = " + byteMap + ", no results for region=" + Bytes.pretty(byArray));
                    putRequest = PutRequest.EMPTY_PUT;
                    continue;
                }
                n2 = n3;
            } else {
                ++n;
            }
            if (n < n2) {
                putRequest2.callback(null);
            } else {
                arrayList.add(putRequest2);
            }
            putRequest = putRequest2;
        }
        if (arrayList.isEmpty()) {
            throw new AssertionError((Object)("Impossible, we attempted to retry a partially applied multiPut but we didn't find anything to retry.  Original RPC = " + this + ", failures = " + byteMap + ", edits to retry = " + arrayList));
        }
        return arrayList;
    }

    private int predictSerializedSize() {
        int n = 0;
        n += 4;
        ++n;
        ++n;
        n += 4;
        PutRequest putRequest = PutRequest.EMPTY_PUT;
        for (PutRequest putRequest2 : this.edits) {
            boolean bl;
            byte[] byArray = putRequest2.getRegion().name();
            boolean bl2 = !Bytes.equals(putRequest.getRegion().name(), byArray);
            boolean bl3 = bl2 || !Bytes.equals(putRequest.key, putRequest2.key);
            boolean bl4 = bl = bl3 || !Bytes.equals(putRequest.family(), putRequest2.family());
            if (bl2) {
                n += 3;
                n += byArray.length;
                n += 4;
            }
            int n2 = putRequest2.key.length;
            int n3 = putRequest2.family().length;
            if (bl3) {
                ++n;
                n += 3;
                n += n2;
                n += 8;
                n += 8;
                ++n;
                n += 4;
            }
            if (bl) {
                ++n;
                n += n3;
                n += 4;
                n += 4;
            }
            n += putRequest2.kv().predictSerializedSize();
            putRequest = putRequest2;
        }
        return n;
    }

    @Override
    ChannelBuffer serialize(byte by) {
        Collections.sort(this.edits, MULTIPUT_CMP);
        ChannelBuffer channelBuffer = this.newBuffer(this.predictSerializedSize());
        channelBuffer.writeInt(1);
        channelBuffer.writeByte(57);
        channelBuffer.writeByte(57);
        channelBuffer.writeInt(0);
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        int n4 = -1;
        int n5 = 0;
        int n6 = -1;
        int n7 = 0;
        int n8 = 0;
        PutRequest putRequest = PutRequest.EMPTY_PUT;
        for (PutRequest putRequest2 : this.edits) {
            boolean bl;
            byte[] byArray = putRequest2.getRegion().name();
            boolean bl2 = !Bytes.equals(putRequest.getRegion().name(), byArray);
            boolean bl3 = bl2 || !Bytes.equals(putRequest.key, putRequest2.key);
            boolean bl4 = bl = bl3 || !Bytes.equals(putRequest.family(), putRequest2.family());
            if (bl2) {
                if (n2 > 0) {
                    channelBuffer.setInt(n2, n3);
                    n3 = 0;
                }
                ++n;
                MultiPutRequest.writeByteArray(channelBuffer, byArray);
                n2 = channelBuffer.writerIndex();
                channelBuffer.writeInt(0);
            }
            byte[] byArray2 = putRequest2.key;
            if (bl3) {
                ++n3;
                if (n4 > 0) {
                    channelBuffer.setInt(n4, n5);
                    n5 = 0;
                }
                channelBuffer.writeByte(1);
                MultiPutRequest.writeByteArray(channelBuffer, byArray2);
                channelBuffer.writeLong(Long.MAX_VALUE);
                channelBuffer.writeLong(-1L);
                channelBuffer.writeByte(putRequest2.durable() ? 1 : 0);
                n4 = channelBuffer.writerIndex();
                channelBuffer.writeInt(0);
            }
            byte[] byArray3 = putRequest2.family();
            if (bl) {
                ++n5;
                MultiPutRequest.writeByteArray(channelBuffer, byArray3);
                if (n6 > 0) {
                    channelBuffer.setInt(n6, n7);
                    n7 = 0;
                    channelBuffer.setInt(n6 + 4, n8);
                    n8 = 0;
                }
                n6 = channelBuffer.writerIndex();
                channelBuffer.writeInt(0);
                channelBuffer.writeInt(0);
            }
            ++n7;
            KeyValue keyValue = putRequest2.kv();
            n8 += keyValue.predictSerializedSize();
            keyValue.serialize(channelBuffer, (byte)4);
            putRequest = putRequest2;
        }
        channelBuffer.setInt(n6, n7);
        channelBuffer.setInt(n6 + 4, n8);
        channelBuffer.setInt(n4, n5);
        channelBuffer.setInt(n2, n3);
        channelBuffer.setInt(10 + MULTI_PUT.length + 4 + 1 + 1, n);
        return channelBuffer;
    }

    @Override
    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MultiPutRequest(edits=[");
        int n2 = this.edits.size();
        for (n = 0; n < n2 && stringBuilder.length() < 1024; ++n) {
            stringBuilder.append(this.edits.get(n)).append(", ");
        }
        if (n < n2) {
            if (n == n2 - 1) {
                stringBuilder.append("... 1 edit not shown])");
            } else {
                stringBuilder.append("... ").append(n2 - 1 - n).append(" edits not shown ..., ").append(this.edits.get(n2 - 1)).append("])");
            }
        } else {
            stringBuilder.setLength(stringBuilder.length() - 2);
            stringBuilder.append("])");
        }
        return stringBuilder.toString();
    }

    private static final class MultiPutComparator
    implements Comparator<PutRequest> {
        private MultiPutComparator() {
        }

        @Override
        public int compare(PutRequest putRequest, PutRequest putRequest2) {
            int n = Bytes.memcmp(putRequest.getRegion().name(), putRequest2.getRegion().name());
            if (n != 0) {
                return n;
            }
            n = Bytes.memcmp(putRequest.key, putRequest2.key);
            if (n != 0) {
                return n;
            }
            return Bytes.memcmp(putRequest.family(), putRequest2.family());
        }
    }
}

