/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import org.hbase.async.Bytes;
import org.hbase.async.HBaseRpc;
import org.hbase.async.KeyValue;
import org.hbase.async.RegionInfo;
import org.hbase.async.RowLock;
import org.jboss.netty.buffer.ChannelBuffer;

public final class PutRequest
extends HBaseRpc
implements HBaseRpc.HasTable,
HBaseRpc.HasKey,
HBaseRpc.HasFamily,
HBaseRpc.HasQualifier,
HBaseRpc.HasValue {
    private static final byte[] PUT = new byte[]{112, 117, 116};
    static final PutRequest EMPTY_PUT;
    private final KeyValue kv;
    private final long lockid;
    private boolean durable = true;
    private boolean bufferable = true;

    public PutRequest(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        this(byArray, byArray2, byArray3, byArray4, byArray5, -1L);
    }

    public PutRequest(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, RowLock rowLock) {
        this(byArray, byArray2, byArray3, byArray4, byArray5, rowLock.id());
    }

    public PutRequest(String string, String string2, String string3, String string4, String string5) {
        this(string.getBytes(), string2.getBytes(), string3.getBytes(), string4.getBytes(), string5.getBytes(), -1L);
    }

    public PutRequest(String string, String string2, String string3, String string4, String string5, RowLock rowLock) {
        this(string.getBytes(), string2.getBytes(), string3.getBytes(), string4.getBytes(), string5.getBytes(), rowLock.id());
    }

    public PutRequest(byte[] byArray, KeyValue keyValue) {
        this(byArray, keyValue, -1L);
    }

    public PutRequest(byte[] byArray, KeyValue keyValue, RowLock rowLock) {
        this(byArray, keyValue, rowLock.id());
    }

    private PutRequest(byte[] byArray, KeyValue keyValue, long l) {
        super(PUT, byArray, keyValue.key());
        this.kv = keyValue;
        this.lockid = l;
    }

    private PutRequest(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, long l) {
        super(PUT, byArray, byArray2);
        this.kv = new KeyValue(byArray2, byArray3, byArray4, byArray5);
        this.lockid = l;
    }

    public void setDurable(boolean bl) {
        this.durable = bl;
    }

    public void setBufferable(boolean bl) {
        this.bufferable = bl;
    }

    @Override
    public byte[] table() {
        return this.table;
    }

    @Override
    public byte[] key() {
        return this.key;
    }

    @Override
    public byte[] family() {
        return this.kv.family();
    }

    @Override
    public byte[] qualifier() {
        return this.kv.qualifier();
    }

    @Override
    public byte[] value() {
        return this.kv.value();
    }

    @Override
    public String toString() {
        return super.toStringWithQualifier("PutRequest", this.kv.family(), this.kv.qualifier(), ", value=" + Bytes.pretty(this.kv.value()) + ", lockid=" + this.lockid + ", durable=" + this.durable + ", bufferable=" + this.bufferable);
    }

    KeyValue kv() {
        return this.kv;
    }

    long lockid() {
        return this.lockid;
    }

    boolean durable() {
        return this.durable;
    }

    boolean canBuffer() {
        return this.lockid == -1L && this.bufferable;
    }

    private int predictSerializedSize() {
        int n = 0;
        n += 4;
        ++n;
        n += 3;
        n += this.region.name().length;
        ++n;
        ++n;
        ++n;
        n += 3;
        n += this.kv.key().length;
        n += 8;
        n += 8;
        ++n;
        n += 4;
        ++n;
        n += this.kv.family().length;
        n += 4;
        n += 4;
        return n += this.kv.predictSerializedSize();
    }

    @Override
    ChannelBuffer serialize(byte by) {
        ChannelBuffer channelBuffer = this.newBuffer(this.predictSerializedSize());
        channelBuffer.writeInt(2);
        PutRequest.writeHBaseByteArray(channelBuffer, this.region.name());
        channelBuffer.writeByte(35);
        channelBuffer.writeByte(35);
        channelBuffer.writeByte(1);
        PutRequest.writeByteArray(channelBuffer, this.key);
        channelBuffer.writeLong(Long.MAX_VALUE);
        channelBuffer.writeLong(this.lockid);
        channelBuffer.writeByte(this.durable ? 1 : 0);
        channelBuffer.writeInt(1);
        PutRequest.writeByteArray(channelBuffer, this.kv.family());
        channelBuffer.writeInt(1);
        channelBuffer.writeInt(this.kv.predictSerializedSize());
        this.kv.serialize(channelBuffer, (byte)4);
        return channelBuffer;
    }

    static {
        byte[] byArray = new byte[]{0};
        EMPTY_PUT = new PutRequest(byArray, byArray, byArray, byArray, byArray);
        EMPTY_PUT.setRegion(new RegionInfo(byArray, byArray, byArray));
    }
}

