/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.hbase.async.Bytes;
import org.hbase.async.ConnectionResetException;
import org.hbase.async.HBaseClient;
import org.hbase.async.HBaseException;
import org.hbase.async.HBaseRpc;
import org.hbase.async.InvalidResponseException;
import org.hbase.async.KeyValue;
import org.hbase.async.MultiPutRequest;
import org.hbase.async.MultiPutResponse;
import org.hbase.async.NoSuchColumnFamilyException;
import org.hbase.async.NonRecoverableException;
import org.hbase.async.NotServingRegionException;
import org.hbase.async.PutRequest;
import org.hbase.async.RecoverableException;
import org.hbase.async.RegionInfo;
import org.hbase.async.RemoteException;
import org.hbase.async.UnknownRowLockException;
import org.hbase.async.UnknownScannerException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.DownstreamMessageEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.jboss.netty.handler.codec.replay.VoidEnum;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RegionClient
extends ReplayingDecoder<VoidEnum> {
    private static final Logger LOG = LoggerFactory.getLogger(RegionClient.class);
    private static final HashMap<String, HBaseException> REMOTE_EXCEPTION_TYPES = new HashMap();
    private final HBaseClient hbase_client;
    private volatile Channel chan;
    private boolean dead = false;
    private byte server_version = (byte)-1;
    private volatile Deferred<Long> deferred_server_version;
    private MultiPutRequest edit_buffer;
    private ArrayList<HBaseRpc> pending_rpcs;
    private final ConcurrentHashMap<Integer, HBaseRpc> rpcs_inflight = new ConcurrentHashMap();
    private final AtomicInteger rpcid = new AtomicInteger(-1);
    private final TimerTask flush_timer = new TimerTask(){

        public void run(Timeout timeout) {
            RegionClient.this.periodicFlush();
        }

        public String toString() {
            return "flush commits of " + (Object)((Object)RegionClient.this);
        }
    };
    private final Semaphore meta_lookups = new Semaphore(100);
    private static final byte[] GET_PROTOCOL_VERSION;
    private final Callback<Long, Object> got_protocol_version = new Callback<Long, Object>(){

        public Long call(Object object) {
            if (!(object instanceof Long)) {
                throw new InvalidResponseException(Long.class, object);
            }
            Long l = (Long)object;
            long l2 = l;
            if (l2 < 0L || l2 > 127L) {
                throw new InvalidResponseException("getProtocolVersion returned a " + (l2 < 0L ? "negative" : "too large") + " value", (Object)l);
            }
            byte by = RegionClient.this.server_version;
            RegionClient.this.server_version = (byte)l2;
            RegionClient.this.deferred_server_version = null;
            if (by == -1) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(RegionClient.this.chan + " uses RPC protocol version " + RegionClient.this.server_version);
                }
            } else if (by != RegionClient.this.server_version) {
                LOG.error("WTF?  We previously found that " + RegionClient.this.chan + " uses RPC" + " protocol version " + by + " but now the " + " server claims to be using version " + RegionClient.this.server_version);
            }
            return (Long)object;
        }

        public String toString() {
            return "type getProtocolVersion response";
        }
    };
    private static final byte[] GET_CLOSEST_ROW_BEFORE;
    private static final Callback<ArrayList<KeyValue>, Object> got_closest_row_before;

    public RegionClient(HBaseClient hBaseClient) {
        this.hbase_client = hBaseClient;
    }

    public boolean isAlive() {
        return !this.dead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void periodicFlush() {
        if (this.chan != null || this.dead) {
            MultiPutRequest multiPutRequest;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Periodic flush timer: flushing edits for " + this);
            }
            Deferred<Object> deferred = this;
            synchronized (deferred) {
                multiPutRequest = this.edit_buffer;
                this.edit_buffer = null;
            }
            if (multiPutRequest != null && multiPutRequest.size() != 0) {
                deferred = multiPutRequest.getDeferred();
                this.sendRpc((HBaseRpc)multiPutRequest);
            }
        }
    }

    private void scheduleNextPeriodicFlush() {
        short s = this.hbase_client.getFlushInterval();
        if (s > 0) {
            short s2 = (short)(System.nanoTime() & 0xF0L);
            if (s < 3 * s2) {
                s2 = (short)(s2 >>> 2);
            }
            if ((s2 & 0x10) == 16) {
                s2 = -s2;
            }
            this.hbase_client.timer.newTimeout(this.flush_timer, (long)(s + s2), TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deferred<Object> flush() {
        MultiPutRequest multiPutRequest;
        Deferred<Object> deferred = this;
        synchronized (deferred) {
            multiPutRequest = this.edit_buffer;
            this.edit_buffer = null;
        }
        if (multiPutRequest == null || multiPutRequest.size() == 0) {
            return Deferred.fromResult(null);
        }
        deferred = multiPutRequest.getDeferred();
        this.sendRpc((HBaseRpc)multiPutRequest);
        return deferred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deferred<Object> shutdown() {
        final class RetryShutdown<T>
        implements Callback<Deferred<Object>, T> {
            private final int nrpcs;

            RetryShutdown(int n) {
                this.nrpcs = n;
            }

            public Deferred<Object> call(T t) {
                return RegionClient.this.shutdown();
            }

            public String toString() {
                return "wait until " + this.nrpcs + " RPCs complete";
            }
        }
        MultiPutRequest multiPutRequest;
        Channel channel = new ArrayList<Deferred<Object>>();
        for (HBaseRpc object2 : this.rpcs_inflight.values()) {
            channel.add(object2.getDeferred());
        }
        int n = channel.size();
        if (n > 0) {
            return Deferred.group(channel).addCallbackDeferring(new RetryShutdown(n));
        }
        RegionClient regionClient = this;
        synchronized (regionClient) {
            multiPutRequest = this.edit_buffer;
            this.edit_buffer = null;
        }
        if (multiPutRequest != null && multiPutRequest.size() != 0) {
            Deferred<Object> deferred = multiPutRequest.getDeferred();
            this.sendRpc(multiPutRequest);
            return deferred.addCallbackDeferring(new RetryShutdown(1));
        }
        channel = this;
        synchronized (channel) {
            if (this.pending_rpcs != null && !this.pending_rpcs.isEmpty()) {
                ArrayList<Deferred<Object>> arrayList = new ArrayList<Deferred<Object>>(this.pending_rpcs.size());
                for (HBaseRpc hBaseRpc : this.pending_rpcs) {
                    arrayList.add(hBaseRpc.getDeferred());
                }
                return Deferred.group(arrayList).addCallbackDeferring(new RetryShutdown(arrayList.size()));
            }
        }
        channel = this.chan;
        if (channel == null) {
            return Deferred.fromResult(null);
        }
        LOG.debug("Shutdown requested, chan={}", (Object)channel);
        if (channel.isConnected()) {
            Channels.disconnect((Channel)channel);
        }
        if (channel.isBound()) {
            Channels.unbind((Channel)channel);
        }
        ChannelFuture channelFuture = Channels.close((Channel)channel);
        final Deferred deferred = new Deferred();
        if (channelFuture.isSuccess()) {
            deferred.callback(null);
        } else {
            channelFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) {
                    if (channelFuture.isSuccess()) {
                        deferred.callback(null);
                        return;
                    }
                    Throwable throwable = channelFuture.getCause();
                    if (throwable instanceof Exception) {
                        deferred.callback((Object)throwable);
                    } else {
                        deferred.callback((Object)new NonRecoverableException("Failed to shutdown: " + (Object)((Object)RegionClient.this), throwable));
                    }
                }
            });
        }
        return deferred;
    }

    private GetProtocolVersionRequest getProtocolVersionRequest() {
        GetProtocolVersionRequest getProtocolVersionRequest = new GetProtocolVersionRequest();
        Deferred<Object> deferred = getProtocolVersionRequest.getDeferred();
        this.deferred_server_version = deferred;
        deferred.addCallback(this.got_protocol_version);
        return getProtocolVersionRequest;
    }

    public Deferred<Long> getProtocolVersion() {
        Deferred<Long> deferred = this.deferred_server_version;
        if (this.server_version != -1) {
            return Deferred.fromResult((Object)this.server_version);
        }
        if (deferred != null) {
            return deferred;
        }
        GetProtocolVersionRequest getProtocolVersionRequest = this.getProtocolVersionRequest();
        this.sendRpc(getProtocolVersionRequest);
        return getProtocolVersionRequest.getDeferred();
    }

    boolean acquireMetaLookupPermit() {
        try {
            return this.meta_lookups.tryAcquire(5L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    void releaseMetaLookupPermit() {
        this.meta_lookups.release();
    }

    public Deferred<ArrayList<KeyValue>> getClosestRowBefore(RegionInfo regionInfo, final byte[] byArray, final byte[] byArray2, final byte[] byArray3) {
        final class GetClosestRowBefore
        extends HBaseRpc {
            GetClosestRowBefore() {
                super(GET_CLOSEST_ROW_BEFORE, byArray4, byArray22);
            }

            @Override
            ChannelBuffer serialize(byte by) {
                byte[] byArray4 = this.region.name();
                ChannelBuffer channelBuffer = this.newBuffer(7 + byArray4.length + 1 + 4 + byArray2.length + 1 + 1 + byArray3.length);
                channelBuffer.writeInt(3);
                GetClosestRowBefore.writeHBaseByteArray(channelBuffer, byArray4);
                GetClosestRowBefore.writeHBaseByteArray(channelBuffer, byArray2);
                GetClosestRowBefore.writeHBaseByteArray(channelBuffer, byArray3);
                return channelBuffer;
            }
        }
        GetClosestRowBefore getClosestRowBefore = new GetClosestRowBefore();
        getClosestRowBefore.setRegion(regionInfo);
        Deferred deferred = getClosestRowBefore.getDeferred().addCallback(got_closest_row_before);
        this.sendRpc(getClosestRowBefore);
        return deferred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bufferEdit(PutRequest putRequest) {
        MultiPutRequest multiPutRequest;
        boolean bl = false;
        RegionClient regionClient = this;
        synchronized (regionClient) {
            if (this.edit_buffer == null) {
                this.edit_buffer = new MultiPutRequest();
                this.addMultiPutCallbacks(this.edit_buffer);
                bl = true;
            }
            multiPutRequest = this.edit_buffer;
            multiPutRequest.add(putRequest);
            if (multiPutRequest.size() < 1024) {
                multiPutRequest = null;
            } else {
                this.edit_buffer = new MultiPutRequest();
                this.addMultiPutCallbacks(this.edit_buffer);
            }
        }
        if (bl) {
            this.scheduleNextPeriodicFlush();
        } else if (multiPutRequest != null) {
            this.sendRpc(multiPutRequest);
        }
    }

    private void addMultiPutCallbacks(final MultiPutRequest multiPutRequest) {
        final class MultiPutCallback
        implements Callback<Object, Object> {
            MultiPutCallback() {
            }

            public Object call(Object object) {
                if (!(object instanceof MultiPutResponse)) {
                    if (object instanceof PutRequest) {
                        return null;
                    }
                    throw new InvalidResponseException(MultiPutResponse.class, object);
                }
                MultiPutResponse multiPutResponse = (MultiPutResponse)object;
                Bytes.ByteMap<Integer> byteMap = multiPutResponse.failures();
                if (byteMap.isEmpty()) {
                    for (PutRequest putRequest : multiPutRequest.edits()) {
                        putRequest.callback(null);
                    }
                    return null;
                }
                LOG.warn("Some edits failed for " + byteMap + ", hopefully it's just due to a region split.");
                for (PutRequest putRequest : multiPutRequest.handlePartialFailure(byteMap)) {
                    RegionClient.this.retryEdit(putRequest, null);
                }
                return null;
            }

            public String toString() {
                return "multiPut response";
            }
        }
        final class MultiPutErrback
        implements Callback<Object, Exception> {
            MultiPutErrback() {
            }

            public Object call(Exception exception) {
                if (!(exception instanceof RecoverableException)) {
                    for (PutRequest putRequest : multiPutRequest.edits()) {
                        putRequest.callback(exception);
                    }
                    return exception;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Multi-put request failed, retrying each of the " + multiPutRequest.size() + " edits individually.", (Throwable)exception);
                }
                for (PutRequest putRequest : multiPutRequest.edits()) {
                    RegionClient.this.retryEdit(putRequest, (RecoverableException)exception);
                }
                return null;
            }

            public String toString() {
                return "multiPut errback";
            }
        }
        multiPutRequest.getDeferred().addCallbacks((Callback)new MultiPutCallback(), (Callback)new MultiPutErrback());
    }

    private Deferred<Object> retryEdit(PutRequest putRequest, RecoverableException recoverableException) {
        if (HBaseClient.cannotRetryRequest(putRequest)) {
            return HBaseClient.tooManyAttempts(putRequest, recoverableException);
        }
        putRequest.setBufferable(false);
        return this.hbase_client.sendRpcToRegion(putRequest);
    }

    private void addSingleEditCallbacks(final PutRequest putRequest) {
        final class PutErrback
        implements Callback<Object, Exception> {
            PutErrback() {
            }

            public Object call(Exception exception) {
                if (!(exception instanceof RecoverableException)) {
                    return exception;
                }
                return RegionClient.this.retryEdit(putRequest, (RecoverableException)exception);
            }

            public String toString() {
                return "put errback";
            }
        }
        putRequest.getDeferred().addErrback((Callback)new PutErrback());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendRpc(HBaseRpc hBaseRpc) {
        boolean bl;
        if (this.chan != null) {
            HBaseRpc hBaseRpc2;
            if (hBaseRpc instanceof PutRequest) {
                hBaseRpc2 = (PutRequest)hBaseRpc;
                if (((PutRequest)hBaseRpc2).canBuffer() && this.hbase_client.getFlushInterval() > 0) {
                    this.bufferEdit((PutRequest)hBaseRpc2);
                    return;
                }
                this.addSingleEditCallbacks((PutRequest)hBaseRpc2);
            } else if (hBaseRpc instanceof MultiPutRequest && ((MultiPutRequest)(hBaseRpc2 = (MultiPutRequest)hBaseRpc)).size() == 1) {
                hBaseRpc = this.multiPutToSinglePut((MultiPutRequest)hBaseRpc2);
            }
            hBaseRpc2 = this.encode(hBaseRpc);
            if (hBaseRpc2 == null) {
                return;
            }
            Channel channel = this.chan;
            if (channel != null) {
                Channels.write((Channel)channel, (Object)hBaseRpc2);
                return;
            }
        }
        boolean bl2 = false;
        RegionClient regionClient = this;
        synchronized (regionClient) {
            bl = this.dead;
            if (this.chan != null) {
                bl2 = true;
            } else if (!bl) {
                if (this.pending_rpcs == null) {
                    this.pending_rpcs = new ArrayList();
                }
                this.pending_rpcs.add(hBaseRpc);
            }
        }
        if (bl) {
            if (hBaseRpc.getRegion() == null) {
                hBaseRpc.callback(new ConnectionResetException(null));
            } else {
                this.hbase_client.sendRpcToRegion(hBaseRpc);
            }
            return;
        }
        if (bl2) {
            this.sendRpc(hBaseRpc);
            return;
        }
        LOG.debug("RPC queued: {}", (Object)hBaseRpc);
    }

    private PutRequest multiPutToSinglePut(final MultiPutRequest multiPutRequest) {
        final PutRequest putRequest = multiPutRequest.edits().get(0);
        this.addSingleEditCallbacks(putRequest);
        final class Multi2SingleCB
        implements Callback<Object, Object> {
            Multi2SingleCB() {
            }

            public Object call(Object object) {
                multiPutRequest.callback(object instanceof Exception ? object : putRequest);
                return object;
            }
        }
        putRequest.getDeferred().addBoth((Callback)new Multi2SingleCB());
        return putRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelConnected(ChannelHandlerContext channelHandlerContext, ChannelStateEvent channelStateEvent) {
        ArrayList<HBaseRpc> arrayList;
        this.chan = channelStateEvent.getChannel();
        RegionClient regionClient = this;
        synchronized (regionClient) {
            arrayList = this.pending_rpcs;
            this.pending_rpcs = null;
        }
        if (arrayList != null) {
            for (HBaseRpc hBaseRpc : arrayList) {
                if (this.chan == null) continue;
                LOG.debug("Executing RPC queued: {}", (Object)hBaseRpc);
                ChannelBuffer channelBuffer = this.encode(hBaseRpc);
                if (channelBuffer == null) continue;
                Channels.write((Channel)this.chan, (Object)channelBuffer);
            }
        }
    }

    public void channelDisconnected(ChannelHandlerContext channelHandlerContext, ChannelStateEvent channelStateEvent) throws Exception {
        this.chan = null;
        super.channelDisconnected(channelHandlerContext, channelStateEvent);
        this.cleanup(channelStateEvent.getChannel());
    }

    public void channelClosed(ChannelHandlerContext channelHandlerContext, ChannelStateEvent channelStateEvent) {
        this.chan = null;
        this.cleanup(channelStateEvent.getChannel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(Channel channel) {
        MultiPutRequest multiPutRequest;
        ArrayList<HBaseRpc> arrayList;
        ConnectionResetException connectionResetException = new ConnectionResetException(channel);
        this.failOrRetryRpcs(this.rpcs_inflight.values(), connectionResetException);
        this.rpcs_inflight.clear();
        RegionClient regionClient = this;
        synchronized (regionClient) {
            this.dead = true;
            arrayList = this.pending_rpcs;
            this.pending_rpcs = null;
            multiPutRequest = this.edit_buffer;
            this.edit_buffer = null;
        }
        if (arrayList != null) {
            this.failOrRetryRpcs(arrayList, connectionResetException);
        }
        if (multiPutRequest != null) {
            multiPutRequest.callback(connectionResetException);
        }
    }

    private void failOrRetryRpcs(Collection<HBaseRpc> collection, ConnectionResetException connectionResetException) {
        for (HBaseRpc hBaseRpc : collection) {
            RegionInfo regionInfo = hBaseRpc.getRegion();
            if (regionInfo == null) {
                hBaseRpc.callback(connectionResetException);
                continue;
            }
            NotServingRegionException notServingRegionException = new NotServingRegionException("Connection reset: " + connectionResetException.getMessage(), hBaseRpc);
            this.hbase_client.handleNSRE(hBaseRpc, regionInfo.name(), notServingRegionException);
        }
    }

    public void handleUpstream(ChannelHandlerContext channelHandlerContext, ChannelEvent channelEvent) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug(channelEvent.toString());
        }
        super.handleUpstream(channelHandlerContext, channelEvent);
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, ExceptionEvent exceptionEvent) {
        Throwable throwable = exceptionEvent.getCause();
        Channel channel = exceptionEvent.getChannel();
        SocketAddress socketAddress = channel.getRemoteAddress();
        if (throwable instanceof RejectedExecutionException) {
            LOG.warn("RPC rejected by the executor, ignore this if we're shutting down", throwable);
        } else {
            LOG.error("Unexpected exception from downstream.", throwable);
        }
        Channels.close((Channel)channel);
    }

    private ChannelBuffer encode(HBaseRpc hBaseRpc) {
        Object object;
        ChannelBuffer channelBuffer;
        if (!hBaseRpc.hasDeferred()) {
            throw new AssertionError((Object)("Should never happen!  rpc=" + hBaseRpc));
        }
        if (hBaseRpc.versionSensitive() && this.server_version == -1) {
            this.getProtocolVersion().addBoth(new RetryRpc(hBaseRpc));
            return null;
        }
        int n = this.rpcid.incrementAndGet();
        try {
            channelBuffer = hBaseRpc.serialize(this.server_version);
            object = hBaseRpc.method();
            channelBuffer.setInt(0, channelBuffer.readableBytes() - 4);
            channelBuffer.setInt(4, n);
            channelBuffer.setShort(8, ((byte[])object).length);
            channelBuffer.setBytes(10, (byte[])object);
        }
        catch (Exception exception) {
            LOG.error("Uncaught exception while serializing RPC: " + hBaseRpc, (Throwable)exception);
            hBaseRpc.callback(exception);
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending RPC #" + n + ", payload=" + channelBuffer + ' ' + Bytes.pretty(channelBuffer));
        }
        if ((object = (Object)this.rpcs_inflight.put(n, hBaseRpc)) != null) {
            String string = "WTF?  There was already an RPC in flight with rpcid=" + n + ": " + object + ".  This happened when sending out: " + hBaseRpc;
            LOG.error(string);
            ((HBaseRpc)object).callback(new NonRecoverableException(string));
        }
        return channelBuffer;
    }

    protected Object decode(ChannelHandlerContext channelHandlerContext, Channel channel, ChannelBuffer channelBuffer, VoidEnum voidEnum) {
        int n = channelBuffer.readerIndex();
        long l = System.nanoTime();
        LOG.debug("------------------>> ENTERING DECODE >>------------------");
        int n2 = channelBuffer.readInt();
        Object object = this.deserialize(channelBuffer, n2);
        HBaseRpc hBaseRpc = this.rpcs_inflight.remove(n2);
        if (LOG.isDebugEnabled()) {
            LOG.debug("rpcid=" + n2 + ", response size=" + (channelBuffer.readerIndex() - n) + " bytes" + ", " + this.actualReadableBytes() + " readable bytes left" + ", rpc=" + hBaseRpc);
        }
        if (hBaseRpc == null) {
            String string = "Invalid rpcid: " + n2 + " found in " + channelBuffer + '=' + Bytes.pretty(channelBuffer);
            LOG.error(string);
            throw new NonRecoverableException(string);
        }
        if (object instanceof NotServingRegionException && hBaseRpc.getRegion() != null) {
            this.hbase_client.handleNSRE(hBaseRpc, hBaseRpc.getRegion().name(), (NotServingRegionException)object);
            return null;
        }
        try {
            hBaseRpc.callback(object);
        }
        catch (Exception exception) {
            LOG.error("Unexpected exception while handling RPC #" + n2 + ", rpc=" + hBaseRpc + ", buf=" + Bytes.pretty(channelBuffer), (Throwable)exception);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("------------------<< LEAVING  DECODE <<------------------ time elapsed: " + (System.nanoTime() - l) / 1000L + "us");
        }
        return null;
    }

    private Object deserialize(ChannelBuffer channelBuffer, int n) {
        if (channelBuffer.readByte() != 0) {
            String string = HBaseRpc.readHadoopString(channelBuffer);
            String string2 = HBaseRpc.readHadoopString(channelBuffer);
            HBaseException hBaseException = REMOTE_EXCEPTION_TYPES.get(string);
            if (hBaseException != null) {
                return hBaseException.make(string2, this.rpcs_inflight.get(n));
            }
            return new RemoteException(string, string2);
        }
        try {
            return RegionClient.deserializeObject(channelBuffer);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new InvalidResponseException(illegalArgumentException.getMessage(), (Object)illegalArgumentException);
        }
    }

    private static Object deserializeObject(ChannelBuffer channelBuffer) {
        switch (channelBuffer.readByte()) {
            case 1: {
                return channelBuffer.readByte() != 0;
            }
            case 6: {
                return channelBuffer.readLong();
            }
            case 14: {
                return RegionClient.deserializeObject(channelBuffer);
            }
            case 17: {
                channelBuffer.readByte();
                return null;
            }
            case 37: {
                channelBuffer.readByte();
                return RegionClient.parseResult(channelBuffer);
            }
            case 38: {
                return RegionClient.parseResults(channelBuffer);
            }
            case 58: {
                channelBuffer.readByte();
                return MultiPutResponse.fromBuffer(channelBuffer);
            }
        }
        throw new NonRecoverableException("Couldn't de-serialize " + Bytes.pretty(channelBuffer));
    }

    private static ArrayList<KeyValue> parseResult(ChannelBuffer channelBuffer) {
        int n;
        int n2 = channelBuffer.readInt();
        HBaseRpc.checkArrayLength(channelBuffer, n2);
        channelBuffer.markReaderIndex();
        channelBuffer.skipBytes(n2);
        channelBuffer.resetReaderIndex();
        int n3 = 0;
        for (int i = 0; i < n2; i += n + 4) {
            n = channelBuffer.readInt();
            HBaseRpc.checkArrayLength(channelBuffer, n);
            ++n3;
            channelBuffer.skipBytes(n);
        }
        channelBuffer.resetReaderIndex();
        ArrayList<KeyValue> arrayList = new ArrayList<KeyValue>(n3);
        KeyValue keyValue = null;
        for (int i = 0; i < n3; ++i) {
            int n4 = channelBuffer.readInt();
            int n5 = 2 + (keyValue = KeyValue.fromBuffer(channelBuffer, keyValue)).key().length + 1 + keyValue.family().length + keyValue.qualifier().length + 8 + 1;
            if (n5 + keyValue.value().length + 4 + 4 != n4) {
                RegionClient.badResponse("kv_length=" + n4 + " doesn't match key_length + value_length (" + n5 + " + " + keyValue.value().length + ") in " + channelBuffer + '=' + Bytes.pretty(channelBuffer));
            }
            arrayList.add(keyValue);
        }
        return arrayList;
    }

    private static ArrayList<ArrayList<KeyValue>> parseResults(ChannelBuffer channelBuffer) {
        int n;
        byte by = channelBuffer.readByte();
        if (by != 1) {
            LOG.warn("Received unsupported Result[] version: " + by);
        }
        if ((n = channelBuffer.readInt()) < 0) {
            RegionClient.badResponse("Negative number of results=" + n + " found in " + channelBuffer + '=' + Bytes.pretty(channelBuffer));
        } else if (n == 0) {
            return null;
        }
        int n2 = channelBuffer.readInt();
        HBaseRpc.checkNonEmptyArrayLength(channelBuffer, n2);
        channelBuffer.markReaderIndex();
        channelBuffer.skipBytes(n2);
        channelBuffer.resetReaderIndex();
        ArrayList<ArrayList<KeyValue>> arrayList = new ArrayList<ArrayList<KeyValue>>(n);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4 = channelBuffer.readInt();
            n3 += 4;
            if (n4 < 0) {
                RegionClient.badResponse("Negative number of KeyValues=" + n4 + " for Result[" + i + "] found in " + channelBuffer + '=' + Bytes.pretty(channelBuffer));
            } else if (n == 0) continue;
            ArrayList<KeyValue> arrayList2 = new ArrayList<KeyValue>(n4);
            KeyValue keyValue = null;
            for (int j = 0; j < n4; ++j) {
                int n5 = channelBuffer.readInt();
                HBaseRpc.checkNonEmptyArrayLength(channelBuffer, n5);
                keyValue = KeyValue.fromBuffer(channelBuffer, keyValue);
                arrayList2.add(keyValue);
                n3 += 4 + n5;
            }
            arrayList.add(arrayList2);
        }
        if (n2 != n3) {
            RegionClient.badResponse("Result[" + n + "] was supposed to be " + n2 + " bytes, but we only read " + n3 + " bytes from " + channelBuffer + '=' + Bytes.pretty(channelBuffer));
        }
        return arrayList;
    }

    private static void badResponse(String string) {
        LOG.error(string);
        throw new InvalidResponseException(string, (Object)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object decodeLast(ChannelHandlerContext channelHandlerContext, Channel channel, ChannelBuffer channelBuffer, VoidEnum voidEnum) {
        if (channelBuffer.readable()) {
            try {
                Object object = this.decode(channelHandlerContext, channel, channelBuffer, voidEnum);
                return object;
            }
            finally {
                if (channelBuffer.readable()) {
                    LOG.error("After decoding the last message on " + channel + ", there was still some undecoded bytes in the channel's" + " buffer (which are going to be lost): " + channelBuffer + '=' + Bytes.pretty(channelBuffer));
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int n;
        int n2;
        StringBuilder stringBuilder = new StringBuilder(141);
        stringBuilder.append("RegionClient@").append(((Object)((Object)this)).hashCode()).append("(chan=").append(this.chan).append(", #pending_rpcs=");
        RegionClient regionClient = this;
        synchronized (regionClient) {
            n2 = this.pending_rpcs == null ? 0 : this.pending_rpcs.size();
            n = this.edit_buffer == null ? 0 : this.edit_buffer.size();
        }
        stringBuilder.append(n2).append(", #edits=").append(n);
        stringBuilder.append(", #rpcs_inflight=").append(this.rpcs_inflight.size()).append(')');
        return stringBuilder.toString();
    }

    static {
        REMOTE_EXCEPTION_TYPES.put("org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException", new NoSuchColumnFamilyException(null, null));
        REMOTE_EXCEPTION_TYPES.put("org.apache.hadoop.hbase.NotServingRegionException", new NotServingRegionException(null, null));
        REMOTE_EXCEPTION_TYPES.put("org.apache.hadoop.hbase.UnknownScannerException", new UnknownScannerException(null, null));
        REMOTE_EXCEPTION_TYPES.put("org.apache.hadoop.hbase.UnknownRowLockException", new UnknownRowLockException(null, null));
        GET_PROTOCOL_VERSION = new byte[]{103, 101, 116, 80, 114, 111, 116, 111, 99, 111, 108, 86, 101, 114, 115, 105, 111, 110};
        GET_CLOSEST_ROW_BEFORE = new byte[]{103, 101, 116, 67, 108, 111, 115, 101, 115, 116, 82, 111, 119, 66, 101, 102, 111, 114, 101};
        got_closest_row_before = new Callback<ArrayList<KeyValue>, Object>(){

            public ArrayList<KeyValue> call(Object object) {
                if (object == null) {
                    return new ArrayList<KeyValue>(0);
                }
                if (object instanceof ArrayList) {
                    ArrayList arrayList = (ArrayList)object;
                    return arrayList;
                }
                throw new InvalidResponseException(ArrayList.class, object);
            }

            public String toString() {
                return "type getClosestRowBefore response";
            }
        };
    }

    @ChannelHandler.Sharable
    static final class SayHelloFirstRpc
    implements ChannelDownstreamHandler {
        public static final SayHelloFirstRpc INSTANCE = new SayHelloFirstRpc();
        private static final byte[] HELLO_HEADER;

        private static ChannelBuffer commonHeader() {
            ChannelBuffer channelBuffer = ChannelBuffers.wrappedBuffer((byte[])HELLO_HEADER);
            channelBuffer.clear();
            channelBuffer.writeBytes(new byte[]{104, 114, 112, 99, 3});
            return channelBuffer;
        }

        private static void normalHeader() {
            ChannelBuffer channelBuffer = SayHelloFirstRpc.commonHeader();
            channelBuffer.writerIndex(channelBuffer.writerIndex() + 4);
            String string = "org.apache.hadoop.io.Writable";
            channelBuffer.writeShort(string.length());
            channelBuffer.writeBytes(Bytes.ISO88591(string));
            string = "org.apache.hadoop.io.ObjectWritable$NullInstance";
            channelBuffer.writeShort(string.length());
            channelBuffer.writeBytes(Bytes.ISO88591(string));
            string = "org.apache.hadoop.security.UserGroupInformation";
            channelBuffer.writeShort(string.length());
            channelBuffer.writeBytes(Bytes.ISO88591(string));
            channelBuffer.setInt(5, channelBuffer.writerIndex() - 4 - 5);
        }

        private static void headerCDH3b3(byte[] byArray) {
            ChannelBuffer channelBuffer = SayHelloFirstRpc.commonHeader();
            channelBuffer.writeInt(4 + byArray.length);
            channelBuffer.writeInt(byArray.length);
            channelBuffer.writeBytes(byArray);
        }

        private SayHelloFirstRpc() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleDownstream(ChannelHandlerContext channelHandlerContext, ChannelEvent channelEvent) {
            if (channelEvent instanceof MessageEvent) {
                ChannelHandlerContext channelHandlerContext2 = channelHandlerContext;
                synchronized (channelHandlerContext2) {
                    ChannelPipeline channelPipeline = channelHandlerContext.getPipeline();
                    if (channelPipeline.get(SayHelloFirstRpc.class) == this) {
                        ChannelBuffer channelBuffer;
                        MessageEvent messageEvent = (MessageEvent)channelEvent;
                        ChannelBuffer channelBuffer2 = (ChannelBuffer)messageEvent.getMessage();
                        ChannelBuffer channelBuffer3 = ChannelBuffers.wrappedBuffer((byte[])HELLO_HEADER);
                        RegionClient regionClient = (RegionClient)channelPipeline.get(RegionClient.class);
                        if (!SayHelloFirstRpc.isVersionRequest(channelBuffer2)) {
                            ChannelBuffer channelBuffer4 = regionClient.encode(regionClient.getProtocolVersionRequest());
                            channelBuffer = ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{channelBuffer3, channelBuffer2, channelBuffer4});
                        } else {
                            channelBuffer = ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{channelBuffer3, channelBuffer2});
                        }
                        channelHandlerContext.sendDownstream((ChannelEvent)new DownstreamMessageEvent(channelHandlerContext.getChannel(), messageEvent.getFuture(), (Object)channelBuffer, messageEvent.getRemoteAddress()));
                        channelPipeline.remove((ChannelHandler)this);
                        return;
                    }
                }
            }
            channelHandlerContext.sendDownstream(channelEvent);
        }

        private static boolean isVersionRequest(ChannelBuffer channelBuffer) {
            int n = GET_PROTOCOL_VERSION.length;
            if (channelBuffer.readableBytes() < 10 + n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (channelBuffer.getByte(10 + i) == GET_PROTOCOL_VERSION[i]) continue;
                return false;
            }
            return true;
        }

        static {
            if (System.getProperty("org.hbase.async.cdh3b3") != null) {
                byte[] byArray = Bytes.UTF8(System.getProperty("user.name", "asynchbase"));
                HELLO_HEADER = new byte[13 + byArray.length];
                SayHelloFirstRpc.headerCDH3b3(byArray);
            } else {
                HELLO_HEADER = new byte[139];
                SayHelloFirstRpc.normalHeader();
            }
        }
    }

    final class RetryRpc<T>
    implements Callback<T, T> {
        private final HBaseRpc rpc;

        RetryRpc(HBaseRpc hBaseRpc) {
            this.rpc = hBaseRpc;
        }

        public T call(T t) {
            RegionClient.this.sendRpc(this.rpc);
            return t;
        }
    }

    static final class GetProtocolVersionRequest
    extends HBaseRpc {
        GetProtocolVersionRequest() {
            super(GET_PROTOCOL_VERSION);
        }

        @Override
        ChannelBuffer serialize(byte by) {
            ChannelBuffer channelBuffer = this.newBuffer(59);
            channelBuffer.writeInt(2);
            GetProtocolVersionRequest.writeHBaseString(channelBuffer, "org.apache.hadoop.hbase.ipc.HRegionInterface");
            GetProtocolVersionRequest.writeHBaseLong(channelBuffer, 24L);
            return channelBuffer;
        }
    }
}

