/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import java.util.Arrays;
import java.util.Comparator;
import org.hbase.async.BrokenMetaException;
import org.hbase.async.Bytes;
import org.hbase.async.HBaseClient;
import org.hbase.async.HBaseRpc;
import org.hbase.async.KeyValue;
import org.hbase.async.RegionOfflineException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RegionInfo
implements Comparable<RegionInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(RegionInfo.class);
    private final byte[] table;
    private final byte[] region_name;
    private final byte[] stop_key;
    static final RegionNameCmp REGION_NAME_CMP = new RegionNameCmp();

    public RegionInfo(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.table = byArray;
        this.region_name = byArray2;
        this.stop_key = byArray3.length == 0 ? HBaseClient.EMPTY_ARRAY : byArray3;
    }

    public byte[] table() {
        return this.table;
    }

    public byte[] name() {
        return this.region_name;
    }

    public byte[] stopKey() {
        return this.stop_key;
    }

    static RegionInfo fromKeyValue(KeyValue keyValue, byte[][] byArray) {
        byte[] byArray2;
        ChannelBuffer channelBuffer = ChannelBuffers.wrappedBuffer((byte[])keyValue.value());
        byte by = channelBuffer.readByte();
        if (by != 0) {
            LOG.warn("Unsupported region info version: " + by + " in .META.  entry: " + keyValue);
        }
        byte[] byArray3 = HBaseRpc.readByteArray(channelBuffer);
        boolean bl = channelBuffer.readByte() != 0;
        long l = channelBuffer.readLong();
        byte[] byArray4 = HBaseRpc.readByteArray(channelBuffer);
        try {
            byArray2 = RegionInfo.tableFromRegionName(byArray4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw BrokenMetaException.badKV(null, "an `info:regioninfo' cell has a " + illegalArgumentException.getMessage(), keyValue);
        }
        boolean bl2 = channelBuffer.readByte() != 0;
        byte[] byArray5 = HBaseRpc.readByteArray(channelBuffer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got " + Bytes.pretty(byArray2) + "'s region [" + Bytes.pretty(byArray5) + '-' + Bytes.pretty(byArray3) + ") offline=" + bl + ", region_id=" + l + ", region_name=" + Bytes.pretty(byArray4) + ", split=" + bl2);
        }
        if (bl && !bl2) {
            throw new RegionOfflineException(byArray4);
        }
        RegionInfo regionInfo = new RegionInfo(bl2 ? HBaseClient.EMPTY_ARRAY : byArray2, byArray4, byArray3);
        byArray[0] = byArray5;
        return regionInfo;
    }

    static byte[] tableFromRegionName(byte[] byArray) {
        int n;
        for (n = 1; n < byArray.length && byArray[n] != 44; ++n) {
        }
        if (n == byArray.length) {
            throw new IllegalArgumentException("Malformed region name, contains no comma: " + Bytes.pretty(byArray));
        }
        return Arrays.copyOf(byArray, n);
    }

    @Override
    public int compareTo(RegionInfo regionInfo) {
        return Bytes.memcmp(this.region_name, regionInfo.region_name);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RegionInfo)) {
            return false;
        }
        return this.compareTo((RegionInfo)object) == 0;
    }

    public int hashCode() {
        return Arrays.hashCode(this.table) ^ Arrays.hashCode(this.region_name) ^ Arrays.hashCode(this.stop_key);
    }

    int stringSizeHint() {
        return 48 + this.table.length + 2 + this.region_name.length * 2 + this.stop_key.length * 2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.stringSizeHint());
        this.toStringbuf(stringBuilder);
        return stringBuilder.toString();
    }

    void toStringbuf(StringBuilder stringBuilder) {
        stringBuilder.append("RegionInfo(table=");
        if (this.table == HBaseClient.EMPTY_ARRAY) {
            stringBuilder.append("<NSRE marker>");
        } else {
            Bytes.pretty(stringBuilder, this.table);
        }
        stringBuilder.append(", region_name=");
        Bytes.pretty(stringBuilder, this.region_name);
        stringBuilder.append(", stop_key=");
        Bytes.pretty(stringBuilder, this.stop_key);
        stringBuilder.append(')');
    }

    private static final class RegionNameCmp
    implements Comparator<byte[]> {
        private RegionNameCmp() {
        }

        @Override
        public int compare(byte[] byArray, byte[] byArray2) {
            int n;
            int n2;
            int n3;
            int n4 = Math.min(byArray.length, byArray2.length);
            if (byArray == byArray2) {
                return 0;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = byArray[n3];
                n = byArray2[n3];
                if (n2 != n) {
                    if (n2 == 44) {
                        return -1001;
                    }
                    if (n == 44) {
                        return 1001;
                    }
                    return (n2 & 0xFF) - (n & 0xFF);
                }
                if (n2 == 44) break;
            }
            n2 = RegionNameCmp.findCommaFromEnd(byArray, n3);
            n = RegionNameCmp.findCommaFromEnd(byArray2, n3);
            ++n3;
            if (n2 != n) {
                if (n2 == n3) {
                    return -1002;
                }
                if (n == n3) {
                    return 1002;
                }
            }
            do {
                if (byArray[n3] == byArray2[n3]) continue;
                if (n3 == n2) {
                    return -1003;
                }
                if (n3 == n) {
                    return 1003;
                }
                return (byArray[n3] & 0xFF) - (byArray2[n3] & 0xFF);
            } while (++n3 < n4);
            return byArray.length - byArray2.length;
        }

        private static int findCommaFromEnd(byte[] byArray, int n) {
            for (int i = byArray.length - 1; i > n; --i) {
                if (byArray[i] != 44) continue;
                return i;
            }
            throw new IllegalArgumentException("No comma found in " + Bytes.pretty(byArray) + " after offset " + n);
        }
    }
}

