/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import org.hbase.async.Bytes;
import org.hbase.async.HBaseClient;
import org.hbase.async.HBaseRpc;
import org.hbase.async.InvalidResponseException;
import org.hbase.async.KeyValue;
import org.hbase.async.NotServingRegionException;
import org.hbase.async.RegionInfo;
import org.hbase.async.UnknownScannerException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.util.CharsetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Scanner {
    private static final Logger LOG = LoggerFactory.getLogger(Scanner.class);
    public static final int DEFAULT_MAX_NUM_KVS = 4096;
    public static final int DEFAULT_MAX_NUM_ROWS = 128;
    private static final RegionInfo DONE = new RegionInfo(HBaseClient.EMPTY_ARRAY, HBaseClient.EMPTY_ARRAY, HBaseClient.EMPTY_ARRAY);
    private final HBaseClient client;
    private final byte[] table;
    private byte[] start_key = HBaseClient.EMPTY_ARRAY;
    private byte[] stop_key = HBaseClient.EMPTY_ARRAY;
    private byte[] family;
    private byte[] qualifier;
    private byte[] filter;
    private boolean populate_blockcache = true;
    private int max_num_rows = 128;
    private int max_num_kvs = 4096;
    private RegionInfo region;
    private long scanner_id;
    private GetNextRowsRequest get_next_rows_request;
    private static final byte[] ROWFILTER = Bytes.ISO88591("org.apache.hadoop.hbase.filter.RowFilter");
    private static final byte[] REGEXSTRINGCOMPARATOR = Bytes.ISO88591("org.apache.hadoop.hbase.filter.RegexStringComparator");
    private static final byte[] EQUAL = new byte[]{69, 81, 85, 65, 76};
    private final Callback<Object, Object> got_next_row = new Callback<Object, Object>(){

        public Object call(Object object) {
            if (object == null) {
                byte[] byArray = Scanner.this.region.stopKey();
                if (byArray == HBaseClient.EMPTY_ARRAY || Scanner.this.stop_key != HBaseClient.EMPTY_ARRAY && Bytes.memcmp(Scanner.this.stop_key, byArray) <= 0) {
                    Scanner.this.get_next_rows_request = null;
                    Scanner.access$502(Scanner.this, Scanner.access$602(Scanner.this, null));
                    Scanner.access$702(Scanner.this, Scanner.access$302(Scanner.this, HBaseClient.EMPTY_ARRAY));
                    return Scanner.this.close().addCallback((Callback)new Callback<ArrayList<ArrayList<KeyValue>>, Object>(){

                        public ArrayList<ArrayList<KeyValue>> call(Object object) {
                            return null;
                        }

                        public String toString() {
                            return "auto-close scanner " + Bytes.hex(Scanner.this.scanner_id);
                        }
                    });
                }
                return Scanner.this.continueScanOnNextRegion();
            }
            if (!(object instanceof ArrayList)) {
                throw new InvalidResponseException(ArrayList.class, object);
            }
            ArrayList arrayList = (ArrayList)object;
            ArrayList arrayList2 = (ArrayList)arrayList.get(arrayList.size() - 1);
            Scanner.access$702(Scanner.this, ((KeyValue)arrayList2.get(0)).key());
            return arrayList;
        }

        public String toString() {
            return "get nextRows response";
        }
    };
    private static final byte[] OPEN_SCANNER = new byte[]{111, 112, 101, 110, 83, 99, 97, 110, 110, 101, 114};
    private static final byte[] NEXT = new byte[]{110, 101, 120, 116};

    Scanner(HBaseClient hBaseClient, byte[] byArray) {
        KeyValue.checkTable(byArray);
        this.client = hBaseClient;
        this.table = byArray;
    }

    public byte[] getCurrentKey() {
        return this.start_key;
    }

    public void setStartKey(byte[] byArray) {
        KeyValue.checkKey(byArray);
        this.checkScanningNotStarted();
        this.start_key = byArray;
    }

    public void setStartKey(String string) {
        this.setStartKey(string.getBytes());
    }

    public void setStopKey(byte[] byArray) {
        KeyValue.checkKey(byArray);
        this.checkScanningNotStarted();
        this.stop_key = byArray;
    }

    public void setStopKey(String string) {
        this.setStopKey(string.getBytes());
    }

    public void setFamily(byte[] byArray) {
        KeyValue.checkFamily(byArray);
        this.checkScanningNotStarted();
        this.family = byArray;
    }

    public void setFamily(String string) {
        this.setFamily(string.getBytes());
    }

    public void setQualifier(byte[] byArray) {
        KeyValue.checkQualifier(byArray);
        this.checkScanningNotStarted();
        this.qualifier = byArray;
    }

    public void setQualifier(String string) {
        this.setQualifier(string.getBytes());
    }

    public void setKeyRegexp(String string) {
        this.setKeyRegexp(string, CharsetUtil.ISO_8859_1);
    }

    public void setKeyRegexp(String string, Charset charset) {
        byte[] byArray = Bytes.UTF8(string);
        byte[] byArray2 = Bytes.UTF8(charset.name());
        this.filter = new byte[105 + byArray.length + 2 + byArray2.length];
        ChannelBuffer channelBuffer = ChannelBuffers.wrappedBuffer((byte[])this.filter);
        channelBuffer.clear();
        channelBuffer.writeByte((int)((byte)ROWFILTER.length));
        channelBuffer.writeBytes(ROWFILTER);
        channelBuffer.writeShort(5);
        channelBuffer.writeBytes(EQUAL);
        channelBuffer.writeByte(53);
        channelBuffer.writeByte(0);
        channelBuffer.writeByte((int)((byte)REGEXSTRINGCOMPARATOR.length));
        channelBuffer.writeBytes(REGEXSTRINGCOMPARATOR);
        channelBuffer.writeShort(byArray.length);
        channelBuffer.writeBytes(byArray);
        channelBuffer.writeShort(byArray2.length);
        channelBuffer.writeBytes(byArray2);
    }

    public void setServerBlockCache(boolean bl) {
        this.checkScanningNotStarted();
        this.populate_blockcache = bl;
    }

    public void setMaxNumRows(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("zero or negative argument: " + n);
        }
        this.max_num_rows = n;
    }

    public void setMaxNumKeyValues(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("batch size can't be zero");
        }
        this.checkScanningNotStarted();
        this.max_num_kvs = n;
    }

    public Deferred<ArrayList<ArrayList<KeyValue>>> nextRows(int n) {
        this.setMaxNumRows(n);
        return this.nextRows();
    }

    public Deferred<ArrayList<ArrayList<KeyValue>>> nextRows() {
        if (this.region == DONE) {
            return Deferred.fromResult(null);
        }
        if (this.region == null) {
            return this.client.openScanner(this).addCallbackDeferring((Callback)new Callback<Deferred<ArrayList<ArrayList<KeyValue>>>, Long>(){

                public Deferred<ArrayList<ArrayList<KeyValue>>> call(Long l) {
                    Scanner.this.scanner_id = l;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Scanner " + Bytes.hex(l) + " opened on " + Scanner.this.region);
                    }
                    return Scanner.this.nextRows();
                }

                public String toString() {
                    return "scanner opened";
                }
            });
        }
        Deferred deferred = this.client.scanNextRows(this).addCallbacks(this.got_next_row, this.nextRowErrback());
        return deferred;
    }

    private final Callback<Object, Object> nextRowErrback() {
        return new Callback<Object, Object>(){

            public Object call(Object object) {
                RegionInfo regionInfo = Scanner.this.region;
                Scanner.this.invalidate();
                if (object instanceof NotServingRegionException) {
                    Scanner.access$702(Scanner.this, Arrays.copyOf(Scanner.this.start_key, Scanner.this.start_key.length + 1));
                    return Scanner.this.nextRows();
                }
                if (object instanceof UnknownScannerException) {
                    Scanner scanner = Scanner.this;
                    LOG.warn(regionInfo + " pretends to not know " + scanner + ".  I will" + " retry to open a scanner but this is typically because you've" + " been holding the scanner open and idle for too long (possibly" + " due to a long GC pause on your side or in the RegionServer)", object);
                    return Scanner.this.nextRows();
                }
                return object;
            }

            public String toString() {
                return "NextRow errback";
            }
        };
    }

    public Deferred<Object> close() {
        if (this.region == null || this.region == DONE) {
            return Deferred.fromResult(null);
        }
        return this.client.closeScanner(this).addBoth(this.closedCallback());
    }

    private Callback<Object, Object> closedCallback() {
        return new Callback<Object, Object>(){

            public Object call(Object object) {
                if (object instanceof Exception) {
                    Exception exception = (Exception)object;
                    if (exception instanceof NotServingRegionException || exception instanceof UnknownScannerException) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Ignoring exception when closing " + Scanner.this, (Throwable)exception);
                        }
                        object = null;
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Scanner " + Bytes.hex(Scanner.this.scanner_id) + " closed on " + Scanner.this.region);
                }
                Scanner.this.region = DONE;
                Scanner.this.scanner_id = -2401262971557716307L;
                return object;
            }

            public String toString() {
                return "scanner closed";
            }
        };
    }

    private Deferred<ArrayList<ArrayList<KeyValue>>> continueScanOnNextRegion() {
        final long l = this.scanner_id;
        final RegionInfo regionInfo = this.region;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scanner " + Bytes.hex(l) + " done scanning " + regionInfo);
        }
        this.client.closeScanner(this).addCallback((Callback)new Callback<Object, Object>(){

            public Object call(Object object) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scanner " + Bytes.hex(l) + " closed on " + regionInfo);
                }
                return object;
            }

            public String toString() {
                return "scanner moved";
            }
        });
        this.start_key = this.region.stopKey();
        this.scanner_id = -2401262980684521811L;
        this.invalidate();
        return this.nextRows();
    }

    public String toString() {
        String string = this.region == null ? "null" : (this.region == DONE ? "none" : this.region.toString());
        StringBuilder stringBuilder = new StringBuilder(15 + this.table.length + 1 + 12 + 1 + this.start_key.length + 1 + 1 + this.stop_key.length + 1 + 9 + 1 + (this.family == null ? 4 : this.family.length) + 1 + 12 + 1 + (this.qualifier == null ? 4 : this.qualifier.length) + 1 + 22 + 5 + 15 + 5 + 14 + 6 + 14 + 1 + string.length() + 1 + 13 + 18 + 1);
        stringBuilder.append("Scanner(table=");
        Bytes.pretty(stringBuilder, this.table);
        stringBuilder.append(", start_key=");
        Bytes.pretty(stringBuilder, this.start_key);
        stringBuilder.append(", stop_key=");
        Bytes.pretty(stringBuilder, this.stop_key);
        stringBuilder.append(", family=");
        Bytes.pretty(stringBuilder, this.family);
        stringBuilder.append(", qualifier=");
        Bytes.pretty(stringBuilder, this.qualifier);
        stringBuilder.append(", populate_blockcache=").append(this.populate_blockcache).append(", max_num_rows=").append(this.max_num_rows).append(", max_num_kvs=").append(this.max_num_kvs).append(", region=").append(string);
        stringBuilder.append(", scanner_id=").append(Bytes.hex(this.scanner_id)).append(')');
        return stringBuilder.toString();
    }

    byte[] table() {
        return this.table;
    }

    byte[] startKey() {
        return this.start_key;
    }

    void setRegionName(RegionInfo regionInfo) {
        this.region = regionInfo;
    }

    void invalidate() {
        this.region = null;
    }

    RegionInfo currentRegion() {
        return this.region;
    }

    HBaseRpc getNextRowsRequest() {
        if (this.get_next_rows_request == null) {
            this.get_next_rows_request = new GetNextRowsRequest();
        }
        return this.get_next_rows_request;
    }

    HBaseRpc getOpenRequest() {
        return new OpenScannerRequest();
    }

    HBaseRpc getCloseRequest() {
        return new CloseScannerRequest(this.scanner_id);
    }

    private void checkScanningNotStarted() {
        if (this.region != null) {
            throw new IllegalStateException("scanning already started");
        }
    }

    static /* synthetic */ byte[] access$502(Scanner scanner, byte[] byArray) {
        scanner.family = byArray;
        return byArray;
    }

    static /* synthetic */ byte[] access$602(Scanner scanner, byte[] byArray) {
        scanner.qualifier = byArray;
        return byArray;
    }

    static /* synthetic */ byte[] access$702(Scanner scanner, byte[] byArray) {
        scanner.start_key = byArray;
        return byArray;
    }

    static /* synthetic */ byte[] access$302(Scanner scanner, byte[] byArray) {
        scanner.stop_key = byArray;
        return byArray;
    }

    private static final class CloseScannerRequest
    extends HBaseRpc {
        private static final byte[] CLOSE = new byte[]{99, 108, 111, 115, 101};
        private final long scanner_id;

        public CloseScannerRequest(long l) {
            super(CLOSE);
            this.scanner_id = l;
        }

        @Override
        ChannelBuffer serialize(byte by) {
            ChannelBuffer channelBuffer = this.newBuffer(13);
            channelBuffer.writeInt(1);
            CloseScannerRequest.writeHBaseLong(channelBuffer, this.scanner_id);
            return channelBuffer;
        }

        @Override
        public String toString() {
            return "CloseScannerRequest(scanner_id=" + this.scanner_id + ", attempt=" + this.attempt + ')';
        }
    }

    private final class GetNextRowsRequest
    extends HBaseRpc {
        public GetNextRowsRequest() {
            super(NEXT);
        }

        @Override
        ChannelBuffer serialize(byte by) {
            ChannelBuffer channelBuffer = this.newBuffer(18);
            channelBuffer.writeInt(2);
            GetNextRowsRequest.writeHBaseLong(channelBuffer, Scanner.this.scanner_id);
            GetNextRowsRequest.writeHBaseInt(channelBuffer, Scanner.this.max_num_rows);
            return channelBuffer;
        }

        @Override
        public String toString() {
            return "GetNextRowsRequest(scanner_id=" + Scanner.this.scanner_id + ", max_num_rows=" + Scanner.this.max_num_rows + ", region=" + this.region + ", attempt=" + this.attempt + ')';
        }
    }

    private final class OpenScannerRequest
    extends HBaseRpc {
        public OpenScannerRequest() {
            super(OPEN_SCANNER, Scanner.this.table, Scanner.this.start_key);
        }

        private int predictSerializedSize() {
            int n = 0;
            n += 4;
            ++n;
            n += 3;
            n += this.region.name().length;
            ++n;
            ++n;
            ++n;
            n += 3;
            n += Scanner.this.start_key.length;
            n += 3;
            n += Scanner.this.stop_key.length;
            n += 4;
            n += 4;
            n += 4;
            ++n;
            ++n;
            if (Scanner.this.filter != null) {
                n += Scanner.this.filter.length;
            }
            n += 8;
            n += 8;
            ++n;
            n += 4;
            if (Scanner.this.family != null) {
                ++n;
                n += Scanner.this.family.length;
                n += 4;
                if (Scanner.this.qualifier != null) {
                    n += 3;
                    n += Scanner.this.qualifier.length;
                }
            }
            return n;
        }

        @Override
        ChannelBuffer serialize(byte by) {
            ChannelBuffer channelBuffer = this.newBuffer(this.predictSerializedSize());
            channelBuffer.writeInt(2);
            OpenScannerRequest.writeHBaseByteArray(channelBuffer, this.region.name());
            channelBuffer.writeByte(39);
            channelBuffer.writeByte(39);
            channelBuffer.writeByte(1);
            OpenScannerRequest.writeByteArray(channelBuffer, Scanner.this.start_key);
            OpenScannerRequest.writeByteArray(channelBuffer, Scanner.this.stop_key);
            channelBuffer.writeInt(1);
            channelBuffer.writeInt(Scanner.this.max_num_kvs);
            channelBuffer.writeInt(-559039906);
            channelBuffer.writeByte(Scanner.this.populate_blockcache ? 1 : 0);
            if (Scanner.this.filter == null) {
                channelBuffer.writeByte(0);
            } else {
                channelBuffer.writeByte(1);
                channelBuffer.writeBytes(Scanner.this.filter);
            }
            channelBuffer.writeLong(0L);
            channelBuffer.writeLong(Long.MAX_VALUE);
            channelBuffer.writeByte(1);
            channelBuffer.writeInt(Scanner.this.family != null ? 1 : 0);
            if (Scanner.this.family != null) {
                OpenScannerRequest.writeByteArray(channelBuffer, Scanner.this.family);
                channelBuffer.writeInt(Scanner.this.qualifier == null ? 0 : 1);
                if (Scanner.this.qualifier != null) {
                    OpenScannerRequest.writeByteArray(channelBuffer, Scanner.this.qualifier);
                }
            }
            Scanner.this.region = this.region;
            return channelBuffer;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(12 + Scanner.this.start_key.length + 2 + 11 + Scanner.this.stop_key.length + 2 + 14 + 4 + 22 + 5);
            stringBuilder.append(", start_key=");
            Bytes.pretty(stringBuilder, Scanner.this.start_key);
            stringBuilder.append(", stop_key=");
            Bytes.pretty(stringBuilder, Scanner.this.stop_key);
            stringBuilder.append(", max_num_kvs=").append(Scanner.this.max_num_kvs).append(", populate_blockcache=").append(Scanner.this.populate_blockcache);
            return super.toStringWithQualifier("OpenScannerRequest", Scanner.this.family, Scanner.this.qualifier, stringBuilder.toString());
        }
    }
}

