/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

final class SingletonList<E>
implements List<E> {
    private final E element;

    public SingletonList(E e) {
        if (e == null) {
            throw new NullPointerException("element");
        }
        this.element = e;
    }

    public String toString() {
        return "[" + this.element + ']';
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object object) {
        return this.element.equals(object);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iter<E>(this.element);
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[]{this.element};
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        if (TArray.length < 1) {
            return this.toArray();
        }
        TArray[0] = this.element;
        if (TArray.length > 1) {
            TArray[1] = null;
        }
        return TArray;
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection.size() != 1) {
            return false;
        }
        return collection.contains(this.element);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof SingletonList)) {
            return false;
        }
        return this.element.equals(((SingletonList)object).element);
    }

    @Override
    public int hashCode() {
        return 31 + this.element.hashCode();
    }

    @Override
    public E get(int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException("only 1 element but index=" + n);
        }
        return this.element;
    }

    @Override
    public E set(int n, E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int n, E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object object) {
        return object.equals(this.element) ? 0 : -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        return object.equals(this.element) ? 0 : -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new Iter<E>(this.element);
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException("only 1 element but index=" + n);
        }
        return new Iter<E>(this.element);
    }

    @Override
    public List<E> subList(int n, int n2) {
        if (n == 0 && n2 == 1) {
            return this;
        }
        throw new IndexOutOfBoundsException("only 1 element but requested [" + n + "; " + n2 + ']');
    }

    private static final class Iter<E>
    implements ListIterator<E> {
        private final E element;
        private boolean returned = false;

        public Iter(E e) {
            this.element = e;
        }

        @Override
        public boolean hasNext() {
            return !this.returned;
        }

        @Override
        public E next() {
            if (this.returned) {
                throw new NoSuchElementException();
            }
            this.returned = true;
            return this.element;
        }

        @Override
        public boolean hasPrevious() {
            return this.returned;
        }

        @Override
        public E previous() {
            if (!this.returned) {
                throw new NoSuchElementException();
            }
            this.returned = false;
            return this.element;
        }

        @Override
        public int nextIndex() {
            return this.returned ? 0 : 1;
        }

        @Override
        public int previousIndex() {
            return this.returned ? -1 : 0;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }
}

