/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hom.cache;

import java.lang.annotation.Annotation;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import me.prettyprint.hom.CFMappingDef;
import me.prettyprint.hom.ClassCacheMgr;
import me.prettyprint.hom.cache.HectorObjectMapperException;
import me.prettyprint.hom.cache.ParserValidator;

public class InheritanceParserValidator
implements ParserValidator {
    @Override
    public <T> void parse(ClassCacheMgr cacheMgr, Annotation anno, CFMappingDef<T> cfMapDef) {
        if (anno instanceof Inheritance) {
            this.parseInheritanceAnnotation((Inheritance)anno, cfMapDef);
        } else if (anno instanceof DiscriminatorColumn) {
            this.parseDiscriminatorColumnAnnotation((DiscriminatorColumn)anno, cfMapDef);
        } else if (anno instanceof DiscriminatorValue) {
            this.parseDiscriminatorValueAnnotation((DiscriminatorValue)anno, cfMapDef);
        } else {
            throw new HectorObjectMapperException("This class cannot parse annotation, " + anno.getClass().getSimpleName());
        }
    }

    private <T> void parseInheritanceAnnotation(Inheritance anno, CFMappingDef<T> cfMapDef) {
        if (InheritanceType.SINGLE_TABLE != anno.strategy()) {
            throw new RuntimeException("Hector object mapper only supports " + InheritanceType.SINGLE_TABLE + " inheritance at the moment");
        }
        cfMapDef.setInheritanceType(InheritanceType.SINGLE_TABLE);
    }

    private <T> void parseDiscriminatorColumnAnnotation(DiscriminatorColumn anno, CFMappingDef<T> cfMapDef) {
        cfMapDef.setDiscColumn(anno.name());
        cfMapDef.setDiscType(anno.discriminatorType());
    }

    private <T> void parseDiscriminatorValueAnnotation(DiscriminatorValue anno, CFMappingDef<T> cfMapDef) {
        cfMapDef.setDiscValue(anno.value());
    }

    @Override
    public <T> void validateAndSetDefaults(ClassCacheMgr cacheMgr, CFMappingDef<T> cfMapDef) {
        if (cfMapDef.isBaseEntity()) {
            this.validateBaseClassInheritance(cfMapDef);
        } else if (cfMapDef.isPersistableDerivedEntity()) {
            this.validateDerivedClassInheritance(cfMapDef);
        } else if (!cfMapDef.isNonPersistableDerivedEntity() && null != cacheMgr.findBaseClassViaMappings(cfMapDef)) {
            throw new HectorObjectMapperException("@" + Inheritance.class.getSimpleName() + " found in class hierarchy, but no @" + DiscriminatorValue.class.getSimpleName() + " - quitting");
        }
    }

    private <T> void validateBaseClassInheritance(CFMappingDef<T> cfMapDef) {
        if (!InheritanceType.SINGLE_TABLE.equals((Object)cfMapDef.getInheritanceType())) {
            throw new HectorObjectMapperException("You chose inheritance type, " + cfMapDef.getInheritanceType().getClass().getSimpleName() + ".  Object mapper only supports " + InheritanceType.SINGLE_TABLE + " inheritance type");
        }
        this.validateSingleTableInheritance(cfMapDef);
    }

    private <T> void validateSingleTableInheritance(CFMappingDef<T> cfMapDef) {
        if (null == cfMapDef.getDiscColumn()) {
            throw new HectorObjectMapperException("Class, " + cfMapDef.getRealClass().getName() + ", requested single table inheritance, but you did not specify a " + DiscriminatorColumn.class.getSimpleName() + " annotation");
        }
        if (cfMapDef.isAbstract() && null != cfMapDef.getDiscValue()) {
            throw new HectorObjectMapperException("Abstract class, " + cfMapDef.getRealClass().getName() + ", has an @" + DiscriminatorValue.class.getSimpleName() + " annotation, but cannot be instantiated");
        }
        if (!cfMapDef.isAbstract() && null == cfMapDef.getDiscValue()) {
            throw new HectorObjectMapperException("Class, " + cfMapDef.getEffectiveClass().getName() + ", is a part of inheritance hierarchy, but did not specify a " + DiscriminatorValue.class.getSimpleName() + " annotation.  Should it be 'abstract'?");
        }
    }

    private <T> void validateDerivedClassInheritance(CFMappingDef<T> cfMapDef) {
        if (null == cfMapDef.getDiscValue()) {
            throw new HectorObjectMapperException("Base class " + cfMapDef.getCfBaseMapDef().getEffectiveClass().getName() + " requested single table inheritance, but this class, " + cfMapDef.getEffectiveClass().getName() + ", did not specify a " + DiscriminatorValue.class.getSimpleName() + " annotation");
        }
    }
}

