(ns hypercrud-service.datomic-util
  (:require [datomic.api :as d]
            [datomico.db :as db]
            [loom.alg-generic :refer [pre-traverse]]))


(defn qes [query dbval & args]
  (->> (apply d/q query dbval args)
       (mapv first)
       (mapv (partial d/entity dbval))))


(defn data-with-dbid
  "from: https://gist.github.com/terjesb/3246747"
  [data]
  (map #(merge {:db/id (d/tempid :db.part/user)} %1) data))


(defmacro with-db-as-of [tx & body]
  `(binding [db/*db* (d/as-of (d/db db/*connection*) ~tx)]
     ~@body))


(defn latest-tx []
  (-> (d/db db/*connection*) d/basis-t d/t->tx))


(defn entity-last-modified-tx [ent]
  (let [entity-datoms (d/datoms (d/entity-db ent) :eavt (:db/id ent))
        last-modified-tx (->> entity-datoms (map :tx) sort reverse first)]
    last-modified-tx))


(defn collection-last-modified-tx [query]
  (let [txs (->> (qes query db/*db*)
                 (mapv entity-last-modified-tx))]
    (if (seq txs) (apply max txs) 0)))


(defn graph-last-modified-tx [start]
  (letfn [(successors [node]
                      ;; need to know which fields are refs, which means need typeinfo
                      nil)]
    (->> (pre-traverse successors start)
         (map entity-last-modified-tx)
         max)))


(defn datomic-simple-q [query tx]
  (with-db-as-of tx (->> (qes query db/*db*)
                         #_ (take 10))))
