(ns hypercrud-service.url-resolver
  (:require [hypercrud-service.dependencies :as dependencies]
            [io.pedestal.http :as bootstrap]
            [io.pedestal.test :refer [test-servlet
                                      test-servlet-request
                                      test-servlet-response
                                      test-servlet-response-status
                                      test-servlet-response-headers]]))


(defn- servlet-response-for
  [interceptor-service-fn verb url & args]
  (let [servlet (test-servlet interceptor-service-fn)
        servlet-request (apply test-servlet-request verb url args)
        ;; change: added additional metadata
        ;;servlet-response (alter-meta! (var (test-servlet-response)) assoc :body-val (atom nil))
        servlet-response (test-servlet-response)
        servlet-response (with-meta servlet-response
                                    (merge (meta servlet-response)
                                           {:body-val (atom nil)}))]
    (.service servlet servlet-request servlet-response)
    {:status (test-servlet-response-status servlet-response)
     ;; change: body comes from metadata, not the servlet-response outputstream
     :body @(-> servlet-response meta :body-val)
     :headers (test-servlet-response-headers servlet-response)}))


(defn- response-for
  [interceptor-service-fn verb url & options]
  (apply servlet-response-for interceptor-service-fn verb url options))


(defn resolve-url [url]
  (response-for
   (:io.pedestal.http/service-fn (dependencies/service-instance :nil))
   :get url
   :headers {"accept" "application/vnd.datomic.entity+edn"}))


(comment
  (resolve-url "/api/communities/17592186045440?tx=13194139534333"))





(comment
  (def service2
    (::bootstrap/service-fn (bootstrap/create-servlet streaker-service.service/service)))

  (:service-fn streaker-service.server/service-instance)

  (io.pedestal.test/response-for
    (:io.pedestal.http/service-fn streaker-service.server/service-instance)
    :get "/api/communities/17592186045440?tx=13194139534333")

  (io.pedestal.test/response-for
    (:io.pedestal.http/service-fn streaker-service.server/service-instance)
    :get "/echo")


  (-> (io.pedestal.test/response-for
        (:io.pedestal.http/service-fn streaker-service.server/service-instance)
        :get "/api/communities/17592186045440?tx=13194139534333"
        :headers {"accept" "application/vnd.datomic.entity+edn"})

      clojure.pprint/pprint))


