(ns hypercrud.service.root-renderer
  (:require [io.pedestal.interceptor :as interceptor]
            [hypercrud.service.response :as response]))


(interceptor/defafter wrap-hypercrud
  "wrap the response value (a collection or entity with hypermedia hints) into a
hypercrud representation. Happens in an interceptor so that we can resolve urls from the jvm
directly to the underlying HypercrudResponse record, not to the final representation."
  [context]
  (update-in context [:response] (fn [r]
    {:hypercrud (response/represent r)})))
