(ns hypercrud.service.representation
  (:require [datomic.api :as d]
            [datomico.db :as db]
            [hypercrud.service.datomic-util :refer [latest-tx with-db-as-of]]
            [hypercrud.service.response :as response])
  (:import (hypercrud.service.response EntityResponse QueryResponse TransactResponse IndexResponse)))


;; Must render out vectors, because when reconstructed on the client,
;; the cursors need collections to be associative

(extend-type EntityResponse
  response/HypercrudRepresentation
  (represent [{:keys [entity form tx]}]
    (with-db-as-of tx
      ;; map the typeinfo instead of the ent directly
      ;; if the field is an entity, lazy-cj-item
      ;; if the field is a keyword, if it's a keyword, that's an ident and convert to lazy-cj-item
      (->> form
           (map (fn [{:keys [name datatype set]}]
                  (let [v (get entity name)
                        v (cond

                            (and (= datatype :ref) (not set) (not (nil? v)))
                            (:db/id (cond (keyword? v) (d/entity db/*db* v)
                                          :just-a-primitive v))

                            (and (= datatype :ref) set (not (nil? v)))
                            (->> v
                                 (map
                                   #(:db/id (cond (keyword? %) (d/entity db/*db* %)
                                                  :just-a-primitive %)))
                                 (into #{}))

                            :just-a-primitive
                            v)]
                    [name v])))
           (into (select-keys entity [:meta/type]))))))


(extend-type QueryResponse
  response/HypercrudRepresentation
  (represent [{:keys [resultset]}]
    (mapv #(:db/id %) resultset)))


(extend-type TransactResponse
  response/HypercrudRepresentation
  (represent [{:keys [tx]}]
    {:tx tx}))


(extend-type IndexResponse
  response/HypercrudRepresentation
  (represent [{:keys [tx]}]
    {:tx tx}))