(ns hypercrud.service.datomic-util
  (:require [datomic.api :as d]
            [datomico.db :as db]))


(defn qes [query dbval & args]
  (->> (apply d/q query dbval args)
       (mapv first)
       (mapv (partial d/entity dbval))))


(defmacro with-db-as-of [tx & body]
  `(binding [db/*db* (d/as-of (d/db db/*connection*) ~tx)]
     ~@body))


(defn latest-tx []
  (-> (d/db db/*connection*) d/basis-t d/t->tx))


(defn datomic-simple-q [query tx]
  (with-db-as-of tx (qes query db/*db*)))
