(ns hypercrud-ssr.core
  (:require [cljs.nodejs :as node]
            [cljs.reader :as reader]
            [hypercrud-ssr.render :as render]
            [promesa.core :as p]
            [goog.Uri]))


(def fs (node/require "fs"))
(def util (node/require "util"))
(def path (node/require "path"))
(def express (node/require "express"))
(def st (node/require "st"))


(defn serve-ssr! [hc-client-state config-filename app-component]
  (let [config (-> (.readFileSync fs config-filename "utf-8") reader/read-string)
        env-port (-> node/process .-env .-PORT)
        port (if (nil? env-port) "3000" env-port)
        app (express)
        mount (st #js {:url (:static-resources config)
                       :path (:browser-script-dir config)})
        template (.readFileSync fs "index.html" "utf-8")    ;after the chdir
        ssr-handler (fn [req res]
                      (-> (render/render-html-async
                            app-component
                            hc-client-state
                            (.-path req)
                            (:service-root-browser config)
                            (goog.Uri. (:service-root-node config))
                            (:app-root config)
                            template)
                          (p/then #(.send res %))
                          (p/catch #(-> res (.status 500) (.send %)))))]

    (doto app
      (.use mount)                                          ; serve the browser client assets
      (.get "/*" ssr-handler)
      (.listen port))
    (println (str " Express server started on port: " port))))
