(ns hypercrud-ui.select
  (:require [hypercrud-client.core :as hypercrud]
            [hypercrud-ui.form :as form]
            [reagent.core :as reagent]))


(defn select-option
  ":option :value and :on-change is a string, since that's how the dom works"
  [client label-prop cj-option-item]
  #_ (println (str "select-option cj-option-item: " cj-option-item))
  ^{:key (:href cj-option-item)}
  [hypercrud/resolve client cj-option-item
   (fn [{:keys [href links data] :as cj-option-item}]
     ;; the dom will stringify the :value i believe
     [:option {:key href :value href} (str (get data label-prop))])
   (fn [hc-node] [:option])])


(defn select
  [{:keys [client label-prop cj-options-list cur] :as props}]
  (assert (not (nil? cur)))
  (let [updating? (reagent/atom false)]
    (fn [{:keys [client label-prop cj-options-list cur] :as props}]
      #_ (println (str "select-list cj-options-list: " cj-options-list))
      [hypercrud/resolve client cj-options-list
       (fn [{:keys [data template] :as cj-options-list}]
         (let [props (-> props
                         (dissoc :client :label-prop :cj-options-list :cur)

                         ;; normalize value for the dom
                         ;; value is either nil, an :ident (keyword), or
                         ;; a cj item ref e.g. {:href ...}
                         (assoc :value (cond
                                        (nil? @cur) ""
                                        (keyword? @cur) (-> @cur .toString)
                                        :cj-item-ref (-> @cur :href .toString)))

                         ;; reconstruct the typed value (keyword or cj item ref)
                         (assoc :on-change
                           #(do
                             (reset! cur
                                     (let [dom-val (.-target.value %)]
                                       (println (str "select-list-onchange: " dom-val))
                                       (cond
                                         (empty? dom-val) nil
                                         (= \: (first dom-val)) (keyword (subs dom-val 1))
                                         :cj-item-ref {:href (goog.Uri. dom-val)})))
                             (reset! updating? false))))
               create-new? (= (:href @cur) (goog.Uri. "tempid"))
               show-form? (or @updating? create-new?)]

           ^{:key (:href cj-options-list)}
           [:div
            [:select props (-> (doall (map (fn [[rel hc-node]] (select-option client label-prop hc-node)) data))
                               (concat [[:option {:key :create-new :value "tempid"} "Create New"]]))]
            [:button {:on-click #(swap! updating? not)
                      :disabled (= nil @cur)}
             (if show-form? "Discard" "Edit")]
            (if show-form?
              (if create-new?
                [form/cj-form client cur template "indent"]
                [hypercrud/resolve client @cur
                 (fn [hc-node]
                   [form/cj-form client (cur [] hc-node #(not (hypercrud/loaded? client %))) template "indent"])]))]))])))


(defn select-multiple
  [{:keys [client label-prop cj-options-list cur] :as props}]
  [hypercrud/resolve client cj-options-list
   (fn [{:keys [data] :as cj-options-list}]
     (let [props (-> props
                     (dissoc :client :label-prop :cj-options-list :cur)
                     (assoc :multiple true)

                     ;; React.DOM.select's :value is List[String]
                     (assoc :value (mapv #(-> % :href .toString)
                                         (or @cur #{})))

                     ;; reconstruct the Hypercrud type (cj-item-ref)
                     (assoc :on-change
                       (fn [e]
                         (->> (for [i (range (.-target.length e))]
                                (let [opt (aget (.-target e) i)]
                                  (if (.-selected opt) (.-value opt) nil)))
                              (remove nil?)
                              (map (fn [s] {:href s}))
                              (into #{})
                              (reset! cur)))))]

       [:select props (doall (map (fn [[rel hc-node]] (select-option client label-prop hc-node))
                                  data))]))])
