(ns hypercrud-ui.auto-control-default
  (:require [cljs.core.match :refer-macros [match]]
            [hypercrud-ui.auto-control :as auto-control]
            [hypercrud-ui.widget :as widget]))


(defn widget-for-fieldinfo [fieldinfo]
  (match [fieldinfo]
         [{:datatype :string :set false}] widget/input
         [{:datatype :string :set true}] widget/input-many
         [{:datatype :ref :set false}] widget/select
         [{:datatype :ref :set true}] widget/multi-select
         [{:datatype :keyword}] widget/keyword-input
         :else widget/default))


(defmethod auto-control/auto-control :default [fieldinfo client field-cur]
  ((widget-for-fieldinfo fieldinfo) fieldinfo client field-cur))
