(ns hypercrud-ui.form
  (:require [hypercrud-ui.auto-control :refer [auto-control]]
            [hypercrud-client.core :as hypercrud]))


(defn cj-form-field [{:keys [datatype name prompt] :as fieldinfo} client value change!]
  [:div.cj-field {:key (str name)}
   [:label prompt]
   (auto-control fieldinfo client value change!)])


(defn cj-form [client {:keys [rel] :as hc-node} template & [css-class]]
  [hypercrud/resolve client hc-node
   (fn [hc-node]
     [:div.cj-form {:class css-class}
      (doall
        (map (fn [{:keys [name] :as fieldinfo}]
               (let [value (get-in hc-node [:data name])
                     change! #(hypercrud/transact! client [[rel name % %2]])]
                 (cj-form-field fieldinfo client value change!)))
             (:data template)))])])
