(ns hypercrud-ui.multi-select
  (:require [hypercrud-ui.auto-control :refer [auto-control]]
            [hypercrud-client.core :as hypercrud]))


(defmulti multi-select-markup (fn [click-add! control-tuples] :default))


(defn multi-select* [markupfn fieldinfo client value change! add-item! transact!]
  (let [control-tuples (map (fn [v]
                              (let [click-remove! #(change! v :db/retract)
                                    control [auto-control (assoc fieldinfo :set false) client
                                             v
                                             change!
                                             transact!]]
                                [v click-remove! control]))
                            value)]
    (markupfn add-item! control-tuples)))


(defmethod multi-select-markup :default [click-add! control-tuples & [css-class]]
  [:div.multi-select {:class css-class}
   (map (fn [[v click-remove! control]]
          ^{:key v}
          [:div.multi-select-group
           [:button {:on-click click-remove!} "-"]
           control])
        control-tuples)
   [:button {:on-click click-add!} "+"]])
