(ns hypercrud-ui.auto-control-default
  (:require [cljs.core.match :refer-macros [match]]
            [hypercrud-ui.auto-control :as auto-control]
            [hypercrud-ui.widget :as widget]))


(defn widget-for-fieldinfo [fieldinfo]
  (match [fieldinfo]
         [{:datatype :string :set false}] widget/input
         [{:datatype :string :set true}] widget/input-many
         [{:datatype :ref :set false :component true}] widget/select-comp
         [{:datatype :ref :set false}] widget/select
         [{:datatype :ref :set true :component true}] widget/multi-select-comp
         [{:datatype :ref :set true}] widget/multi-select
         [{:datatype :keyword}] widget/keyword-input
         :else widget/default))


(defmethod auto-control/auto-control :default [fieldinfo client model value change! transact!]
  [(widget-for-fieldinfo fieldinfo) fieldinfo client model value change! transact!])
