(ns hypercrud-ui.form
  (:require [hypercrud-ui.auto-control :refer [auto-control]]
            [hypercrud-client.core :as hypercrud]))


(defn cj-form-field [{:keys [name prompt] :as fieldinfo} client model value change! transact!]
  [:div.cj-field {:key (str name)}
   [:label prompt]
   [auto-control fieldinfo client model value change! transact!]])


(defn cj-form [client eid model local-transact!]
  [hypercrud/resolve client eid
   (fn [entity]
     [:div.cj-form
      (doall
        (map (fn [{:keys [name] :as fieldinfo}]
               (let [value (get entity name)
                     change! #(local-transact! [[%2 eid name %1]])]
                 ^{:key name}
                 [cj-form-field fieldinfo client model value change! local-transact!]))
             ((:forms model) ((:reflect-entity-type model) entity))))])])
