(ns hypercrud-ui.widget
  (:require [hypercrud-ui.auto-control :refer [auto-control]]
            [hypercrud-ui.form :refer [cj-form]]
            [hypercrud-ui.input :refer [input*]]
            [hypercrud-ui.multi-select :refer [multi-select* multi-select-markup]]
            [hypercrud-ui.select :refer [select*]]
            [hypercrud-client.core :as hypercrud]))


(defn input [fieldinfo client model value change! transact!]
  [input* {:type "text"
           :value value
           :on-change change!}])


(defn input-many [fieldinfo client model value change! transact!]
  [input* {:type "text"
           :value (clojure.string/join ", " value)}])


(defn select [{:keys [options] :as fieldinfo} client model value change! transact!]
  ;;select* has parameterized markup fn todo
  [select* client model options value change! transact!])


(defn select-comp [fieldinfo client model value change! transact!]
  (cj-form client value model transact!))


(defn multi-select [fieldinfo client model value change! transact!]
  (multi-select*
    multi-select-markup
    fieldinfo client model value change! #(change! nil :db/add) transact!)) ;add-item! is: add nil to set


(defn multi-select-comp [{:keys [options] :as fieldinfo} client model value change! transact!]
  [multi-select*
   multi-select-markup
   fieldinfo client model value change! #(change! :temp-tempid :db/add) transact!]) ;add new entity to set


(defn keyword-input [fieldinfo client model value change! transact!]
  [input* {:type "text"
           :value (str value)
           :on-change #(change! (keyword (subs % 1)) :db/add)}])


(defn default [fieldinfo client model value change! transact!]
  [input* {:type "text"
           :value (str (select-keys fieldinfo [:datatype :set :component]))}])
