(ns hypercrud.service.util
  (:require [datomic.api :as d]))


(defn hc-tempid? [eid] (< eid 0))


(defn entity-created-by [user db eid]
  (let [[e a v tx op] (first (d/seek-datoms db :eavt eid :db/id))
        {:keys [:hypercrud/created-by]} (d/entity db tx)]
    (= user created-by)))


(defn is-ref? [db a]
  (= :db.type/ref (:db/valueType (d/entity db a))))


(defn marshal-statement-types
  "statements must use datomic's low level entity types (e.g. database.DbId)"
  [db [op e a v]]
  (let [e (if (hc-tempid? e) (d/tempid :db.part/user e) e)
        v (if (is-ref? db a)
            (if (hc-tempid? v)
              (d/tempid :db.part/user v)
              (d/entity db v))
            v)]
    [op e a v]))


(defn wrap-hypercrud [m]
  {:hypercrud m})


(defn latest-tx [conn]
  (-> (d/db conn) d/basis-t d/t->tx))


(defn get-root-conn [transactor-uri]
  (d/connect (str transactor-uri "root")))


(defn app-uri [transactor-uri app-owner app-name]
  (str transactor-uri app-owner "-" app-name))


(defn get-app-conn [transactor-uri app-owner app-name]
  (d/connect (app-uri transactor-uri app-owner app-name)))
