(ns hypercrud.ssr.core
  (:require [cljs.nodejs :as node]
            [cljs.reader :as reader]
            [goog.Uri]
            [hypercrud.ssr.render :as render]
            [promesa.core :as p]))


(def fs (node/require "fs"))
(def util (node/require "util"))
(def path (node/require "path"))
(def express (node/require "express"))
(def st (node/require "st"))
(def winston (node/require "winston"))
(def expressWinston (node/require "express-winston"))


(defn serve-ssr! [config-filename app-component app-query indexed-schema]
  (let [config (-> (.readFileSync fs config-filename "utf-8") reader/read-string)
        env-port (-> node/process .-env .-PORT)
        port (if (nil? env-port) "3000" env-port)
        app (express)
        mount (st #js {:url (:static-resources config)
                       :path (:browser-script-dir config)})
        template (.readFileSync fs "index.html" "utf-8")
        ssr-handler (fn [req res]
                      (.log js/console "received request")
                      (let [t (-> req .-query .-tx)         ;fixme tx -> t
                            cache-control (if t "max-age=31536000" "max-age=0")]
                        (-> (render/render-html-async
                              app-component
                              app-query
                              indexed-schema
                              template
                              (js/parseInt t 10)
                              (-> req .-query .-user-token)
                              (.-path req)
                              (:service-root-browser config)
                              (goog.Uri. (:service-root-node config))
                              (:app-root config))
                            (p/then (fn [html] (-> res
                                                   (.append "Cache-Control" cache-control)
                                                   (.status 200)
                                                   (.send html))))
                            (p/catch #(-> res (.status 500) (.send %))))))]

    (doto app
      (.use mount)                                          ; serve the browser client assets
      (.use (.logger expressWinston #js {"transports" #js [(new winston.transports.Console (clj->js {:json true :colorize true}))]}))
      (.get "/*" ssr-handler)
      (.listen port))
    (println (str " Express server started on port: " port))))
