(ns hypercrud.ssr.render
  (:require [cljs.nodejs :as node]
            [clojure.string :as string]
            [cursor.core :as cursor]
            [hypercrud.client.core :as hc]
            [hypercrud.client.graph :as graph]
            [hypercrud.client.http :as http]
            [hypercrud.client.internal :as internal]
            [promesa.core :as p]
            [reagent.core :as reagent]))


(def cheerio (node/require "cheerio"))


(defn timez [m f]
  (let [start (js/Date.)
        r (f)
        end (js/Date.)]
    (println (str m ":" start "   " end "   " (- (.getTime end) (.getTime start))))
    r))

(defn evaluated-template [template app-html service-root-browser app-root t graph]
  (let [$ (.load cheerio template)]
    (-> ($ "#app-css") (.attr "href" (str app-root "static/styles.css")))
    (-> ($ "#root") (.html app-html))
    (-> ($ "#app-preamble") (.attr "src" (str app-root "static/preamble.js")))
    (-> ($ "#service-root") (.text service-root-browser))
    (-> ($ "#app-root") (.text app-root))
    (-> ($ "#named-queries") (.text (internal/transit-encode (graph/named-queries* graph))))
    (-> ($ "#t") (.text t))
    (-> ($ "#pulled-trees-map") (.text (internal/transit-encode (graph/pulled-trees-map* graph))))
    (-> ($ "#app-js") (.attr "src" (str app-root "static/main.js")))
    (.html $)))


(def transact! #(assert false "transact! not supported in ssr"))
(def cur (cursor/virtual-cursor nil #(assert false "cursor write! not supported in ssr") 0))


(defn render-html-async [app-component app-query indexed-schema template
                         t user-token root-rel-path service-root-browser service-root-node app-root]
  (let [page-rel-path (do (assert (string/starts-with? root-rel-path app-root))
                          (subs root-rel-path (count app-root)))
        client (http/Client. user-token service-root-node indexed-schema nil)]
    (-> (timez "hydrate" #(hc/hydrate! client (app-query nil page-rel-path) t))
        (p/then (fn [graph]
                  (let [app-html (timez "render" #(reagent/render-to-string (app-component transact! graph cur page-rel-path)))]
                    (timez "template" #(evaluated-template template app-html service-root-browser app-root t graph)))))
        (p/catch
          (fn [error]
            (p/rejected
              (str
                "<html><body>"
                "<h2>Error:</h2>"
                "<pre>" (.-stack error) "</pre>"
                "</body></html>")))))))
