/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.codahalemetricspublisher;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherThreadPool;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixCodaHaleMetricsPublisherThreadPool
implements HystrixMetricsPublisherThreadPool {
    private final String metricsRootNode;
    private final HystrixThreadPoolKey key;
    private final HystrixThreadPoolMetrics metrics;
    private final HystrixThreadPoolProperties properties;
    private final MetricRegistry metricRegistry;
    private final String metricGroup;
    private final String metricType;
    static final Logger logger = LoggerFactory.getLogger(HystrixCodaHaleMetricsPublisherThreadPool.class);

    public HystrixCodaHaleMetricsPublisherThreadPool(String metricsRootNode, HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolMetrics metrics, HystrixThreadPoolProperties properties, MetricRegistry metricRegistry) {
        this.metricsRootNode = metricsRootNode;
        this.key = threadPoolKey;
        this.metrics = metrics;
        this.properties = properties;
        this.metricRegistry = metricRegistry;
        this.metricGroup = "HystrixThreadPool";
        this.metricType = this.key.name();
    }

    public void initialize() {
        this.metricRegistry.remove(this.createMetricName("name"));
        this.metricRegistry.register(this.createMetricName("name"), (Metric)new Gauge<String>(){

            public String getValue() {
                return HystrixCodaHaleMetricsPublisherThreadPool.this.key.name();
            }
        });
        this.metricRegistry.remove(this.createMetricName("currentTime"));
        this.metricRegistry.register(this.createMetricName("currentTime"), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return System.currentTimeMillis();
            }
        });
        this.metricRegistry.remove(this.createMetricName("threadActiveCount"));
        this.metricRegistry.register(this.createMetricName("threadActiveCount"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return HystrixCodaHaleMetricsPublisherThreadPool.this.metrics.getCurrentActiveCount();
            }
        });
        this.metricRegistry.remove(this.createMetricName("completedTaskCount"));
        this.metricRegistry.register(this.createMetricName("completedTaskCount"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return HystrixCodaHaleMetricsPublisherThreadPool.this.metrics.getCurrentCompletedTaskCount();
            }
        });
        this.metricRegistry.remove(this.createMetricName("largestPoolSize"));
        this.metricRegistry.register(this.createMetricName("largestPoolSize"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return HystrixCodaHaleMetricsPublisherThreadPool.this.metrics.getCurrentLargestPoolSize();
            }
        });
        this.metricRegistry.remove(this.createMetricName("totalTaskCount"));
        this.metricRegistry.register(this.createMetricName("totalTaskCount"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return HystrixCodaHaleMetricsPublisherThreadPool.this.metrics.getCurrentTaskCount();
            }
        });
        this.metricRegistry.remove(this.createMetricName("queueSize"));
        this.metricRegistry.register(this.createMetricName("queueSize"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return HystrixCodaHaleMetricsPublisherThreadPool.this.metrics.getCurrentQueueSize();
            }
        });
        this.metricRegistry.remove(this.createMetricName("rollingMaxActiveThreads"));
        this.metricRegistry.register(this.createMetricName("rollingMaxActiveThreads"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return HystrixCodaHaleMetricsPublisherThreadPool.this.metrics.getRollingMaxActiveThreads();
            }
        });
        this.metricRegistry.remove(this.createMetricName("countThreadsExecuted"));
        this.metricRegistry.register(this.createMetricName("countThreadsExecuted"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return HystrixCodaHaleMetricsPublisherThreadPool.this.metrics.getCumulativeCountThreadsExecuted();
            }
        });
        this.metricRegistry.remove(this.createMetricName("rollingCountCommandsRejected"));
        this.metricRegistry.register(this.createMetricName("rollingCountCommandsRejected"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                try {
                    return HystrixCodaHaleMetricsPublisherThreadPool.this.metrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED);
                }
                catch (NoSuchFieldError error) {
                    logger.error("While publishing CodaHale metrics, error looking up eventType for : rollingCountCommandsRejected.  Please check that all Hystrix versions are the same!");
                    return 0L;
                }
            }
        });
        this.metricRegistry.remove(this.createMetricName("rollingCountThreadsExecuted"));
        this.metricRegistry.register(this.createMetricName("rollingCountThreadsExecuted"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return HystrixCodaHaleMetricsPublisherThreadPool.this.metrics.getRollingCountThreadsExecuted();
            }
        });
        this.metricRegistry.remove(this.createMetricName("propertyValue_corePoolSize"));
        this.metricRegistry.register(this.createMetricName("propertyValue_corePoolSize"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return (Number)HystrixCodaHaleMetricsPublisherThreadPool.this.properties.coreSize().get();
            }
        });
        this.metricRegistry.remove(this.createMetricName("propertyValue_maximumSize"));
        this.metricRegistry.register(this.createMetricName("propertyValue_maximumSize"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return (Number)HystrixCodaHaleMetricsPublisherThreadPool.this.properties.maximumSize().get();
            }
        });
        this.metricRegistry.remove(this.createMetricName("propertyValue_actualMaximumSize"));
        this.metricRegistry.register(this.createMetricName("propertyValue_actualMaximumSize"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return HystrixCodaHaleMetricsPublisherThreadPool.this.properties.actualMaximumSize();
            }
        });
        this.metricRegistry.remove(this.createMetricName("propertyValue_keepAliveTimeInMinutes"));
        this.metricRegistry.register(this.createMetricName("propertyValue_keepAliveTimeInMinutes"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return (Number)HystrixCodaHaleMetricsPublisherThreadPool.this.properties.keepAliveTimeMinutes().get();
            }
        });
        this.metricRegistry.remove(this.createMetricName("propertyValue_queueSizeRejectionThreshold"));
        this.metricRegistry.register(this.createMetricName("propertyValue_queueSizeRejectionThreshold"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return (Number)HystrixCodaHaleMetricsPublisherThreadPool.this.properties.queueSizeRejectionThreshold().get();
            }
        });
        this.metricRegistry.remove(this.createMetricName("propertyValue_maxQueueSize"));
        this.metricRegistry.register(this.createMetricName("propertyValue_maxQueueSize"), (Metric)new Gauge<Number>(){

            public Number getValue() {
                return (Number)HystrixCodaHaleMetricsPublisherThreadPool.this.properties.maxQueueSize().get();
            }
        });
    }

    protected String createMetricName(String name) {
        return MetricRegistry.name((String)this.metricsRootNode, (String[])new String[]{this.metricGroup, this.metricType, name});
    }
}

