/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixContextScheduler;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherFactory;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Scheduler;
import rx.functions.Func0;

public interface HystrixThreadPool {
    public ExecutorService getExecutor();

    public Scheduler getScheduler();

    public Scheduler getScheduler(Func0<Boolean> var1);

    public void markThreadExecution();

    public void markThreadCompletion();

    public void markThreadRejection();

    public boolean isQueueSpaceAvailable();

    public static class HystrixThreadPoolDefault
    implements HystrixThreadPool {
        private static final Logger logger = LoggerFactory.getLogger(HystrixThreadPoolDefault.class);
        private final HystrixThreadPoolProperties properties;
        private final BlockingQueue<Runnable> queue;
        private final ThreadPoolExecutor threadPool;
        private final HystrixThreadPoolMetrics metrics;
        private final int queueSize;

        public HystrixThreadPoolDefault(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolProperties.Setter propertiesDefaults, boolean updated) {
            this.properties = HystrixPropertiesFactory.getThreadPoolProperties(threadPoolKey, propertiesDefaults, updated);
            HystrixConcurrencyStrategy concurrencyStrategy = HystrixPlugins.getInstance().getConcurrencyStrategy();
            this.queueSize = this.properties.maxQueueSize().get();
            this.metrics = HystrixThreadPoolMetrics.getInstance(threadPoolKey, concurrencyStrategy.getThreadPool(threadPoolKey, this.properties), this.properties, updated);
            this.threadPool = this.metrics.getThreadPool();
            this.queue = this.threadPool.getQueue();
            HystrixMetricsPublisherFactory.createOrRetrievePublisherForThreadPool(threadPoolKey, this.metrics, this.properties);
        }

        @Override
        public ThreadPoolExecutor getExecutor() {
            this.touchConfig();
            return this.threadPool;
        }

        @Override
        public Scheduler getScheduler() {
            return this.getScheduler(new Func0<Boolean>(){

                public Boolean call() {
                    return true;
                }
            });
        }

        @Override
        public Scheduler getScheduler(Func0<Boolean> shouldInterruptThread) {
            this.touchConfig();
            return new HystrixContextScheduler(HystrixPlugins.getInstance().getConcurrencyStrategy(), this, shouldInterruptThread);
        }

        private void touchConfig() {
            int dynamicCoreSize = this.properties.coreSize().get();
            int configuredMaximumSize = this.properties.maximumSize().get();
            int dynamicMaximumSize = this.properties.actualMaximumSize();
            boolean allowSizesToDiverge = this.properties.getAllowMaximumSizeToDivergeFromCoreSize().get();
            boolean maxTooLow = false;
            if (allowSizesToDiverge && configuredMaximumSize < dynamicCoreSize) {
                dynamicMaximumSize = dynamicCoreSize;
                maxTooLow = true;
            }
            if (this.threadPool.getCorePoolSize() != dynamicCoreSize || allowSizesToDiverge && this.threadPool.getMaximumPoolSize() != dynamicMaximumSize) {
                if (maxTooLow) {
                    logger.error("Hystrix ThreadPool configuration for : " + this.metrics.getThreadPoolKey().name() + " is trying to set coreSize = " + dynamicCoreSize + " and maximumSize = " + configuredMaximumSize + ".  Maximum size will be set to " + dynamicMaximumSize + ", the coreSize value, since it must be equal to or greater than the coreSize value");
                }
                this.threadPool.setCorePoolSize(dynamicCoreSize);
                this.threadPool.setMaximumPoolSize(dynamicMaximumSize);
            }
            this.threadPool.setKeepAliveTime(this.properties.keepAliveTimeMinutes().get().intValue(), TimeUnit.MINUTES);
        }

        @Override
        public void markThreadExecution() {
            this.metrics.markThreadExecution();
        }

        @Override
        public void markThreadCompletion() {
            this.metrics.markThreadCompletion();
        }

        @Override
        public void markThreadRejection() {
            this.metrics.markThreadRejection();
        }

        @Override
        public boolean isQueueSpaceAvailable() {
            if (this.queueSize <= 0) {
                return true;
            }
            return this.threadPool.getQueue().size() < this.properties.queueSizeRejectionThreshold().get();
        }
    }

    public static class Factory {
        static final ConcurrentHashMap<String, HystrixThreadPool> threadPools = new ConcurrentHashMap();
        static final ConcurrentHashMap<String, HystrixThreadPoolProperties.Setter> threadPoolProperties = new ConcurrentHashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static HystrixThreadPool getInstance(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolProperties.Setter propertiesBuilder) {
            String key = threadPoolKey.name();
            HystrixThreadPoolProperties.Setter oldPropertiesBuilder = threadPoolProperties.get(key);
            boolean updated = oldPropertiesBuilder != null && !oldPropertiesBuilder.equals(propertiesBuilder);
            HystrixThreadPool previouslyCached = threadPools.get(key);
            if (previouslyCached != null && !updated) {
                return previouslyCached;
            }
            Class<HystrixThreadPool> clazz = HystrixThreadPool.class;
            synchronized (HystrixThreadPool.class) {
                if (!threadPools.containsKey(key) || updated) {
                    threadPools.put(key, new HystrixThreadPoolDefault(threadPoolKey, propertiesBuilder, updated));
                    if (propertiesBuilder != null) {
                        threadPoolProperties.put(key, propertiesBuilder);
                    }
                    if (previouslyCached != null) {
                        previouslyCached.getExecutor().shutdown();
                    }
                }
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return threadPools.get(key);
            }
        }

        static synchronized void shutdown() {
            for (HystrixThreadPool pool : threadPools.values()) {
                pool.getExecutor().shutdown();
            }
            threadPools.clear();
        }

        static synchronized void shutdown(long timeout, TimeUnit unit) {
            for (HystrixThreadPool pool : threadPools.values()) {
                pool.getExecutor().shutdown();
            }
            for (HystrixThreadPool pool : threadPools.values()) {
                try {
                    while (!pool.getExecutor().awaitTermination(timeout, unit)) {
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted while waiting for thread-pools to terminate. Pools may not be correctly shutdown or cleared.", e);
                }
            }
            threadPools.clear();
        }
    }
}

