/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import rx.Subscriber;
import rx.Subscription;

public interface HystrixCircuitBreaker {
    public boolean allowRequest();

    public boolean isOpen();

    public void markSuccess();

    public void markNonSuccess();

    public boolean attemptExecution();

    public static class NoOpCircuitBreaker
    implements HystrixCircuitBreaker {
        @Override
        public boolean allowRequest() {
            return true;
        }

        @Override
        public boolean isOpen() {
            return false;
        }

        @Override
        public void markSuccess() {
        }

        @Override
        public void markNonSuccess() {
        }

        @Override
        public boolean attemptExecution() {
            return true;
        }
    }

    public static class HystrixCircuitBreakerImpl
    implements HystrixCircuitBreaker {
        private final HystrixCommandProperties properties;
        private final HystrixCommandMetrics metrics;
        private final AtomicReference<Status> status = new AtomicReference<Status>(Status.CLOSED);
        private final AtomicLong circuitOpened = new AtomicLong(-1L);
        private final AtomicReference<Subscription> activeSubscription = new AtomicReference<Object>(null);

        protected HystrixCircuitBreakerImpl(HystrixCommandKey key, HystrixCommandGroupKey commandGroup, HystrixCommandProperties properties, HystrixCommandMetrics metrics) {
            this.properties = properties;
            this.metrics = metrics;
            Subscription s = this.subscribeToStream();
            this.activeSubscription.set(s);
        }

        private Subscription subscribeToStream() {
            return this.metrics.getHealthCountsStream().observe().subscribe((Subscriber)new Subscriber<HystrixCommandMetrics.HealthCounts>(){

                public void onCompleted() {
                }

                public void onError(Throwable e) {
                }

                public void onNext(HystrixCommandMetrics.HealthCounts hc) {
                    if (hc.getTotalRequests() >= (long)properties.circuitBreakerRequestVolumeThreshold().get().intValue() && hc.getErrorPercentage() >= properties.circuitBreakerErrorThresholdPercentage().get() && status.compareAndSet(Status.CLOSED, Status.OPEN)) {
                        circuitOpened.set(System.currentTimeMillis());
                    }
                }
            });
        }

        @Override
        public void markSuccess() {
            if (this.status.compareAndSet(Status.HALF_OPEN, Status.CLOSED)) {
                this.metrics.resetStream();
                Subscription previousSubscription = this.activeSubscription.get();
                if (previousSubscription != null) {
                    previousSubscription.unsubscribe();
                }
                Subscription newSubscription = this.subscribeToStream();
                this.activeSubscription.set(newSubscription);
                this.circuitOpened.set(-1L);
            }
        }

        @Override
        public void markNonSuccess() {
            if (this.status.compareAndSet(Status.HALF_OPEN, Status.OPEN)) {
                this.circuitOpened.set(System.currentTimeMillis());
            }
        }

        @Override
        public boolean isOpen() {
            if (this.properties.circuitBreakerForceOpen().get().booleanValue()) {
                return true;
            }
            if (this.properties.circuitBreakerForceClosed().get().booleanValue()) {
                return false;
            }
            return this.circuitOpened.get() >= 0L;
        }

        @Override
        public boolean allowRequest() {
            if (this.properties.circuitBreakerForceOpen().get().booleanValue()) {
                return false;
            }
            if (this.properties.circuitBreakerForceClosed().get().booleanValue()) {
                return true;
            }
            if (this.circuitOpened.get() == -1L) {
                return true;
            }
            if (this.status.get().equals((Object)Status.HALF_OPEN)) {
                return false;
            }
            return this.isAfterSleepWindow();
        }

        private boolean isAfterSleepWindow() {
            long sleepWindowTime;
            long circuitOpenTime = this.circuitOpened.get();
            long currentTime = System.currentTimeMillis();
            return currentTime > circuitOpenTime + (sleepWindowTime = (long)this.properties.circuitBreakerSleepWindowInMilliseconds().get().intValue());
        }

        @Override
        public boolean attemptExecution() {
            if (this.properties.circuitBreakerForceOpen().get().booleanValue()) {
                return false;
            }
            if (this.properties.circuitBreakerForceClosed().get().booleanValue()) {
                return true;
            }
            if (this.circuitOpened.get() == -1L) {
                return true;
            }
            if (this.isAfterSleepWindow()) {
                return this.status.compareAndSet(Status.OPEN, Status.HALF_OPEN);
            }
            return false;
        }

        static enum Status {
            CLOSED,
            OPEN,
            HALF_OPEN;

        }
    }

    public static class Factory {
        private static ConcurrentHashMap<String, HystrixCircuitBreaker> circuitBreakersByCommand = new ConcurrentHashMap();

        public static HystrixCircuitBreaker getInstance(HystrixCommandKey key, HystrixCommandGroupKey group, HystrixCommandProperties properties, HystrixCommandMetrics metrics) {
            HystrixCircuitBreaker previouslyCached = circuitBreakersByCommand.get(key.name());
            if (previouslyCached != null) {
                return previouslyCached;
            }
            HystrixCircuitBreaker cbForCommand = circuitBreakersByCommand.putIfAbsent(key.name(), new HystrixCircuitBreakerImpl(key, group, properties, metrics));
            if (cbForCommand == null) {
                return circuitBreakersByCommand.get(key.name());
            }
            return cbForCommand;
        }

        public static HystrixCircuitBreaker getInstance(HystrixCommandKey key) {
            return circuitBreakersByCommand.get(key.name());
        }

        static void reset() {
            circuitBreakersByCommand.clear();
        }
    }
}

