/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.util;

import com.netflix.hystrix.HystrixEventType;

public enum HystrixRollingNumberEvent {
    SUCCESS(1),
    FAILURE(1),
    TIMEOUT(1),
    SHORT_CIRCUITED(1),
    THREAD_POOL_REJECTED(1),
    SEMAPHORE_REJECTED(1),
    BAD_REQUEST(1),
    FALLBACK_SUCCESS(1),
    FALLBACK_FAILURE(1),
    FALLBACK_REJECTION(1),
    FALLBACK_MISSING(1),
    EXCEPTION_THROWN(1),
    COMMAND_MAX_ACTIVE(2),
    EMIT(1),
    FALLBACK_EMIT(1),
    THREAD_EXECUTION(1),
    THREAD_MAX_ACTIVE(2),
    COLLAPSED(1),
    RESPONSE_FROM_CACHE(1),
    COLLAPSER_REQUEST_BATCHED(1),
    COLLAPSER_BATCH(1);

    private final int type;

    private HystrixRollingNumberEvent(int type) {
        this.type = type;
    }

    public boolean isCounter() {
        return this.type == 1;
    }

    public boolean isMaxUpdater() {
        return this.type == 2;
    }

    public static HystrixRollingNumberEvent from(HystrixEventType eventType) {
        switch (eventType) {
            case BAD_REQUEST: {
                return BAD_REQUEST;
            }
            case COLLAPSED: {
                return COLLAPSED;
            }
            case EMIT: {
                return EMIT;
            }
            case EXCEPTION_THROWN: {
                return EXCEPTION_THROWN;
            }
            case FAILURE: {
                return FAILURE;
            }
            case FALLBACK_EMIT: {
                return FALLBACK_EMIT;
            }
            case FALLBACK_FAILURE: {
                return FALLBACK_FAILURE;
            }
            case FALLBACK_MISSING: {
                return FALLBACK_MISSING;
            }
            case FALLBACK_REJECTION: {
                return FALLBACK_REJECTION;
            }
            case FALLBACK_SUCCESS: {
                return FALLBACK_SUCCESS;
            }
            case RESPONSE_FROM_CACHE: {
                return RESPONSE_FROM_CACHE;
            }
            case SEMAPHORE_REJECTED: {
                return SEMAPHORE_REJECTED;
            }
            case SHORT_CIRCUITED: {
                return SHORT_CIRCUITED;
            }
            case SUCCESS: {
                return SUCCESS;
            }
            case THREAD_POOL_REJECTED: {
                return THREAD_POOL_REJECTED;
            }
            case TIMEOUT: {
                return TIMEOUT;
            }
        }
        throw new RuntimeException("Unknown HystrixEventType : " + (Object)((Object)eventType));
    }
}

