/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.metric;

import com.netflix.hystrix.ExecutionResult;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.metric.HystrixCommandEvent;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import java.util.ArrayList;

public class HystrixCommandCompletion
extends HystrixCommandEvent {
    protected final ExecutionResult executionResult;
    protected final HystrixRequestContext requestContext;
    private static final HystrixEventType[] ALL_EVENT_TYPES = HystrixEventType.values();

    HystrixCommandCompletion(ExecutionResult executionResult, HystrixCommandKey commandKey, HystrixThreadPoolKey threadPoolKey, HystrixRequestContext requestContext) {
        super(commandKey, threadPoolKey);
        this.executionResult = executionResult;
        this.requestContext = requestContext;
    }

    public static HystrixCommandCompletion from(ExecutionResult executionResult, HystrixCommandKey commandKey, HystrixThreadPoolKey threadPoolKey) {
        return HystrixCommandCompletion.from(executionResult, commandKey, threadPoolKey, HystrixRequestContext.getContextForCurrentThread());
    }

    public static HystrixCommandCompletion from(ExecutionResult executionResult, HystrixCommandKey commandKey, HystrixThreadPoolKey threadPoolKey, HystrixRequestContext requestContext) {
        return new HystrixCommandCompletion(executionResult, commandKey, threadPoolKey, requestContext);
    }

    @Override
    public boolean isResponseThreadPoolRejected() {
        return this.executionResult.isResponseThreadPoolRejected();
    }

    @Override
    public boolean isExecutionStart() {
        return false;
    }

    @Override
    public boolean isExecutedInThread() {
        return this.executionResult.isExecutedInThread();
    }

    @Override
    public boolean isCommandCompletion() {
        return true;
    }

    public HystrixRequestContext getRequestContext() {
        return this.requestContext;
    }

    public ExecutionResult.EventCounts getEventCounts() {
        return this.executionResult.getEventCounts();
    }

    public long getExecutionLatency() {
        return this.executionResult.getExecutionLatency();
    }

    public long getTotalLatency() {
        return this.executionResult.getUserThreadLatency();
    }

    @Override
    public boolean didCommandExecute() {
        return this.executionResult.executionOccurred();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        ArrayList<HystrixEventType> foundEventTypes = new ArrayList<HystrixEventType>();
        sb.append(this.getCommandKey().name()).append("[");
        for (HystrixEventType eventType : ALL_EVENT_TYPES) {
            if (!this.executionResult.getEventCounts().contains(eventType)) continue;
            foundEventTypes.add(eventType);
        }
        int i = 0;
        for (HystrixEventType eventType : foundEventTypes) {
            sb.append(eventType.name());
            int eventCount = this.executionResult.getEventCounts().getCount(eventType);
            if (eventCount > 1) {
                sb.append("x").append(eventCount);
            }
            if (i < foundEventTypes.size() - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append("][").append(this.getExecutionLatency()).append(" ms]");
        return sb.toString();
    }
}

