/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Constants {
    private static final Logger logger = LoggerFactory.getLogger(Constants.class);
    public static final Term.Raw NULL_LITERAL = new Term.Raw(){
        private final Term.Terminal NULL_VALUE = new Value(null){

            @Override
            public Term.Terminal bind(List<ByteBuffer> values) {
                return null;
            }
        };

        @Override
        public Term prepare(ColumnSpecification receiver) throws InvalidRequestException {
            if (!this.isAssignableTo(receiver)) {
                throw new InvalidRequestException("Invalid null value for counter increment/decrement");
            }
            return this.NULL_VALUE;
        }

        @Override
        public boolean isAssignableTo(ColumnSpecification receiver) {
            return !(receiver.type instanceof CounterColumnType);
        }

        public String toString() {
            return null;
        }
    };

    public static class Deleter
    extends Operation {
        private final boolean isCollection;

        public Deleter(ColumnIdentifier column, boolean isCollection) {
            super(column, null);
            this.isCollection = isCollection;
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, ColumnNameBuilder prefix, UpdateParameters params) throws InvalidRequestException {
            ColumnNameBuilder column = prefix.add(this.columnName.key);
            if (this.isCollection) {
                cf.addAtom(params.makeRangeTombstone(column.build(), column.buildAsEndOfRange()));
            } else {
                cf.addColumn(params.makeTombstone(column.build()));
            }
        }
    }

    public static class Substracter
    extends Operation {
        public Substracter(ColumnIdentifier column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, ColumnNameBuilder prefix, UpdateParameters params) throws InvalidRequestException {
            ByteBuffer bytes = this.t.bindAndGet(params.variables);
            if (bytes == null) {
                throw new InvalidRequestException("Invalid null value for counter increment");
            }
            long increment = ByteBufferUtil.toLong(bytes);
            if (increment == Long.MIN_VALUE) {
                throw new InvalidRequestException("The negation of " + increment + " overflows supported counter precision (signed 8 bytes integer)");
            }
            ByteBuffer cname = this.columnName == null ? prefix.build() : prefix.add(this.columnName.key).build();
            cf.addCounter(new QueryPath(cf.metadata().cfName, null, cname), -increment);
        }
    }

    public static class Adder
    extends Operation {
        public Adder(ColumnIdentifier column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, ColumnNameBuilder prefix, UpdateParameters params) throws InvalidRequestException {
            ByteBuffer bytes = this.t.bindAndGet(params.variables);
            if (bytes == null) {
                throw new InvalidRequestException("Invalid null value for counter increment");
            }
            long increment = ByteBufferUtil.toLong(bytes);
            ByteBuffer cname = this.columnName == null ? prefix.build() : prefix.add(this.columnName.key).build();
            cf.addCounter(new QueryPath(cf.metadata().cfName, null, cname), increment);
        }
    }

    public static class Setter
    extends Operation {
        public Setter(ColumnIdentifier column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, ColumnNameBuilder prefix, UpdateParameters params) throws InvalidRequestException {
            ByteBuffer cname = this.columnName == null ? prefix.build() : prefix.add(this.columnName.key).build();
            ByteBuffer value = this.t.bindAndGet(params.variables);
            cf.addColumn(value == null ? params.makeTombstone(cname) : params.makeColumn(cname, value));
        }
    }

    public static class Marker
    extends AbstractMarker {
        protected Marker(int bindIndex, ColumnSpecification receiver) {
            super(bindIndex, receiver);
            assert (!(receiver.type instanceof CollectionType));
        }

        @Override
        public ByteBuffer bindAndGet(List<ByteBuffer> values) throws InvalidRequestException {
            try {
                ByteBuffer value = values.get(this.bindIndex);
                if (value != null) {
                    this.receiver.type.validate(value);
                }
                return value;
            }
            catch (MarshalException e) {
                throw new InvalidRequestException(e.getMessage());
            }
        }

        @Override
        public Value bind(List<ByteBuffer> values) throws InvalidRequestException {
            ByteBuffer bytes = this.bindAndGet(values);
            return bytes == null ? null : new Value(bytes);
        }
    }

    public static class Value
    extends Term.Terminal {
        public final ByteBuffer bytes;

        public Value(ByteBuffer bytes) {
            this.bytes = bytes;
        }

        @Override
        public ByteBuffer get() {
            return this.bytes;
        }

        @Override
        public ByteBuffer bindAndGet(List<ByteBuffer> values) {
            return this.bytes;
        }
    }

    public static class Literal
    implements Term.Raw {
        private final Type type;
        private final String text;
        private static volatile boolean stringAsBlobWarningLogged = false;

        private Literal(Type type, String text) {
            assert (type != null && text != null);
            this.type = type;
            this.text = text;
        }

        public static Literal string(String text) {
            return new Literal(Type.STRING, text);
        }

        public static Literal integer(String text) {
            return new Literal(Type.INTEGER, text);
        }

        public static Literal floatingPoint(String text) {
            return new Literal(Type.FLOAT, text);
        }

        public static Literal uuid(String text) {
            return new Literal(Type.UUID, text);
        }

        public static Literal bool(String text) {
            return new Literal(Type.BOOLEAN, text);
        }

        public static Literal hex(String text) {
            return new Literal(Type.HEX, text);
        }

        @Override
        public Value prepare(ColumnSpecification receiver) throws InvalidRequestException {
            if (!this.isAssignableTo(receiver)) {
                throw new InvalidRequestException(String.format("Invalid %s constant (%s) for %s of type %s", new Object[]{this.type, this.text, receiver, receiver.type.asCQL3Type()}));
            }
            return new Value(this.parsedValue(receiver.type));
        }

        private ByteBuffer parsedValue(AbstractType<?> validator) throws InvalidRequestException {
            if (validator instanceof ReversedType) {
                validator = ((ReversedType)validator).baseType;
            }
            try {
                if (this.type == Type.HEX && validator instanceof BytesType) {
                    return validator.fromString(this.text.substring(2));
                }
                if (validator instanceof CounterColumnType) {
                    return LongType.instance.fromString(this.text);
                }
                return validator.fromString(this.text);
            }
            catch (MarshalException e) {
                throw new InvalidRequestException(e.getMessage());
            }
        }

        public String getRawText() {
            return this.text;
        }

        @Override
        public boolean isAssignableTo(ColumnSpecification receiver) {
            CQL3Type receiverType = receiver.type.asCQL3Type();
            if (receiverType.isCollection()) {
                return false;
            }
            if (!(receiverType instanceof CQL3Type.Native)) {
                return true;
            }
            CQL3Type.Native nt = (CQL3Type.Native)receiverType;
            switch (this.type) {
                case STRING: {
                    switch (nt) {
                        case ASCII: 
                        case TEXT: 
                        case INET: 
                        case VARCHAR: 
                        case TIMESTAMP: {
                            return true;
                        }
                        case BLOB: {
                            if (!stringAsBlobWarningLogged) {
                                stringAsBlobWarningLogged = true;
                                logger.warn("Inputing CLQ3 blobs as strings (like {} = '{}') is now deprecated and will be removed in a future version. You should convert client code to use a blob constant ({} = {}) instead (see http://cassandra.apache.org/doc/cql3/CQL.html changelog section for more info).", new Object[]{receiver, this.text, receiver, "0x" + this.text});
                            }
                            return true;
                        }
                    }
                    return false;
                }
                case INTEGER: {
                    switch (nt) {
                        case TIMESTAMP: 
                        case BIGINT: 
                        case COUNTER: 
                        case DECIMAL: 
                        case DOUBLE: 
                        case FLOAT: 
                        case INT: 
                        case VARINT: {
                            return true;
                        }
                    }
                    return false;
                }
                case UUID: {
                    switch (nt) {
                        case UUID: 
                        case TIMEUUID: {
                            return true;
                        }
                    }
                    return false;
                }
                case FLOAT: {
                    switch (nt) {
                        case DECIMAL: 
                        case DOUBLE: 
                        case FLOAT: {
                            return true;
                        }
                    }
                    return false;
                }
                case BOOLEAN: {
                    switch (nt) {
                        case BOOLEAN: {
                            return true;
                        }
                    }
                    return false;
                }
                case HEX: {
                    switch (nt) {
                        case BLOB: {
                            return true;
                        }
                    }
                    return false;
                }
            }
            return false;
        }

        public String toString() {
            return this.type == Type.STRING ? String.format("'%s'", this.text) : this.text;
        }
    }

    public static enum Type {
        STRING,
        INTEGER,
        UUID,
        FLOAT,
        BOOLEAN,
        HEX;

    }
}

