/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.UUIDGen;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class QueryMessage
extends Message.Request {
    public static final Message.Codec<QueryMessage> codec = new Message.Codec<QueryMessage>(){

        @Override
        public QueryMessage decode(ChannelBuffer body) {
            String query = CBUtil.readLongString(body);
            ConsistencyLevel consistency = CBUtil.readConsistencyLevel(body);
            return new QueryMessage(query, consistency);
        }

        @Override
        public ChannelBuffer encode(QueryMessage msg) {
            return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{CBUtil.longStringToCB(msg.query), CBUtil.consistencyLevelToCB(msg.consistency)});
        }
    };
    public final String query;
    public final ConsistencyLevel consistency;

    public QueryMessage(String query, ConsistencyLevel consistency) {
        super(Message.Type.QUERY);
        this.query = query;
        this.consistency = consistency;
    }

    @Override
    public ChannelBuffer encode() {
        return codec.encode(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message.Response execute(QueryState state) {
        try {
            UUID tracingId = null;
            if (this.isTracingRequested()) {
                tracingId = UUIDGen.getTimeUUID();
                state.prepareTracingSession(tracingId);
            }
            if (state.traceNextQuery()) {
                state.createTracingSession();
                Tracing.instance().begin("Execute CQL3 query", (Map<String, String>)ImmutableMap.of((Object)"query", (Object)this.query));
            }
            ResultMessage response = QueryProcessor.process(this.query, this.consistency, state);
            if (tracingId != null) {
                response.setTracingId(tracingId);
            }
            ResultMessage resultMessage = response;
            return resultMessage;
        }
        catch (Exception e) {
            if (!(e instanceof RequestValidationException) && !(e instanceof RequestExecutionException)) {
                logger.error("Unexpected error during query", (Throwable)e);
            }
            ErrorMessage errorMessage = ErrorMessage.fromException(e);
            return errorMessage;
        }
        finally {
            Tracing.instance().stopSession();
        }
    }

    public String toString() {
        return "QUERY " + this.query;
    }
}

