/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.PeekingIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Hex;

public class MerkleTree
implements Serializable {
    public static final MerkleTreeSerializer serializer = new MerkleTreeSerializer();
    private static final long serialVersionUID = 2L;
    public static final byte RECOMMENDED_DEPTH = 126;
    public static final int CONSISTENT = 0;
    public static final int FULLY_INCONSISTENT = 1;
    public static final int PARTIALLY_INCONSISTENT = 2;
    public final byte hashdepth;
    public transient Range<Token> fullRange;
    private transient IPartitioner partitioner;
    private long maxsize;
    private long size;
    private Hashable root;

    public MerkleTree(IPartitioner partitioner, Range<Token> range, byte hashdepth, long maxsize) {
        assert (hashdepth < 127);
        this.fullRange = range;
        this.partitioner = partitioner;
        this.hashdepth = hashdepth;
        this.maxsize = maxsize;
        this.size = 1L;
        this.root = new Leaf(null);
    }

    static byte inc(byte in) {
        assert (in < 127);
        return (byte)(in + 1);
    }

    public void init() {
        byte sizedepth = (byte)(Math.log10(this.maxsize) / Math.log10(2.0));
        byte depth = (byte)Math.min(sizedepth, this.hashdepth);
        this.root = this.initHelper((Token)this.fullRange.left, (Token)this.fullRange.right, (byte)0, depth);
        this.size = (long)Math.pow(2.0, depth);
    }

    private Hashable initHelper(Token left, Token right, byte depth, byte max) {
        if (depth == max) {
            return new Leaf();
        }
        Token midpoint = this.partitioner.midpoint(left, right);
        if (midpoint.equals(left) || midpoint.equals(right)) {
            return new Leaf();
        }
        Hashable lchild = this.initHelper(left, midpoint, MerkleTree.inc(depth), max);
        Hashable rchild = this.initHelper(midpoint, right, MerkleTree.inc(depth), max);
        return new Inner(midpoint, lchild, rchild);
    }

    Hashable root() {
        return this.root;
    }

    public IPartitioner partitioner() {
        return this.partitioner;
    }

    public long size() {
        return this.size;
    }

    public long maxsize() {
        return this.maxsize;
    }

    public void maxsize(long maxsize) {
        this.maxsize = maxsize;
    }

    public void partitioner(IPartitioner partitioner) {
        this.partitioner = partitioner;
    }

    public static List<TreeRange> difference(MerkleTree ltree, MerkleTree rtree) {
        if (!ltree.fullRange.equals(rtree.fullRange)) {
            throw new IllegalArgumentException("Difference only make sense on tree covering the same range (but " + ltree.fullRange + " != " + rtree.fullRange + ")");
        }
        ArrayList<TreeRange> diff = new ArrayList<TreeRange>();
        TreeRange active = new TreeRange(null, (Token)ltree.fullRange.left, (Token)ltree.fullRange.right, 0, null);
        byte[] lhash = ltree.hash(active);
        byte[] rhash = rtree.hash(active);
        if (lhash != null && rhash != null && !Arrays.equals(lhash, rhash)) {
            if (1 == MerkleTree.differenceHelper(ltree, rtree, diff, active)) {
                diff.add(active);
            }
        } else if (lhash == null || rhash == null) {
            diff.add(active);
        }
        return diff;
    }

    static int differenceHelper(MerkleTree ltree, MerkleTree rtree, List<TreeRange> diff, TreeRange active) {
        boolean rreso;
        boolean lreso;
        if (active.depth == 127) {
            return 0;
        }
        Token midpoint = ltree.partitioner().midpoint((Token)active.left, (Token)active.right);
        TreeRange left = new TreeRange(null, (Token)active.left, midpoint, MerkleTree.inc(active.depth), null);
        TreeRange right = new TreeRange(null, midpoint, (Token)active.right, MerkleTree.inc(active.depth), null);
        byte[] lhash = ltree.hash(left);
        byte[] rhash = rtree.hash(left);
        int ldiff = 0;
        boolean bl = lreso = lhash != null && rhash != null;
        if (lreso && !Arrays.equals(lhash, rhash)) {
            ldiff = MerkleTree.differenceHelper(ltree, rtree, diff, left);
        } else if (!lreso) {
            ldiff = 1;
        }
        lhash = ltree.hash(right);
        rhash = rtree.hash(right);
        int rdiff = 0;
        boolean bl2 = rreso = lhash != null && rhash != null;
        if (rreso && !Arrays.equals(lhash, rhash)) {
            rdiff = MerkleTree.differenceHelper(ltree, rtree, diff, right);
        } else if (!rreso) {
            rdiff = 1;
        }
        if (ldiff == 1 && rdiff == 1) {
            return 1;
        }
        if (ldiff == 1) {
            diff.add(left);
            return 2;
        }
        if (rdiff == 1) {
            diff.add(right);
            return 2;
        }
        return 2;
    }

    public TreeRange get(Token t) {
        return this.getHelper(this.root, (Token)this.fullRange.left, (Token)this.fullRange.right, (byte)0, t);
    }

    TreeRange getHelper(Hashable hashable, Token pleft, Token pright, byte depth, Token t) {
        if (hashable instanceof Leaf) {
            return new TreeRange(this, pleft, pright, depth, hashable);
        }
        Inner node = (Inner)hashable;
        if (Range.contains(pleft, node.token, t)) {
            return this.getHelper(node.lchild, pleft, node.token, MerkleTree.inc(depth), t);
        }
        return this.getHelper(node.rchild, node.token, pright, MerkleTree.inc(depth), t);
    }

    public void invalidate(Token t) {
        this.invalidateHelper(this.root, (Token)this.fullRange.left, t);
    }

    private void invalidateHelper(Hashable hashable, Token pleft, Token t) {
        hashable.hash(null);
        if (hashable instanceof Leaf) {
            return;
        }
        Inner node = (Inner)hashable;
        if (Range.contains(pleft, node.token, t)) {
            this.invalidateHelper(node.lchild, pleft, t);
        } else {
            this.invalidateHelper(node.rchild, node.token, t);
        }
    }

    public byte[] hash(Range<Token> range) {
        try {
            return this.hashHelper(this.root, new Range<RingPosition>(this.fullRange.left, this.fullRange.right), range);
        }
        catch (StopRecursion e) {
            return null;
        }
    }

    private byte[] hashHelper(Hashable hashable, Range<Token> active, Range<Token> range) throws StopRecursion {
        if (hashable instanceof Leaf) {
            if (!range.contains((Token)((Object)active))) {
                throw new StopRecursion.BadRange();
            }
            return hashable.hash();
        }
        Inner node = (Inner)hashable;
        Range<Token> leftactive = new Range<Token>((Token)active.left, node.token);
        Range<RingPosition> rightactive = new Range<RingPosition>(node.token, active.right);
        if (range.contains((Token)((Object)active))) {
            if (node.hash() != null) {
                return node.hash();
            }
            byte[] lhash = this.hashHelper(node.lchild(), leftactive, range);
            byte[] rhash = this.hashHelper(node.rchild(), rightactive, range);
            node.hash(lhash, rhash);
            return node.hash();
        }
        if (leftactive.contains((Token)((Object)range))) {
            return this.hashHelper(node.lchild, leftactive, range);
        }
        if (rightactive.contains((RingPosition)((Object)range))) {
            return this.hashHelper(node.rchild, rightactive, range);
        }
        throw new StopRecursion.BadRange();
    }

    public boolean split(Token t) {
        if (this.size >= this.maxsize) {
            return false;
        }
        try {
            this.root = this.splitHelper(this.root, (Token)this.fullRange.left, (Token)this.fullRange.right, (byte)0, t);
        }
        catch (StopRecursion.TooDeep e) {
            return false;
        }
        return true;
    }

    private Hashable splitHelper(Hashable hashable, Token pleft, Token pright, byte depth, Token t) throws StopRecursion.TooDeep {
        if (depth >= this.hashdepth) {
            throw new StopRecursion.TooDeep();
        }
        if (hashable instanceof Leaf) {
            Token midpoint = this.partitioner.midpoint(pleft, pright);
            if (midpoint.equals(pleft) || midpoint.equals(pright)) {
                throw new StopRecursion.TooDeep();
            }
            ++this.size;
            return new Inner(midpoint, new Leaf(), new Leaf());
        }
        Inner node = (Inner)hashable;
        if (Range.contains(pleft, node.token, t)) {
            node.lchild(this.splitHelper(node.lchild, pleft, node.token, MerkleTree.inc(depth), t));
        } else {
            node.rchild(this.splitHelper(node.rchild, node.token, pright, MerkleTree.inc(depth), t));
        }
        return node;
    }

    public TreeRangeIterator invalids() {
        return new TreeRangeIterator(this);
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("#<MerkleTree root=");
        this.root.toString(buff, 8);
        buff.append(">");
        return buff.toString();
    }

    static abstract class StopRecursion
    extends Exception {
        StopRecursion() {
        }

        static class TooDeep
        extends StopRecursion {
        }

        static class InvalidHash
        extends StopRecursion {
        }

        static class BadRange
        extends StopRecursion {
        }
    }

    static abstract class Hashable
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final IVersionedSerializer<Hashable> serializer = new HashableSerializer();
        protected byte[] hash;

        protected Hashable(byte[] hash) {
            this.hash = hash;
        }

        public byte[] hash() {
            return this.hash;
        }

        void hash(byte[] hash) {
            this.hash = hash;
        }

        void hash(byte[] lefthash, byte[] righthash) {
            this.hash = Hashable.binaryHash(lefthash, righthash);
        }

        void addHash(byte[] righthash) {
            this.hash = this.hash == null ? righthash : Hashable.binaryHash(this.hash, righthash);
        }

        static byte[] binaryHash(byte[] left, byte[] right) {
            return FBUtilities.xor(left, right);
        }

        public abstract void toString(StringBuilder var1, int var2);

        public static String toString(byte[] hash) {
            if (hash == null) {
                return "null";
            }
            return "[" + Hex.bytesToHex(hash) + "]";
        }

        private static class HashableSerializer
        implements IVersionedSerializer<Hashable> {
            private HashableSerializer() {
            }

            @Override
            public void serialize(Hashable h, DataOutput dos, int version) throws IOException {
                if (h instanceof Inner) {
                    dos.writeByte(2);
                    Inner.serializer.serialize((Inner)h, dos, version);
                } else if (h instanceof Leaf) {
                    dos.writeByte(1);
                    Leaf.serializer.serialize((Leaf)h, dos, version);
                } else {
                    throw new IOException("Unexpected Hashable: " + h.getClass().getCanonicalName());
                }
            }

            @Override
            public Hashable deserialize(DataInput dis, int version) throws IOException {
                byte ident = dis.readByte();
                if (2 == ident) {
                    return Inner.serializer.deserialize(dis, version);
                }
                if (1 == ident) {
                    return Leaf.serializer.deserialize(dis, version);
                }
                throw new IOException("Unexpected Hashable: " + ident);
            }

            @Override
            public long serializedSize(Hashable h, int version) {
                if (h instanceof Inner) {
                    return 1L + Inner.serializer.serializedSize((Inner)h, version);
                }
                if (h instanceof Leaf) {
                    return 1L + Leaf.serializer.serializedSize((Leaf)h, version);
                }
                throw new AssertionError(h.getClass());
            }
        }
    }

    public static class RowHash {
        public final Token token;
        public final byte[] hash;

        public RowHash(Token token, byte[] hash) {
            this.token = token;
            this.hash = hash;
        }

        public String toString() {
            return "#<RowHash " + this.token + " " + Hashable.toString(this.hash) + ">";
        }
    }

    static class Leaf
    extends Hashable {
        public static final long serialVersionUID = 1L;
        static final byte IDENT = 1;
        private static final LeafSerializer serializer = new LeafSerializer();

        public Leaf() {
            super(null);
        }

        public Leaf(byte[] hash) {
            super(hash);
        }

        public Leaf(byte[] lefthash, byte[] righthash) {
            super(Hashable.binaryHash(lefthash, righthash));
        }

        @Override
        public void toString(StringBuilder buff, int maxdepth) {
            buff.append(this.toString());
        }

        public String toString() {
            return "#<Leaf " + Hashable.toString(this.hash()) + ">";
        }

        private static class LeafSerializer
        implements IVersionedSerializer<Leaf> {
            private LeafSerializer() {
            }

            @Override
            public void serialize(Leaf leaf, DataOutput dos, int version) throws IOException {
                if (leaf.hash == null) {
                    dos.writeInt(-1);
                } else {
                    dos.writeInt(leaf.hash.length);
                    dos.write(leaf.hash);
                }
            }

            @Override
            public Leaf deserialize(DataInput dis, int version) throws IOException {
                byte[] hash;
                int hashLen = dis.readInt();
                byte[] byArray = hash = hashLen < 0 ? null : new byte[hashLen];
                if (hash != null) {
                    dis.readFully(hash);
                }
                return new Leaf(hash);
            }

            @Override
            public long serializedSize(Leaf leaf, int version) {
                return leaf.hash == null ? (long)TypeSizes.NATIVE.sizeof(-1) : (long)(TypeSizes.NATIVE.sizeof(leaf.hash().length) + leaf.hash().length);
            }
        }
    }

    static class Inner
    extends Hashable {
        public static final long serialVersionUID = 1L;
        static final byte IDENT = 2;
        public final Token token;
        private Hashable lchild;
        private Hashable rchild;
        private static final InnerSerializer serializer = new InnerSerializer();

        public Inner(Token token, Hashable lchild, Hashable rchild) {
            super(null);
            this.token = token;
            this.lchild = lchild;
            this.rchild = rchild;
        }

        public Hashable lchild() {
            return this.lchild;
        }

        public Hashable rchild() {
            return this.rchild;
        }

        public void lchild(Hashable child) {
            this.lchild = child;
        }

        public void rchild(Hashable child) {
            this.rchild = child;
        }

        @Override
        public void toString(StringBuilder buff, int maxdepth) {
            buff.append("#<").append(this.getClass().getSimpleName());
            buff.append(" ").append(this.token);
            buff.append(" hash=").append(Hashable.toString(this.hash()));
            buff.append(" children=[");
            if (maxdepth < 1) {
                buff.append("#");
            } else {
                if (this.lchild == null) {
                    buff.append("null");
                } else {
                    this.lchild.toString(buff, maxdepth - 1);
                }
                buff.append(" ");
                if (this.rchild == null) {
                    buff.append("null");
                } else {
                    this.rchild.toString(buff, maxdepth - 1);
                }
            }
            buff.append("]>");
        }

        public String toString() {
            StringBuilder buff = new StringBuilder();
            this.toString(buff, 1);
            return buff.toString();
        }

        private static class InnerSerializer
        implements IVersionedSerializer<Inner> {
            private InnerSerializer() {
            }

            @Override
            public void serialize(Inner inner, DataOutput dos, int version) throws IOException {
                if (inner.hash == null) {
                    dos.writeInt(-1);
                } else {
                    dos.writeInt(inner.hash.length);
                    dos.write(inner.hash);
                }
                Token.serializer.serialize(inner.token, dos);
                Hashable.serializer.serialize(inner.lchild, dos, version);
                Hashable.serializer.serialize(inner.rchild, dos, version);
            }

            @Override
            public Inner deserialize(DataInput dis, int version) throws IOException {
                byte[] hash;
                int hashLen = dis.readInt();
                byte[] byArray = hash = hashLen >= 0 ? new byte[hashLen] : null;
                if (hash != null) {
                    dis.readFully(hash);
                }
                Token token = Token.serializer.deserialize(dis);
                Hashable lchild = (Hashable)Hashable.serializer.deserialize(dis, version);
                Hashable rchild = (Hashable)Hashable.serializer.deserialize(dis, version);
                return new Inner(token, lchild, rchild);
            }

            @Override
            public long serializedSize(Inner inner, int version) {
                int size = inner.hash == null ? TypeSizes.NATIVE.sizeof(-1) : TypeSizes.NATIVE.sizeof(inner.hash().length) + inner.hash().length;
                size = (int)((long)size + (Token.serializer.serializedSize(inner.token, TypeSizes.NATIVE) + Hashable.serializer.serializedSize(inner.lchild, version) + Hashable.serializer.serializedSize(inner.rchild, version)));
                return size;
            }
        }
    }

    public static class TreeRangeIterator
    extends AbstractIterator<TreeRange>
    implements Iterable<TreeRange>,
    PeekingIterator<TreeRange> {
        private final ArrayDeque<TreeRange> tovisit = new ArrayDeque();
        private final MerkleTree tree;

        TreeRangeIterator(MerkleTree tree) {
            this.tovisit.add(new TreeRange(tree, (Token)tree.fullRange.left, (Token)tree.fullRange.right, 0, tree.root));
            this.tree = tree;
        }

        public TreeRange computeNext() {
            while (!this.tovisit.isEmpty()) {
                TreeRange active = this.tovisit.pop();
                if (active.hashable instanceof Leaf) {
                    if (active.isWrapAround() && !this.tovisit.isEmpty()) {
                        this.tovisit.addLast(active);
                    }
                    return active;
                }
                Inner node = (Inner)active.hashable;
                TreeRange left = new TreeRange(this.tree, (Token)active.left, node.token, MerkleTree.inc(active.depth), node.lchild);
                TreeRange right = new TreeRange(this.tree, node.token, (Token)active.right, MerkleTree.inc(active.depth), node.rchild);
                if (right.isWrapAround()) {
                    this.tovisit.addLast(left);
                    this.tovisit.addFirst(right);
                    continue;
                }
                this.tovisit.addFirst(right);
                this.tovisit.addFirst(left);
            }
            return (TreeRange)this.endOfData();
        }

        @Override
        public Iterator<TreeRange> iterator() {
            return this;
        }
    }

    public static class TreeRange
    extends Range<Token> {
        public static final long serialVersionUID = 1L;
        private final MerkleTree tree;
        public final byte depth;
        private final Hashable hashable;

        TreeRange(MerkleTree tree, Token left, Token right, byte depth, Hashable hashable) {
            super(left, right);
            this.tree = tree;
            this.depth = depth;
            this.hashable = hashable;
        }

        public void hash(byte[] hash) {
            assert (this.tree != null) : "Not intended for modification!";
            this.hashable.hash(hash);
        }

        public byte[] hash() {
            return this.hashable.hash();
        }

        public void addHash(RowHash entry) {
            assert (this.tree != null) : "Not intended for modification!";
            assert (this.hashable instanceof Leaf);
            this.hashable.addHash(entry.hash);
        }

        public void addAll(Iterator<RowHash> entries) {
            while (entries.hasNext()) {
                this.addHash(entries.next());
            }
        }

        @Override
        public String toString() {
            StringBuilder buff = new StringBuilder("#<TreeRange ");
            buff.append(super.toString()).append(" depth=").append(this.depth);
            return buff.append(">").toString();
        }
    }

    public static class MerkleTreeSerializer
    implements IVersionedSerializer<MerkleTree> {
        @Override
        public void serialize(MerkleTree mt, DataOutput dos, int version) throws IOException {
            dos.writeByte(mt.hashdepth);
            dos.writeLong(mt.maxsize);
            dos.writeLong(mt.size);
            Hashable.serializer.serialize(mt.root, dos, version);
        }

        @Override
        public MerkleTree deserialize(DataInput dis, int version) throws IOException {
            byte hashdepth = dis.readByte();
            long maxsize = dis.readLong();
            long size = dis.readLong();
            MerkleTree mt = new MerkleTree(null, null, hashdepth, maxsize);
            mt.size = size;
            mt.root = (Hashable)Hashable.serializer.deserialize(dis, version);
            return mt;
        }

        @Override
        public long serializedSize(MerkleTree mt, int version) {
            return (long)(1 + TypeSizes.NATIVE.sizeof(mt.maxsize) + TypeSizes.NATIVE.sizeof(mt.size)) + Hashable.serializer.serializedSize(mt.root, version);
        }
    }
}

