/*
 * Decompiled with CFR 0.152.
 */
package org.immutant.daemons;

import org.immutant.daemons.DaemonMBean;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class Daemon
implements DaemonMBean,
Service<Daemon> {
    private int THREAD_TIMEOUT = 20000;
    private Thread thread;
    private String name;
    private ClassLoader classLoader;
    private Runnable startFunction;
    private Runnable stopFunction;
    static final Logger log = Logger.getLogger((String)"immutant.daemons");

    public Daemon(String name, ClassLoader loader, Runnable startFunction, Runnable stopFunction) {
        this.name = name;
        this.classLoader = loader;
        this.startFunction = startFunction;
        this.stopFunction = stopFunction;
    }

    @Override
    public void start() {
        log.info((Object)("Starting daemon: " + this.name));
        this.thread = new Thread(this.startFunction);
        this.thread.setContextClassLoader(this.classLoader);
        this.thread.start();
    }

    @Override
    public void stop() {
        if (this.isStarted() && this.stopFunction != null) {
            log.info((Object)("Stopping daemon: " + this.name));
            this.stopFunction.run();
            try {
                this.thread.join(this.THREAD_TIMEOUT);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.thread.isAlive()) {
                log.warn((Object)"Timed out waiting for daemon thread to die");
            }
            this.thread = null;
        }
    }

    public Daemon getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(final StartContext context) throws StartException {
        context.asynchronous();
        context.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Daemon.this.start();
                    context.complete();
                }
                catch (Exception e) {
                    context.failed(new StartException((Throwable)e));
                }
            }
        });
    }

    public void stop(StopContext context) {
        this.stop();
    }

    @Override
    public boolean isStarted() {
        return this.thread != null;
    }

    public void setStartFunction(Runnable startFunction) {
        this.startFunction = startFunction;
    }

    public void setStopFunction(Runnable stopFunction) {
        this.stopFunction = stopFunction;
    }
}

