/*
 * Decompiled with CFR 0.152.
 */
package org.immutant.jobs;

import java.util.Date;
import java.util.concurrent.Callable;
import org.immutant.core.HasImmutantRuntimeInjector;
import org.immutant.core.as.CoreServices;
import org.immutant.jobs.AtJob;
import org.immutant.jobs.JobScheduler;
import org.immutant.jobs.ScheduledJob;
import org.immutant.jobs.as.JobsServices;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.projectodd.polyglot.core.AtRuntimeInstaller;
import org.projectodd.polyglot.jobs.BaseJob;

public class JobSchedulizer
extends AtRuntimeInstaller<JobSchedulizer> {
    private static final Logger log = Logger.getLogger((String)"org.immutant.jobs");

    public JobSchedulizer(DeploymentUnit unit) {
        super(unit);
    }

    public JobScheduler createScheduler(boolean singleton) {
        String name = "JobScheduler$" + this.getUnit().getName();
        if (singleton) {
            name = name + ":singleton";
        }
        JobScheduler scheduler = new JobScheduler(name);
        ServiceName serviceName = JobsServices.scheduler(this.getUnit(), singleton);
        this.deploy(serviceName, (Service)scheduler, singleton);
        return scheduler;
    }

    public ScheduledJob createJob(Callable handler, String name, String cronExpression, boolean singleton) {
        ScheduledJob job = new ScheduledJob(handler, this.getUnit().getName(), name, cronExpression, singleton);
        this.installJob((BaseJob)job);
        return job;
    }

    public AtJob createAtJob(Callable handler, String name, Date startAt, Date endAt, long interval, int repeat, boolean singleton) {
        AtJob job = new AtJob(handler, this.getUnit().getName(), name, singleton);
        job.setStartAt(startAt);
        job.setEndAt(endAt);
        job.setInterval(interval);
        job.setRepeat(repeat);
        this.installJob((BaseJob)job);
        return job;
    }

    private void installJob(final BaseJob job) {
        final ServiceName serviceName = JobsServices.job(this.getUnit(), job.getName());
        this.replaceService(serviceName, new Runnable(){

            @Override
            public void run() {
                ServiceBuilder builder = JobSchedulizer.this.build(serviceName, (Service)job, false);
                builder.addDependency(CoreServices.runtime((DeploymentUnit)JobSchedulizer.this.getUnit()), ((HasImmutantRuntimeInjector)job).getClojureRuntimeInjector()).addDependency(JobsServices.scheduler(JobSchedulizer.this.getUnit(), job.isSingleton()), job.getJobSchedulerInjector()).install();
            }
        });
        this.installMBean(serviceName, "immutant.jobs", job);
    }
}

