/*
 * Decompiled with CFR 0.152.
 */
package org.immutant.jobs;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.immutant.jobs.ClojureJob;
import org.jboss.logging.Logger;
import org.projectodd.polyglot.jobs.BaseJobScheduler;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.simpl.SimpleJobFactory;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;

public class JobScheduler
extends BaseJobScheduler
implements JobFactory {
    private Map<JobKey, ClojureJob> jobs = new HashMap<JobKey, ClojureJob>();
    private SimpleJobFactory fallback = new SimpleJobFactory();
    private static final Logger log = Logger.getLogger((String)"org.immutant.jobs");

    public JobScheduler(String name) {
        super(name);
    }

    public void start() throws IOException, SchedulerException {
        this.setJobFactory(this);
        super.start();
    }

    public Job newJob(TriggerFiredBundle bundle, Scheduler ignored) throws SchedulerException {
        JobDetail jobDetail = bundle.getJobDetail();
        Job result = this.jobs.get(jobDetail.getKey());
        return result == null ? this.fallback.newJob(bundle, ignored) : result;
    }

    public void addJob(String jobName, String groupName, ClojureJob job) {
        this.jobs.put(JobKey.jobKey((String)jobName, (String)groupName), job);
    }
}

