/*
 * Decompiled with CFR 0.152.
 */
package org.immutant.jobs;

import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import org.immutant.core.HasImmutantRuntimeInjector;
import org.immutant.core.as.CoreServices;
import org.immutant.jobs.AtJob;
import org.immutant.jobs.JobScheduler;
import org.immutant.jobs.ScheduledJob;
import org.immutant.jobs.as.JobsServices;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.projectodd.polyglot.core.AtRuntimeInstaller;
import org.projectodd.polyglot.hasingleton.CoordinationMapService;
import org.projectodd.polyglot.hasingleton.HASingletonInstaller;
import org.projectodd.polyglot.jobs.BaseAtJob;
import org.projectodd.polyglot.jobs.BaseJob;

public class JobSchedulizer
extends AtRuntimeInstaller<JobSchedulizer> {
    private static final Logger log = Logger.getLogger((String)"org.immutant.jobs");

    public JobSchedulizer(DeploymentUnit unit) {
        super(unit);
    }

    public synchronized JobScheduler activateScheduler() {
        ServiceController controller = this.getSchedulerController();
        if (controller.getMode() != ServiceController.Mode.ACTIVE) {
            controller.setMode(ServiceController.Mode.ACTIVE);
        }
        return (JobScheduler)((Object)controller.getValue());
    }

    public boolean schedulerIsActive() {
        return this.getSchedulerController().getMode() == ServiceController.Mode.ACTIVE;
    }

    public ScheduledJob createJob(Callable handler, String name, String cronExpression, boolean singleton) {
        ScheduledJob job = new ScheduledJob(handler, this.getUnit().getName(), name, cronExpression, singleton);
        this.installJob((BaseJob)job);
        return job;
    }

    public AtJob createAtJob(Callable handler, String name, Date startAt, Date endAt, long interval, int repeat, boolean singleton) {
        AtJob job = new AtJob(handler, this.getUnit().getName(), name, singleton);
        job.setStartAt(startAt);
        job.setEndAt(endAt);
        job.setInterval(interval);
        job.setRepeat(repeat);
        this.installJob((BaseJob)job);
        return job;
    }

    public ServiceController getSchedulerController() {
        return this.getUnit().getServiceRegistry().getService(JobsServices.scheduler(this.getUnit()));
    }

    private void installJob(final BaseJob job) {
        this.activateScheduler();
        final ServiceName serviceName = JobsServices.job(this.getUnit(), job.getName());
        this.replaceService(serviceName, new Runnable(){

            @Override
            public void run() {
                String haName = "job-" + job.getName();
                HASingletonInstaller.deployOnce((DeploymentUnit)JobSchedulizer.this.getUnit(), (ServiceTarget)JobSchedulizer.this.getTarget(), (String)haName);
                ServiceBuilder builder = JobSchedulizer.this.build(serviceName, (Service)job, job.isSingleton(), haName);
                builder.addDependency(CoreServices.runtime((DeploymentUnit)JobSchedulizer.this.getUnit()), ((HasImmutantRuntimeInjector)job).getClojureRuntimeInjector()).addDependency(JobsServices.scheduler(JobSchedulizer.this.getUnit()), job.getJobSchedulerInjector());
                if (JobSchedulizer.this.inCluster() && job instanceof BaseAtJob && job.isSingleton()) {
                    builder.addDependency(CoordinationMapService.serviceName((DeploymentUnit)JobSchedulizer.this.getUnit()), ConcurrentMap.class, ((BaseAtJob)job).getCoordinationMapInjector());
                }
                builder.install();
            }
        });
        this.installMBeanFor(serviceName, "immutant.jobs", job);
    }
}

