/*
 * Decompiled with CFR 0.152.
 */
package org.immutant.messaging;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.immutant.core.HasImmutantRuntimeInjector;
import org.immutant.core.SimpleServiceStateListener;
import org.immutant.messaging.MessageProcessorGroupizer;
import org.immutant.runtime.ClojureRuntime;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.projectodd.polyglot.core.AtRuntimeInstaller;
import org.projectodd.polyglot.messaging.destinations.DestinationUtils;
import org.projectodd.polyglot.messaging.destinations.Destroyable;
import org.projectodd.polyglot.messaging.destinations.DestroyableJMSQueueService;
import org.projectodd.polyglot.messaging.destinations.DestroyableJMSTopicService;
import org.projectodd.polyglot.messaging.destinations.processors.QueueInstaller;
import org.projectodd.polyglot.messaging.destinations.processors.TopicInstaller;

public class Destinationizer
extends AtRuntimeInstaller<Destinationizer>
implements HasImmutantRuntimeInjector {
    private final InjectedValue<ClojureRuntime> clojureRuntimeInjector = new InjectedValue();
    private final InjectedValue<MessageProcessorGroupizer> messageProcessorGroupizerInjector = new InjectedValue();
    private Map<String, ServiceName> destinations = new HashMap<String, ServiceName>();
    static final Logger log = Logger.getLogger((String)"org.immutant.messaging");

    public Destinationizer(DeploymentUnit unit, ServiceTarget globalServiceTarget) {
        super(unit, globalServiceTarget);
    }

    public boolean createQueue(String queueName, boolean durable, String selector, Object callback) {
        if (DestinationUtils.destinationPointerExists((DeploymentUnit)this.getUnit(), (String)queueName)) {
            return false;
        }
        DestroyableJMSQueueService queue = QueueInstaller.deployGlobalQueue((ServiceRegistry)this.getUnit().getServiceRegistry(), (ServiceTarget)this.getGlobalTarget(), (String)queueName, (boolean)durable, (String)selector, (String[])DestinationUtils.jndiNames((String)queueName, (boolean)false));
        this.createDestinationService(queueName, callback, QueueInstaller.queueServiceName((String)queueName), queue.getReferenceCount());
        return true;
    }

    public boolean createTopic(String topicName, Object callback) {
        if (DestinationUtils.destinationPointerExists((DeploymentUnit)this.getUnit(), (String)topicName)) {
            return false;
        }
        DestroyableJMSTopicService topic = TopicInstaller.deployGlobalTopic((ServiceRegistry)this.getUnit().getServiceRegistry(), (ServiceTarget)this.getGlobalTarget(), (String)topicName, (String[])DestinationUtils.jndiNames((String)topicName, (boolean)false));
        this.createDestinationService(topicName, callback, TopicInstaller.topicServiceName((String)topicName), topic.getReferenceCount());
        return true;
    }

    public boolean destroyDestination(String name, Object callback) {
        boolean success = false;
        ((MessageProcessorGroupizer)((Object)this.messageProcessorGroupizerInjector.getValue())).removeGroupsFor(name);
        ServiceName serviceName = this.destinations.get(name);
        if (serviceName != null) {
            ServiceRegistry registry = this.getUnit().getServiceRegistry();
            ServiceController dest = registry.getService(serviceName);
            if (dest != null) {
                ServiceController globalDest = registry.getService(QueueInstaller.queueServiceName((String)name));
                if (globalDest == null) {
                    globalDest = registry.getService(TopicInstaller.topicServiceName((String)name));
                }
                if (globalDest == null) {
                    throw new IllegalStateException("Failed to find global dest for " + name);
                }
                Service service = globalDest.getService();
                if (service instanceof Destroyable) {
                    ((Destroyable)service).setShouldDestroy(true);
                }
                dest.addListener((ServiceListener)new SimpleServiceStateListener((ClojureRuntime)this.clojureRuntimeInjector.getValue(), callback));
                dest.setMode(ServiceController.Mode.REMOVE);
                success = true;
            }
            this.destinations.remove(name);
        }
        return success;
    }

    protected void createDestinationService(String destName, Object callback, ServiceName globalName, AtomicInteger referenceCount) {
        this.destinations.put(destName, DestinationUtils.deployDestinationPointerService((DeploymentUnit)this.getUnit(), (ServiceTarget)this.getTarget(), (String)destName, (ServiceName)globalName, (AtomicInteger)referenceCount, (ServiceListener[])new ServiceListener[]{new SimpleServiceStateListener((ClojureRuntime)this.clojureRuntimeInjector.getValue(), callback)}));
    }

    public Injector<ClojureRuntime> getClojureRuntimeInjector() {
        return this.clojureRuntimeInjector;
    }

    public Injector<MessageProcessorGroupizer> getMessageProcessorGroupizerInjector() {
        return this.messageProcessorGroupizerInjector;
    }

    public Map<String, ServiceName> getDestinations() {
        return this.destinations;
    }
}

