/*
 * Decompiled with CFR 0.152.
 */
package org.immutant.messaging;

import javax.jms.JMSException;
import javax.jms.XAConnection;
import org.immutant.core.SimpleServiceStateListener;
import org.immutant.messaging.ClojureMessageProcessorService;
import org.immutant.messaging.MessageProcessor;
import org.immutant.messaging.MessageProcessorGroupMBean;
import org.immutant.runtime.ClojureRuntime;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.projectodd.polyglot.messaging.BaseMessageProcessor;
import org.projectodd.polyglot.messaging.BaseMessageProcessorGroup;
import org.projectodd.polyglot.messaging.MessageProcessorService;

public class MessageProcessorGroup
extends BaseMessageProcessorGroup
implements MessageProcessorGroupMBean {
    private final InjectedValue<ClojureRuntime> clojureRuntimeInjector = new InjectedValue();
    private Object setupHandler;
    private Object afterStartCallback;

    public MessageProcessorGroup(ServiceRegistry registry, ServiceName baseServiceName, String destinationName, XAConnection connection, Object setupHandler, Object afterStartCallback) {
        super(registry, baseServiceName, destinationName, MessageProcessor.class);
        this.setStartAsynchronously(false);
        this.setConnection(connection);
        this.setupHandler = setupHandler;
        this.afterStartCallback = afterStartCallback;
    }

    public void start(StartContext context) throws StartException {
        context.getController().addListener((ServiceListener)new SimpleServiceStateListener((ClojureRuntime)this.clojureRuntimeInjector.getValue(), this.afterStartCallback));
        super.start(context);
    }

    protected BaseMessageProcessor instantiateProcessor() {
        return new MessageProcessor((ClojureRuntime)this.clojureRuntimeInjector.getValue());
    }

    protected void startConnection(StartContext context) {
        try {
            this.getConnection().start();
        }
        catch (JMSException e) {
            context.failed(new StartException((Throwable)e));
        }
    }

    protected MessageProcessorService createMessageProcessorService(BaseMessageProcessor processor) {
        return new ClojureMessageProcessorService(this, processor, (ClojureRuntime)this.clojureRuntimeInjector.getValue(), this.setupHandler);
    }

    public void remove(Object callback) {
        ServiceController service = this.getServiceRegistry().getService(this.getBaseServiceName());
        if (service != null) {
            if (callback != null) {
                service.addListener((ServiceListener)new SimpleServiceStateListener((ClojureRuntime)this.clojureRuntimeInjector.getValue(), callback));
            }
            service.setMode(ServiceController.Mode.REMOVE);
        }
    }

    public void remove() {
        this.remove(null);
    }

    public Injector<ClojureRuntime> getClojureRuntimeInjector() {
        return this.clojureRuntimeInjector;
    }
}

