/*
 * Decompiled with CFR 0.152.
 */
package org.immutant.messaging;

import java.util.HashMap;
import java.util.Map;
import org.immutant.core.SimpleServiceStateListener;
import org.immutant.messaging.MessageProcessorGroupizer;
import org.immutant.messaging.QueueService;
import org.immutant.messaging.TopicService;
import org.immutant.runtime.ClojureRuntime;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.projectodd.polyglot.core_extensions.AtRuntimeInstaller;
import org.projectodd.polyglot.messaging.destinations.Destroyable;
import org.projectodd.polyglot.messaging.destinations.DestroyableJMSQueueService;
import org.projectodd.polyglot.messaging.destinations.DestroyableJMSTopicService;
import org.projectodd.polyglot.messaging.destinations.processors.QueueInstaller;
import org.projectodd.polyglot.messaging.destinations.processors.TopicInstaller;

public class Destinationizer
extends AtRuntimeInstaller<Destinationizer> {
    private final InjectedValue<ClojureRuntime> clojureRuntimeInjector = new InjectedValue();
    private final InjectedValue<MessageProcessorGroupizer> messageProcessorGroupizerInjector = new InjectedValue();
    private Map<String, ServiceName> destinations = new HashMap<String, ServiceName>();

    public Destinationizer(DeploymentUnit unit) {
        super(unit);
    }

    public boolean createQueue(String queueName, boolean durable, String selector, Object callback) {
        if (this.destinations.containsKey(queueName)) {
            return false;
        }
        QueueService service = new QueueService(queueName, selector, durable, (ClojureRuntime)this.clojureRuntimeInjector.getValue(), callback);
        this.destinations.put(queueName, QueueInstaller.deploy((ServiceTarget)this.getTarget(), (DestroyableJMSQueueService)service, (String)queueName));
        return true;
    }

    public boolean createTopic(String topicName, Object callback) {
        if (this.destinations.containsKey(topicName)) {
            return false;
        }
        TopicService service = new TopicService(topicName, (ClojureRuntime)this.clojureRuntimeInjector.getValue(), callback);
        this.destinations.put(topicName, TopicInstaller.deploy((ServiceTarget)this.getTarget(), (DestroyableJMSTopicService)service, (String)topicName));
        return true;
    }

    public boolean destroyDestination(String name, Object callback) {
        boolean success = false;
        ((MessageProcessorGroupizer)((Object)this.messageProcessorGroupizerInjector.getValue())).removeGroupsFor(name);
        ServiceName serviceName = this.destinations.get(name);
        if (serviceName != null) {
            ServiceController dest = this.getUnit().getServiceRegistry().getService(serviceName);
            if (dest != null) {
                Service service = dest.getService();
                if (service instanceof Destroyable) {
                    ((Destroyable)service).setShouldDestroy(true);
                }
                dest.addListener((ServiceListener)new SimpleServiceStateListener((ClojureRuntime)this.clojureRuntimeInjector.getValue(), callback));
                dest.setMode(ServiceController.Mode.REMOVE);
                success = true;
            }
            this.destinations.remove(name);
        }
        return success;
    }

    public Injector<ClojureRuntime> getClojureRuntimeInjector() {
        return this.clojureRuntimeInjector;
    }

    public Injector<MessageProcessorGroupizer> getMessageProcessorGroupizerInjector() {
        return this.messageProcessorGroupizerInjector;
    }

    public Map<String, ServiceName> getDestinations() {
        return this.destinations;
    }
}

