/*
 * Decompiled with CFR 0.152.
 */
package org.immutant.messaging.as;

import java.util.List;
import org.immutant.messaging.as.MessagingDependenciesProcessor;
import org.immutant.messaging.processors.DestinationizerInstaller;
import org.immutant.messaging.processors.MessageListenerFactoryInstaller;
import org.immutant.messaging.processors.MessageProcessorGroupizerInstaller;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.DuplicateServiceException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.projectodd.polyglot.messaging.destinations.HornetQStartupPoolService;
import org.projectodd.polyglot.messaging.processors.ApplicationNamingContextBindingProcessor;

class MessagingSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    static final MessagingSubsystemAdd ADD_INSTANCE = new MessagingSubsystemAdd();
    static final Logger log = Logger.getLogger((String)"org.immutant.messaging.as");

    protected void populateModel(ModelNode operation, ModelNode model) {
        model.setEmptyObject();
    }

    protected void performBoottime(final OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                MessagingSubsystemAdd.this.addDeploymentProcessors(processorTarget, context.getServiceTarget());
            }
        }, OperationContext.Stage.RUNTIME);
        this.addHornetQStartupPoolService(context, verificationHandler, newControllers);
    }

    protected void addDeploymentProcessors(DeploymentProcessorTarget processorTarget, ServiceTarget globalTarget) {
        processorTarget.addDeploymentProcessor("immutant-messaging", Phase.DEPENDENCIES, 3, (DeploymentUnitProcessor)new MessagingDependenciesProcessor());
        processorTarget.addDeploymentProcessor("immutant-messaging", Phase.POST_MODULE, 11, (DeploymentUnitProcessor)new ApplicationNamingContextBindingProcessor());
        processorTarget.addDeploymentProcessor("immutant-messaging", Phase.POST_MODULE, 200, (DeploymentUnitProcessor)new DestinationizerInstaller(globalTarget));
        processorTarget.addDeploymentProcessor("immutant-messaging", Phase.POST_MODULE, 201, (DeploymentUnitProcessor)new MessageProcessorGroupizerInstaller());
        processorTarget.addDeploymentProcessor("immutant-messaging", Phase.POST_MODULE, 202, (DeploymentUnitProcessor)new MessageListenerFactoryInstaller());
    }

    protected void addHornetQStartupPoolService(OperationContext context, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        ServiceName hornetQServiceName = MessagingServices.getHornetQServiceName((String)"default");
        ServiceName serviceName = HornetQStartupPoolService.getServiceName((ServiceName)hornetQServiceName);
        HornetQStartupPoolService service = new HornetQStartupPoolService();
        try {
            newControllers.add(context.getServiceTarget().addService(serviceName, (Service)service).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ON_DEMAND).install());
        }
        catch (DuplicateServiceException ignored) {
            // empty catch block
        }
    }

    protected ServiceName getJMSConnectionFactoryServiceName() {
        return ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{"ConnectionFactory"});
    }

    static ModelNode createOperation(ModelNode address) {
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address);
        return subsystem;
    }
}

